/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.common.utils;

import com.beiming.framework.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.i18n.LocaleContextHolder;

public class MyStringUtils {
    public static boolean simpleWildcardMatch(String pattern, String str) {
        return MyStringUtils.wildcardMatch(pattern, str, "*");
    }

    public static boolean wildcardMatch(String pattern, String str, String wildcard) {
        if (StringUtils.isEmpty((String)pattern) || StringUtils.isEmpty((String)str)) {
            return false;
        }
        boolean startWith = pattern.startsWith(wildcard);
        boolean endWith = pattern.endsWith(wildcard);
        String[] array = StringUtils.split((String)pattern, (String)wildcard);
        int currentIndex = -1;
        int lastIndex = -1;
        switch (array.length) {
            case 0: {
                return true;
            }
            case 1: {
                currentIndex = str.indexOf(array[0]);
                if (startWith && endWith) {
                    return currentIndex >= 0;
                }
                if (startWith) {
                    return currentIndex + array[0].length() == str.length();
                }
                if (endWith) {
                    return currentIndex == 0;
                }
                return str.equals(pattern);
            }
        }
        for (String part : array) {
            currentIndex = str.indexOf(part);
            if (currentIndex <= lastIndex) {
                return false;
            }
            lastIndex = currentIndex;
        }
        return true;
    }

    public static String translateCaseNo(String caseNo) {
        if (caseNo == null || "".equals(caseNo)) {
            return caseNo;
        }
        String lang = LocaleContextHolder.getLocale().toString();
        String localeCaseNo = "\uff08#year#\uff09\u591a\u5143\u5316\u89e3#num#\u53f7";
        if ("en_US".equalsIgnoreCase(lang)) {
            localeCaseNo = "(#year#) Diversified Solution #num#";
        } else if ("zh_TW".equalsIgnoreCase(lang)) {
            localeCaseNo = "\uff08#year#\uff09\u591a\u5143\u5316\u89e3#num#\u865f";
        }
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(caseNo);
        String nums = m.replaceAll(" ").trim();
        nums = nums.replaceAll(" +", " ");
        String[] numArr = nums.split(" ");
        localeCaseNo = localeCaseNo.replace("#year#", numArr[0]).replace("#num#", numArr[1]);
        return localeCaseNo;
    }
}

