/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.common.utils;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);

    public static List<String> getFields(Class clazz) {
        ArrayList list = Lists.newArrayList();
        try {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (Arrays.asList("serialVersionUID", "order").contains(f.getName())) continue;
                list.add(f.getName());
            }
            return list;
        }
        catch (Exception e) {
            log.error("ClassUtil getFields fail,   clazz : {}", (Object)clazz);
            return null;
        }
    }

    public static List<String> getListTypesFields(Class clazz) {
        ArrayList list = Lists.newArrayList();
        try {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (!f.getType().equals(List.class)) continue;
                list.add(f.getName());
            }
            return list;
        }
        catch (Exception e) {
            log.error("ClassUtil getListTypesFields fail,   clazz : {}", (Object)clazz);
            return null;
        }
    }

    public static Object getFieldValueByFieldName(String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            log.error("ClassUtil getFieldValueByFieldName fail,   fieldName : {}, object : {}", (Object)fieldName, object);
            return null;
        }
    }

    public static List getFieldListValueByFieldName(String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (List)field.get(object);
        }
        catch (Exception e) {
            log.error("ClassUtil getFieldListValueByFieldName fail,   fieldName : {}, object : {}", (Object)fieldName, object);
            return null;
        }
    }
}

