/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.convert;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.utils.MyStringUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseProtocolPersonnelRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveJudicialConfirmBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SavePromiseBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SendFinalMediationReportRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.CaseProtocolPersonnelResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.CaseWholeConfirmResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationSchemeResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.PromiseResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.UnanimityMediationSchemeResponseDTO;
import com.beiming.odr.referee.dto.requestdto.CaseProtocolPersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveJudicialConfirmBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveProtocolBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SendFinalMediationReportReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseWholeConfirmResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationSchemeResDTO;
import com.beiming.odr.referee.dto.responsedto.PromiseResDTO;
import com.beiming.odr.referee.dto.responsedto.ProtocolBookResDTO;
import com.beiming.odr.referee.dto.responsedto.UnanimityMediationSchemeResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class DocumentConvert {
    public static ProtocolBookResponseDTO getProtocolBookResponseDTO(ProtocolBookResDTO protocolBook) {
        ProtocolBookResponseDTO responseDTO = new ProtocolBookResponseDTO();
        responseDTO.setProtocolId(protocolBook.getProtocolId());
        responseDTO.setCaseNo(MyStringUtils.translateCaseNo((String)protocolBook.getCaseNo()));
        List<CaseProtocolPersonnelResponseDTO> applicantList = DocumentConvert.getCaseProtocolPersonnelResponseDTOList(protocolBook.getApplicantList());
        responseDTO.setApplicantList(applicantList);
        List<CaseProtocolPersonnelResponseDTO> respondentList = DocumentConvert.getCaseProtocolPersonnelResponseDTOList(protocolBook.getRespondentList());
        responseDTO.setRespondentList(respondentList);
        responseDTO.setContent(protocolBook.getContent());
        responseDTO.setExtendJson(protocolBook.getExtendJson());
        responseDTO.setSendStatus(protocolBook.getSendStatus());
        responseDTO.setApplicantView(protocolBook.getApplicantView());
        responseDTO.setRespondentView(protocolBook.getRespondentView());
        responseDTO.setFinalMediationReason(protocolBook.getFinalMediationReason());
        responseDTO.setMediator(protocolBook.getMediator());
        responseDTO.setStatus(protocolBook.getStatus());
        responseDTO.setRemark(protocolBook.getRemark());
        if (protocolBook.getProtocolId() != null) {
            List<CaseWholeConfirmResponseDTO> confirmList = DocumentConvert.getCaseWholeConfirmResponseDTOList(protocolBook.getConfirmList());
            responseDTO.setConfirmList(confirmList);
        }
        return responseDTO;
    }

    public static List<CaseProtocolPersonnelResponseDTO> getCaseProtocolPersonnelResponseDTOList(List<CaseProtocolPersonnelResDTO> list) {
        ArrayList responseDTOList = Lists.newArrayList();
        for (CaseProtocolPersonnelResDTO resDTO : list) {
            CaseProtocolPersonnelResponseDTO dto = new CaseProtocolPersonnelResponseDTO();
            dto.setPersonnelId(resDTO.getPersonnelId());
            dto.setCaseUserType(resDTO.getCaseUserType());
            dto.setUserId(resDTO.getUserId());
            dto.setName(resDTO.getUserName());
            dto.setUserType(resDTO.getUserType());
            dto.setPhone(resDTO.getPhone());
            dto.setSex(resDTO.getSex());
            if (StringUtils.isNotBlank((CharSequence)resDTO.getIdCard())) {
                dto.setIdCard(resDTO.getIdCard());
            } else {
                dto.setIdCard(null);
            }
            dto.setProvCode(resDTO.getProvCode());
            dto.setCityCode(resDTO.getCityCode());
            dto.setAreaCode(resDTO.getAreaCode());
            dto.setStreetCode(resDTO.getStreetCode());
            dto.setProvName(resDTO.getProvName());
            dto.setCityName(resDTO.getCityName());
            dto.setAreaName(resDTO.getAreaName());
            dto.setStreetName(resDTO.getStreetName());
            dto.setAddress(resDTO.getAddress());
            dto.setNationCode(resDTO.getNationCode());
            dto.setNationName(resDTO.getNationName());
            ArrayList areaList = Lists.newArrayList();
            areaList.add(resDTO.getNationCode());
            areaList.add(resDTO.getProvCode());
            areaList.add(resDTO.getCityCode());
            areaList.add(resDTO.getAreaCode());
            areaList.add(resDTO.getStreetCode());
            dto.setAreaList((List)areaList);
            dto.setCreditCode(resDTO.getCreditCode());
            dto.setCorporation(resDTO.getCorporation());
            dto.setOrder(resDTO.getUserOrder());
            dto.setAgentId(resDTO.getAgentId());
            dto.setAgentType(resDTO.getAgentType());
            dto.setAgentName(resDTO.getAgentName());
            dto.setAgentSex(resDTO.getAgentSex());
            dto.setAgentPhone(resDTO.getAgentPhone());
            dto.setAgentIdCard(resDTO.getAgentIdCard());
            dto.setEmail(resDTO.getEmail());
            dto.setCardType(resDTO.getCardType());
            dto.setAgentCardType(resDTO.getAgentCardType());
            dto.setNationality(resDTO.getNationality());
            dto.setAgentNationality(resDTO.getAgentNationality());
            dto.setAgentNation(resDTO.getAgentNation());
            dto.setNation(resDTO.getNation());
            dto.setAgentEmail(resDTO.getAgentEmail());
            dto.setAgentNationName(resDTO.getAgentNationName());
            dto.setAgentNationCode(resDTO.getAgentNationCode());
            dto.setAgentProvCode(resDTO.getAgentProvCode());
            dto.setAgentProvName(resDTO.getAgentProvName());
            dto.setAgentCityCode(resDTO.getAgentCityCode());
            dto.setAgentCityName(resDTO.getAgentCityName());
            dto.setAgentAreaCode(resDTO.getAgentAreaCode());
            dto.setAgentAreaName(resDTO.getAgentAreaName());
            dto.setAgentStreetCode(resDTO.getAgentStreetCode());
            dto.setAgentStreetName(resDTO.getAgentStreetName());
            dto.setAgentAddress(resDTO.getAgentAddress());
            dto.setNationCode(resDTO.getNationCode());
            dto.setNationName(resDTO.getNationName());
            responseDTOList.add(dto);
        }
        return responseDTOList;
    }

    public static List<CaseWholeConfirmResponseDTO> getCaseWholeConfirmResponseDTOList(List<CaseWholeConfirmResDTO> list) {
        ArrayList responseDTOList = Lists.newArrayList();
        for (CaseWholeConfirmResDTO resDTO : list) {
            CaseWholeConfirmResponseDTO dto = new CaseWholeConfirmResponseDTO();
            dto.setUserId(resDTO.getUserId());
            dto.setUserName(resDTO.getUserName());
            dto.setUserType(resDTO.getUserType());
            dto.setConfirmStatus(resDTO.getConfirmStatus());
            responseDTOList.add(dto);
        }
        return responseDTOList;
    }

    public static SaveProtocolBookReqDTO getSaveProtocolBookReqDTO(SaveProtocolBookRequestDTO requestDTO) {
        SaveProtocolBookReqDTO reqDTO = new SaveProtocolBookReqDTO();
        reqDTO.setProtocolId(requestDTO.getProtocolId());
        reqDTO.setCaseId(requestDTO.getCaseId());
        reqDTO.setDocumentType(requestDTO.getDocumentType());
        reqDTO.setCaseNo(requestDTO.getCaseNo());
        reqDTO.setContent(requestDTO.getContent());
        reqDTO.setExtendJson(requestDTO.getExtendJson());
        reqDTO.setApplicantView(requestDTO.getApplicantView());
        reqDTO.setRespondentView(requestDTO.getRespondentView());
        reqDTO.setFinalMediationReason(requestDTO.getFinalMediationReason());
        ArrayList allPersonnel = Lists.newArrayList();
        allPersonnel.addAll(requestDTO.getApplicantList());
        allPersonnel.addAll(requestDTO.getRespondentList());
        List<CaseProtocolPersonnelReqDTO> personnelList = DocumentConvert.getCaseProtocolPersonnelReqDTOList(allPersonnel);
        reqDTO.setPersonnelList(personnelList);
        return reqDTO;
    }

    public static List<CaseProtocolPersonnelReqDTO> getCaseProtocolPersonnelReqDTOList(List<CaseProtocolPersonnelRequestDTO> allPersonnel) {
        ArrayList personnelList = Lists.newArrayList();
        for (CaseProtocolPersonnelRequestDTO requestDTO : allPersonnel) {
            CaseProtocolPersonnelReqDTO reqDTO = new CaseProtocolPersonnelReqDTO();
            reqDTO.setPersonnelId(requestDTO.getPersonnelId());
            reqDTO.setCaseUserType(requestDTO.getCaseUserType());
            reqDTO.setUserId(requestDTO.getUserId());
            reqDTO.setUserName(requestDTO.getName());
            reqDTO.setUserType(requestDTO.getUserType());
            reqDTO.setPhone(requestDTO.getPhone());
            reqDTO.setSex(requestDTO.getSex());
            reqDTO.setIdCard(requestDTO.getIdCard());
            reqDTO.setProvCode(requestDTO.getProvCode());
            reqDTO.setCityCode(requestDTO.getCityCode());
            reqDTO.setAreaCode(requestDTO.getAreaCode());
            reqDTO.setStreetCode(requestDTO.getStreetCode());
            reqDTO.setProvName(requestDTO.getProvName());
            reqDTO.setCityName(requestDTO.getCityName());
            reqDTO.setAreaName(requestDTO.getAreaName());
            reqDTO.setStreetName(requestDTO.getStreetName());
            reqDTO.setAddress(requestDTO.getAddress());
            reqDTO.setCreditCode(requestDTO.getCreditCode());
            reqDTO.setCorporation(requestDTO.getCorporation());
            reqDTO.setOrder(requestDTO.getOrder());
            reqDTO.setAgentId(requestDTO.getAgentId());
            reqDTO.setAgentType(null == requestDTO.getAgentType() ? null : requestDTO.getAgentType().name());
            reqDTO.setAgentName(requestDTO.getAgentName());
            reqDTO.setAgentSex(requestDTO.getAgentSex());
            reqDTO.setAgentIdCard(requestDTO.getAgentIdCard());
            reqDTO.setAgentPhone(requestDTO.getAgentPhone());
            reqDTO.setEmail(requestDTO.getEmail());
            reqDTO.setAgentEmail(requestDTO.getAgentEmail());
            reqDTO.setCardType(requestDTO.getCardType());
            reqDTO.setAgentCardType(requestDTO.getAgentCardType());
            reqDTO.setNationality(requestDTO.getNationality());
            reqDTO.setAgentNationality(requestDTO.getAgentNationality());
            reqDTO.setNation(requestDTO.getNation());
            reqDTO.setAgentNation(requestDTO.getAgentNation());
            reqDTO.setNationCode(requestDTO.getNationCode());
            reqDTO.setNationName(requestDTO.getNationName());
            personnelList.add(reqDTO);
        }
        return personnelList;
    }

    public static UnanimityMediationSchemeResponseDTO getUnanimityMediationSchemeResponseDTO(UnanimityMediationSchemeResDTO mediationScheme) {
        UnanimityMediationSchemeResponseDTO responseDTO = new UnanimityMediationSchemeResponseDTO();
        MediationSchemeResponseDTO mediationSchemeResponseDTO = DocumentConvert.getMediationSchemeResponseDTO(mediationScheme.getMediationSchemeRes());
        PromiseResponseDTO promise = new PromiseResponseDTO();
        PromiseResDTO resDTO = mediationScheme.getPromiseRes();
        if (resDTO != null) {
            promise.setApplicantName(resDTO.getApplicantName());
            promise.setRespondentName(resDTO.getRespondentName());
            promise.setApplicantContent(resDTO.getApplicantContent());
            promise.setRespondentContent(resDTO.getRespondentContent());
            responseDTO.setPromiseResponse(promise);
        } else {
            responseDTO.setPromiseResponse(null);
        }
        responseDTO.setMediationSchemeResponse(mediationSchemeResponseDTO);
        return responseDTO;
    }

    public static MediationSchemeResponseDTO getMediationSchemeResponseDTO(MediationSchemeResDTO resDTO) {
        MediationSchemeResponseDTO responseDTO = new MediationSchemeResponseDTO();
        responseDTO.setProtocolId(resDTO.getId());
        responseDTO.setCaseNo(MyStringUtils.translateCaseNo((String)resDTO.getCaseNo()));
        List<CaseProtocolPersonnelResponseDTO> applicantList = DocumentConvert.getCaseProtocolPersonnelResponseDTOList(resDTO.getApplicantList());
        responseDTO.setApplicantList(applicantList);
        List<CaseProtocolPersonnelResponseDTO> respondentList = DocumentConvert.getCaseProtocolPersonnelResponseDTOList(resDTO.getRespondentList());
        responseDTO.setRespondentList(respondentList);
        responseDTO.setContent(resDTO.getMediationScheme());
        responseDTO.setExtendJson(resDTO.getMediationNeeds());
        responseDTO.setSendStatus(resDTO.getSendStatus());
        if (resDTO.getId() != null) {
            List<CaseWholeConfirmResponseDTO> confirmList = DocumentConvert.getCaseWholeConfirmResponseDTOList(resDTO.getConfirmList());
            responseDTO.setConfirmList(confirmList);
        }
        return responseDTO;
    }

    public static SavePromiseBookReqDTO getSavePromiseBookReqDTO(SavePromiseBookRequestDTO requestDTO) {
        SavePromiseBookReqDTO reqDTO = new SavePromiseBookReqDTO();
        reqDTO.setCaseId(requestDTO.getCaseId());
        reqDTO.setApplicantContent(requestDTO.getApplicantContent());
        reqDTO.setRespondentContent(requestDTO.getRespondentContent());
        return reqDTO;
    }

    public static SaveJudicialConfirmBookReqDTO getSaveJudicialConfirmBookReqDTO(SaveJudicialConfirmBookRequestDTO dto) {
        SaveJudicialConfirmBookReqDTO reqDTO = new SaveJudicialConfirmBookReqDTO();
        return reqDTO;
    }

    public static SendFinalMediationReportReqDTO getSendFinalMediationReportReqDTO(SendFinalMediationReportRequestDTO dto) {
        SendFinalMediationReportReqDTO reqDTO = new SendFinalMediationReportReqDTO();
        reqDTO.setCaseId(dto.getCaseId());
        return reqDTO;
    }
}

