/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.convert;

import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.JudicialConfirmPersonnelRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveMediationApplyBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.CaseProtocolPersonnelResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.CaseWholeConfirmResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationApplyBookResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.convert.DocumentConvert;
import com.beiming.odr.referee.dto.requestdto.JudicialConfirmPersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveMediationApplyBookReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationApplyBookResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class MediationApplyConvert {
    public static MediationApplyBookResponseDTO getMediationApplyBookResponseDTO(MediationApplyBookResDTO res) {
        MediationApplyBookResponseDTO response = new MediationApplyBookResponseDTO();
        response.setCaseId(res.getCaseId());
        response.setDocId(res.getDocId());
        List<CaseProtocolPersonnelResponseDTO> personnelList = MediationApplyConvert.getJudicialPersonnelList(res.getApplicantList(), res.getRespondentList());
        response.setPersonnelList(personnelList);
        response.setRequestContent(res.getRequestContent());
        response.setFactAndReason(res.getFactAndReason());
        response.setAreaCode(res.getAreaCode());
        response.setAreaName(res.getAreaName());
        response.setCourtCode(res.getCourtCode());
        response.setCourtName(res.getCourtName());
        response.setCauseCode(res.getCauseCode());
        response.setCauseName(res.getCauseName());
        response.setCaseTypeCode(res.getCaseTypeCode());
        response.setCaseTypeName(res.getCaseTypeName());
        response.setSendStatus(res.getSendStatus());
        if (res.getDocId() != null) {
            List<CaseWholeConfirmResponseDTO> confirmList = DocumentConvert.getCaseWholeConfirmResponseDTOList(res.getConfirmList());
            response.setConfirmList(confirmList);
        }
        return response;
    }

    public static List<CaseProtocolPersonnelResponseDTO> getJudicialPersonnelList(List<CaseProtocolPersonnelResDTO> applicantList, List<CaseProtocolPersonnelResDTO> respondentList) {
        CaseProtocolPersonnelResponseDTO response;
        ArrayList list = Lists.newArrayList();
        for (CaseProtocolPersonnelResDTO resDTO : applicantList) {
            response = MediationApplyConvert.getJudicialConfirmPersonnelResponseDTO(resDTO);
            list.add(response);
        }
        for (CaseProtocolPersonnelResDTO resDTO : respondentList) {
            response = MediationApplyConvert.getJudicialConfirmPersonnelResponseDTO(resDTO);
            list.add(response);
        }
        return list;
    }

    public static CaseProtocolPersonnelResponseDTO getJudicialConfirmPersonnelResponseDTO(CaseProtocolPersonnelResDTO resDTO) {
        CaseProtocolPersonnelResponseDTO response = new CaseProtocolPersonnelResponseDTO();
        response.setPersonnelId(resDTO.getPersonnelId());
        response.setCaseUserType(resDTO.getCaseUserType());
        response.setUserId(resDTO.getUserId());
        response.setName(resDTO.getUserName());
        response.setUserType(resDTO.getUserType());
        response.setPhone(resDTO.getPhone());
        response.setSex(resDTO.getSex());
        response.setIdCard(StringUtils.isNotBlank((CharSequence)resDTO.getIdCard()) ? resDTO.getIdCard() : null);
        response.setProvCode(resDTO.getProvCode());
        response.setCityCode(resDTO.getCityCode());
        response.setAreaCode(resDTO.getAreaCode());
        response.setStreetCode(resDTO.getStreetCode());
        response.setProvName(resDTO.getProvName());
        response.setCityName(resDTO.getCityName());
        response.setAreaName(resDTO.getAreaName());
        response.setStreetName(resDTO.getStreetName());
        ArrayList areaList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)resDTO.getProvCode())) {
            areaList.add(resDTO.getProvCode());
        }
        if (StringUtils.isNotBlank((CharSequence)resDTO.getCityCode())) {
            areaList.add(resDTO.getCityCode());
        }
        if (StringUtils.isNotBlank((CharSequence)resDTO.getAreaCode())) {
            areaList.add(resDTO.getAreaCode());
        }
        if (StringUtils.isNotBlank((CharSequence)resDTO.getStreetCode())) {
            areaList.add(resDTO.getStreetCode());
        }
        response.setAreaList((List)areaList);
        response.setAddress(resDTO.getAddress());
        response.setCreditCode(resDTO.getCreditCode());
        response.setCorporation(resDTO.getCorporation());
        response.setOrder(resDTO.getUserOrder());
        response.setAgentId(resDTO.getAgentId());
        response.setAgentType(resDTO.getAgentType());
        response.setAgentName(resDTO.getAgentName());
        response.setAgentSex(resDTO.getAgentSex());
        response.setAgentIdCard(StringUtils.isNotBlank((CharSequence)resDTO.getAgentIdCard()) ? resDTO.getAgentIdCard() : null);
        response.setAgentPhone(resDTO.getAgentPhone());
        return response;
    }

    public static SaveMediationApplyBookReqDTO getSaveMediationApplyBookReqDTO(SaveMediationApplyBookRequestDTO dto) {
        SaveMediationApplyBookReqDTO reqDTO = new SaveMediationApplyBookReqDTO();
        reqDTO.setDocId(dto.getDocId());
        reqDTO.setCaseId(dto.getCaseId());
        ArrayList personnelList = Lists.newArrayList();
        for (JudicialConfirmPersonnelRequestDTO requestDTO : dto.getPersonnelList()) {
            JudicialConfirmPersonnelReqDTO personnel = new JudicialConfirmPersonnelReqDTO();
            personnel.setPersonnelId(requestDTO.getPersonnelId());
            personnel.setCaseUserType(requestDTO.getCaseUserType());
            personnel.setUserId(requestDTO.getUserId());
            personnel.setName(requestDTO.getName());
            personnel.setUserType(requestDTO.getUserType());
            personnel.setPhone(requestDTO.getPhone());
            personnel.setSex(requestDTO.getSex());
            personnel.setIdCard(requestDTO.getIdCard());
            personnel.setProvCode(requestDTO.getProvCode());
            personnel.setCityCode(requestDTO.getCityCode());
            personnel.setAreaCode(requestDTO.getAreaCode());
            personnel.setStreetCode(requestDTO.getStreetCode());
            personnel.setProvName(requestDTO.getProvName());
            personnel.setCityName(requestDTO.getCityName());
            personnel.setAreaName(requestDTO.getAreaName());
            personnel.setStreetName(requestDTO.getStreetName());
            personnel.setAddress(requestDTO.getAddress());
            personnel.setCreditCode(requestDTO.getCreditCode());
            personnel.setCorporation(requestDTO.getCorporation());
            personnel.setAgentId(requestDTO.getAgentId());
            personnel.setAgentType(null == requestDTO.getAgentType() ? null : requestDTO.getAgentType().name());
            personnel.setAgentName(requestDTO.getAgentName());
            personnel.setAgentSex(requestDTO.getAgentSex());
            personnel.setAgentIdCard(requestDTO.getAgentIdCard());
            personnel.setAgentPhone(requestDTO.getAgentPhone());
            personnel.setOrder(requestDTO.getOrder());
            personnelList.add(personnel);
        }
        reqDTO.setPersonnelList((List)personnelList);
        reqDTO.setRequestContent(dto.getRequestContent());
        reqDTO.setFactAndReason(dto.getFactAndReason());
        reqDTO.setAreaCode(dto.getAreaCode());
        reqDTO.setAreaName(dto.getAreaName());
        reqDTO.setCourtCode(dto.getCourtCode());
        reqDTO.setCourtName(dto.getCourtName());
        reqDTO.setCauseCode(dto.getCauseCode());
        reqDTO.setCauseName(dto.getCauseName());
        reqDTO.setCaseTypeCode(dto.getCaseTypeCode());
        reqDTO.setCaseTypeName(dto.getCaseTypeName());
        reqDTO.setCreateId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        return reqDTO;
    }
}

