/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.convert;

import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.mastiff.common.utils.MastiffMsgUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationInfoRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationActualResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseProgressResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationDocumentResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationInfoResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationMeetingResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationProgressResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.PetitionAgentResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.WorkbenchDocStatusResponseDTO;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.MediationCaseProgressDTO;
import com.beiming.odr.referee.dto.PetitionAgentDTO;
import com.beiming.odr.referee.dto.requestdto.MediationInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationProgressReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingDocumentResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationActualResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationProgressResDTO;
import com.beiming.odr.referee.dto.responsedto.WorkbenchDocStatusResDTO;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class MediationInfoConvert {
    public static MediationInfoReqDTO convertToMediationInfoReqDTO(MediationInfoRequestDTO requestDTO) {
        MediationInfoReqDTO reqDTO = new MediationInfoReqDTO();
        reqDTO.setLawCaseId(requestDTO.getLawCaseId());
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        return reqDTO;
    }

    public static MediationProgressReqDTO convertToMediationProgressReqDTO(MediationInfoRequestDTO requestDTO) {
        MediationProgressReqDTO reqDTO = new MediationProgressReqDTO();
        reqDTO.setLawCaseId(requestDTO.getLawCaseId());
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        return reqDTO;
    }

    public static MediationInfoResponseDTO convertToMediationInfoResponseDTO(MediationInfoResDTO resDTO) {
        MediationInfoResponseDTO responseDTO = new MediationInfoResponseDTO();
        responseDTO.setCurrentCaseUserType(resDTO.getCurrentCaseUserType());
        responseDTO.setCaseId(resDTO.getCaseId());
        responseDTO.setCaseNo(resDTO.getCaseNo());
        responseDTO.setCiteCaseType(resDTO.getCiteCaseType());
        responseDTO.setCreateTime(resDTO.getCreateTime());
        responseDTO.setCreatorId(resDTO.getCreatorId());
        responseDTO.setLawCaseStatus(resDTO.getLawCaseStatus());
        responseDTO.setLawCaseStatusCode(resDTO.getLawCaseStatusCode());
        responseDTO.setOrigin(resDTO.getOrigin());
        responseDTO.setOrgId(resDTO.getOrgId());
        responseDTO.setOrgName(resDTO.getOrgName());
        responseDTO.setOrgAreaCode(resDTO.getOrgAreaCode());
        responseDTO.setOrgConfirm(String.valueOf(resDTO.getOrgConfirm()));
        responseDTO.setAppeal(resDTO.getAppeal());
        responseDTO.setMediationType(resDTO.getMediationType());
        responseDTO.setDisputeType(resDTO.getDisputeType());
        responseDTO.setDisputeTypeCode(resDTO.getDisputeTypeCode());
        responseDTO.setDisputeContent(resDTO.getDisputeContent());
        responseDTO.setTab(resDTO.getTab());
        responseDTO.setProvCode(resDTO.getProvCode());
        responseDTO.setCityCode(resDTO.getCityCode());
        responseDTO.setAreaCode(resDTO.getAreaCode());
        responseDTO.setStreetCode(resDTO.getStreetCode());
        responseDTO.setCommunityCode(resDTO.getCommunityCode());
        responseDTO.setProvName(StringUtils.isEmpty((CharSequence)resDTO.getProvName()) ? "" : resDTO.getProvName());
        responseDTO.setCityName(StringUtils.isEmpty((CharSequence)resDTO.getCityName()) ? "" : resDTO.getCityName());
        responseDTO.setAreaName(StringUtils.isEmpty((CharSequence)resDTO.getAreaName()) ? "" : resDTO.getAreaName());
        responseDTO.setStreetName(StringUtils.isEmpty((CharSequence)resDTO.getStreetName()) ? "" : resDTO.getStreetName());
        responseDTO.setCommunityName(resDTO.getCommunityName());
        responseDTO.setAddress(resDTO.getAddress());
        responseDTO.setNationCode(resDTO.getNationCode());
        responseDTO.setNationName(resDTO.getNationName());
        responseDTO.setExtendable(resDTO.getExtendable());
        responseDTO.setExtendConformable(resDTO.getExtendConformable());
        List<MediationActualResponseDTO> applicants = MediationInfoConvert.convertToMediationActualResponseDTO(resDTO.getApplicants());
        List<MediationActualResponseDTO> respondents = MediationInfoConvert.convertToMediationActualResponseDTO(resDTO.getRespondents());
        List<MediationActualResponseDTO> mediators = MediationInfoConvert.convertToMeditorResponseDTO(resDTO.getMediators());
        responseDTO.setApplicants(applicants);
        responseDTO.setRespondents(respondents);
        responseDTO.setMediators(mediators);
        PetitionAgentDTO petitionAgentUser = resDTO.getPetitionAgentUser();
        PetitionAgentResponseDTO petitionAgent = new PetitionAgentResponseDTO();
        petitionAgent.setUserId(petitionAgentUser.getUserId());
        petitionAgent.setUserName(petitionAgentUser.getUserName());
        petitionAgent.setIdCard(petitionAgentUser.getIdCard());
        petitionAgent.setPhone(petitionAgentUser.getPhone());
        petitionAgent.setSex(petitionAgentUser.getSex());
        petitionAgent.setProxyId(petitionAgentUser.getProxyId());
        petitionAgent.setProxyFileId(petitionAgentUser.getProxyFileId());
        petitionAgent.setProxyFileName(petitionAgentUser.getProxyFileName());
        responseDTO.setPetitionAgentUser(petitionAgent);
        List<MediationDocumentResponseDTO> documents = MediationInfoConvert.convertToMediationDocumentResponseDTO(resDTO.getDocuments());
        for (MediationDocumentResponseDTO data : documents) {
            if (data.getAllowOppugnUserType() != null && data.getAllowOppugnUserType().equals(resDTO.getCurrentCaseUserType()) && data.getAuthenticity() == null) {
                data.setAllowOppugnUserType("true");
                continue;
            }
            data.setAllowOppugnUserType("false");
        }
        List<MediationMeetingResponseDTO> videos = MediationInfoConvert.convertToMediationMeetingResponseDTO(resDTO.getVideos());
        List<MediationCaseProgressResponseDTO> progress = MediationInfoConvert.convertToMediationCaseProgressResponseDTO(resDTO.getProgress());
        List<WorkbenchDocStatusResponseDTO> workbenchs = MediationInfoConvert.convertToWorkbenchDocStatusResponseDTO(resDTO.getWorkbenchs());
        responseDTO.setDocuments(documents);
        responseDTO.setVideos(videos);
        responseDTO.setProgress(progress);
        responseDTO.setWorkbenchs(workbenchs);
        responseDTO.setCancelAudit(resDTO.getCancelAudit());
        return responseDTO;
    }

    public static List<MediationProgressResponseDTO> convertToMediationProgressResponseDTO(List<MediationProgressResDTO> resLstDTO) {
        ArrayList<MediationProgressResponseDTO> responseLstDTO = new ArrayList<MediationProgressResponseDTO>();
        for (MediationProgressResDTO resDTO : resLstDTO) {
            MediationProgressResponseDTO responseDTO = new MediationProgressResponseDTO();
            String status = resDTO.getStatus();
            responseDTO.setStatus(status);
            if (!StringUtils.isBlank((CharSequence)status)) {
                responseDTO.setStatusName(MastiffMsgUtils.get((String)("referee.CaseProgressEnum." + CaseProgressEnum.valueOf((String)status))));
            }
            String caseStatus = resDTO.getCaseStatus();
            responseDTO.setCaseStatus(caseStatus);
            if (!StringUtils.isBlank((CharSequence)caseStatus)) {
                responseDTO.setCaseStatusName(CaseStatusEnum.valueOf((String)caseStatus).getName());
            }
            responseDTO.setContent(resDTO.getContent());
            responseDTO.setDocumentId(resDTO.getDocumentId());
            responseDTO.setPersonnels(resDTO.getPersonnels());
            responseDTO.setProgressJson(resDTO.getProgressJson());
            responseDTO.setTime(resDTO.getTime());
            responseLstDTO.add(responseDTO);
        }
        return responseLstDTO;
    }

    private static List<MediationActualResponseDTO> convertToMediationActualResponseDTO(List<MediationCasePersonnelDTO> resLstDTO) {
        ArrayList<MediationActualResponseDTO> actualPerLstDTO = new ArrayList<MediationActualResponseDTO>();
        if (CollectionUtils.isEmpty(resLstDTO)) {
            return actualPerLstDTO;
        }
        for (MediationCasePersonnelDTO resDTO : resLstDTO) {
            MediationActualResponseDTO actualPerDTO = new MediationActualResponseDTO();
            actualPerDTO.setId(resDTO.getId());
            actualPerDTO.setUserId(resDTO.getUserId());
            actualPerDTO.setCaseUserType(resDTO.getCaseUserType());
            actualPerDTO.setUserType(resDTO.getUserType());
            actualPerDTO.setSex(resDTO.getSex());
            actualPerDTO.setUserName(resDTO.getName());
            actualPerDTO.setIdCard(resDTO.getIdCard());
            actualPerDTO.setPhone(resDTO.getPhone());
            actualPerDTO.setTelephone(resDTO.getTelephone());
            actualPerDTO.setProvCode(resDTO.getProvCode());
            actualPerDTO.setCityCode(resDTO.getCityCode());
            actualPerDTO.setAreaCode(resDTO.getAreaCode());
            actualPerDTO.setStreetCode(resDTO.getStreetCode());
            actualPerDTO.setProvName(resDTO.getProvName());
            actualPerDTO.setCityName(resDTO.getCityName());
            actualPerDTO.setAreaName(resDTO.getAreaName());
            actualPerDTO.setStreetName(resDTO.getStreetName());
            actualPerDTO.setAddress(resDTO.getAddress());
            actualPerDTO.setCreditCode(resDTO.getCreditCode());
            actualPerDTO.setCorporation(resDTO.getCorporation());
            actualPerDTO.setAgentId(resDTO.getAgentId());
            actualPerDTO.setAgentType(resDTO.getAgentType());
            actualPerDTO.setAgentName(resDTO.getAgentName());
            actualPerDTO.setAgentSex(resDTO.getAgentSex());
            actualPerDTO.setAgentIdCard(resDTO.getAgentIdCard());
            actualPerDTO.setAgentPhone(resDTO.getAgentPhone());
            actualPerDTO.setProxyId(resDTO.getProxyId());
            actualPerDTO.setProxyFileId(resDTO.getProxyFileId());
            actualPerDTO.setProxyFileName(resDTO.getProxyFileName());
            actualPerDTO.setApprovalStatus(resDTO.getApprovalStatus());
            actualPerDTO.setCardType(resDTO.getCardType());
            actualPerDTO.setCardTypeName(resDTO.getCardTypeName());
            actualPerDTO.setAgentCardTypeName(resDTO.getAgentCardTypeName());
            actualPerDTO.setIsRealName(resDTO.getIsRealName());
            actualPerDTO.setIsAgentRealName(resDTO.getIsAgentRealName());
            actualPerDTO.setAgentCardType(resDTO.getAgentCardType());
            actualPerDTO.setNationality(resDTO.getNationality());
            actualPerDTO.setAgentNationality(resDTO.getAgentNationality());
            actualPerDTO.setNation(resDTO.getNation());
            actualPerDTO.setAgentNation(resDTO.getAgentNation());
            actualPerDTO.setVideoAuthenticationFlag(resDTO.getVideoAuthenticationFlag());
            actualPerDTO.setAgentVideoAuthenticationFlag(resDTO.getAgentVideoAuthenticationFlag());
            actualPerDTO.setEmail(resDTO.getEmail());
            actualPerDTO.setAgentEmail(resDTO.getAgentEmail());
            actualPerDTO.setNationName(resDTO.getNationName());
            actualPerDTO.setNationCode(resDTO.getNationCode());
            actualPerDTO.setAgentNationCode(resDTO.getAgentNationCode());
            actualPerDTO.setAgentNationName(resDTO.getAgentNationName());
            actualPerDTO.setAgentProvCode(resDTO.getAgentProvCode());
            actualPerDTO.setAgentProvName(resDTO.getAgentProvName());
            actualPerDTO.setAgentCityCode(resDTO.getAgentCityCode());
            actualPerDTO.setAgentCityName(resDTO.getAgentCityName());
            actualPerDTO.setAgentAreaCode(resDTO.getAgentAreaCode());
            actualPerDTO.setAgentAreaName(resDTO.getAgentAreaName());
            actualPerDTO.setAgentStreetCode(resDTO.getAgentStreetCode());
            actualPerDTO.setAgentStreetName(resDTO.getAgentStreetName());
            actualPerDTO.setAgentAddress(resDTO.getAgentAddress());
            actualPerLstDTO.add(actualPerDTO);
        }
        return actualPerLstDTO;
    }

    private static List<MediationActualResponseDTO> convertToMeditorResponseDTO(List<MediationActualResDTO> resLstDTO) {
        ArrayList<MediationActualResponseDTO> actualPerLstDTO = new ArrayList<MediationActualResponseDTO>();
        if (CollectionUtils.isEmpty(resLstDTO)) {
            return actualPerLstDTO;
        }
        for (MediationActualResDTO resDTO : resLstDTO) {
            MediationActualResponseDTO actualPerDTO = new MediationActualResponseDTO();
            actualPerDTO.setUserId(resDTO.getUserId());
            actualPerDTO.setUserName(resDTO.getName());
            actualPerDTO.setIdCard(resDTO.getIdCard());
            actualPerDTO.setPhone(resDTO.getPhone());
            actualPerDTO.setProvCode(resDTO.getProvCode());
            actualPerDTO.setCityCode(resDTO.getCityCode());
            actualPerDTO.setAreaCode(resDTO.getAreaCode());
            actualPerDTO.setStreetCode(resDTO.getStreetCode());
            actualPerDTO.setProvName(resDTO.getProvName());
            actualPerDTO.setCityName(resDTO.getCityName());
            actualPerDTO.setAreaName(resDTO.getAreaName());
            actualPerDTO.setStreetName(resDTO.getStreetName());
            actualPerDTO.setAddress(resDTO.getAddress());
            actualPerDTO.setEducation(resDTO.getEducation());
            actualPerDTO.setCompanyName(resDTO.getCompanyName());
            actualPerDTO.setAbility(resDTO.getAbility());
            actualPerDTO.setOccupation(resDTO.getOccupation());
            actualPerDTO.setExperience(resDTO.getExperience());
            actualPerDTO.setCertificate(resDTO.getCertificateInfo());
            actualPerDTO.setHeadPortraitUrl(resDTO.getHeadPortraitUrl());
            actualPerDTO.setNationality(resDTO.getNationality());
            actualPerLstDTO.add(actualPerDTO);
        }
        return actualPerLstDTO;
    }

    public static List<MediationDocumentResponseDTO> convertToMediationDocumentResponseDTO(List<CaseMaterialResDTO> resLstDTO) {
        ArrayList<MediationDocumentResponseDTO> responseLstDTO = new ArrayList<MediationDocumentResponseDTO>();
        if (CollectionUtils.isEmpty(resLstDTO)) {
            return responseLstDTO;
        }
        for (CaseMaterialResDTO resDTO : resLstDTO) {
            MediationDocumentResponseDTO responseDTO = new MediationDocumentResponseDTO();
            responseDTO.setId(resDTO.getId());
            responseDTO.setDocumentFileId(resDTO.getFileId());
            responseDTO.setDocumentName(resDTO.getFileName());
            responseDTO.setDocumentClass(resDTO.getCategoryBig());
            responseDTO.setDocumentType(resDTO.getCategoryMiddle());
            responseDTO.setDocumentUser(resDTO.getUserName());
            responseDTO.setSign(resDTO.getSign());
            responseDTO.setUserId(resDTO.getUserId());
            responseDTO.setAuthenticity(resDTO.getAuthenticity());
            responseDTO.setAuthenticityOpinion(resDTO.getAuthenticityOpinion());
            responseDTO.setRelevance(resDTO.getRelevance());
            responseDTO.setRelevanceOpinion(resDTO.getRelevanceOpinion());
            responseDTO.setValidity(resDTO.getValidity());
            responseDTO.setValidityOpinion(resDTO.getValidityOpinion());
            responseDTO.setTotalOpinion(resDTO.getTotalOpinion());
            responseDTO.setPreviewUrl(resDTO.getPreviewUrl());
            responseDTO.setHasOppugn(null != resDTO.getAuthenticity());
            if (CaseUserTypeEnum.RESPONDENT.name().equals(resDTO.getAllowOppugnUserType())) {
                responseDTO.setAllowOppugnUserType(CaseUserTypeEnum.APPLICANT.name());
            } else if (CaseUserTypeEnum.APPLICANT.name().equals(resDTO.getAllowOppugnUserType())) {
                responseDTO.setAllowOppugnUserType(CaseUserTypeEnum.RESPONDENT.name());
            }
            responseDTO.setStatus(resDTO.getStatus());
            responseDTO.setRemark(resDTO.getRemark());
            responseLstDTO.add(responseDTO);
        }
        return responseLstDTO;
    }

    public static List<MediationMeetingResponseDTO> convertToMediationMeetingResponseDTO(List<CaseMeetingListResDTO> resLstDTO) {
        ArrayList<MediationMeetingResponseDTO> meetingResponseLst = new ArrayList<MediationMeetingResponseDTO>();
        if (CollectionUtils.isEmpty(resLstDTO)) {
            return meetingResponseLst;
        }
        for (CaseMeetingListResDTO resDTO : resLstDTO) {
            MediationMeetingResponseDTO responseDTO = new MediationMeetingResponseDTO();
            responseDTO.setMeetingId(resDTO.getId());
            responseDTO.setMeetingName(resDTO.getMeetingName());
            responseDTO.setJoinUserNames(resDTO.getJoinUserName());
            responseDTO.setJoinUserIds(resDTO.getJoinUserId());
            responseDTO.setMeetingType(resDTO.getMeetingType());
            responseDTO.setMeetingStatus(resDTO.getMeetingStatus());
            responseDTO.setMeetingContent(resDTO.getMeetingContent());
            responseDTO.setOrderType(resDTO.getOrderType());
            responseDTO.setOrderTime(Long.valueOf(resDTO.getOrderTime().getTime()));
            if (null != resDTO.getCreateTime()) {
                responseDTO.setCreateTime(Long.valueOf(resDTO.getCreateTime().getTime()));
            }
            responseDTO.setMeetingVideoId(resDTO.getMeetingVideoId());
            CaseMeetingDocumentResDTO doc = resDTO.getCaseMeetingDocumentResDTO();
            if (null != doc) {
                responseDTO.setDocumentId(doc.getDocumentId());
                responseDTO.setSendStatus(doc.getSendStatus());
            }
            meetingResponseLst.add(responseDTO);
        }
        return meetingResponseLst;
    }

    private static List<MediationCaseProgressResponseDTO> convertToMediationCaseProgressResponseDTO(List<MediationCaseProgressDTO> resLstDTO) {
        ArrayList<MediationCaseProgressResponseDTO> responseLstDTO = new ArrayList<MediationCaseProgressResponseDTO>();
        if (CollectionUtils.isEmpty(resLstDTO)) {
            return responseLstDTO;
        }
        for (MediationCaseProgressDTO resDTO : resLstDTO) {
            MediationCaseProgressResponseDTO responseDTO = new MediationCaseProgressResponseDTO();
            responseDTO.setProgressCode(resDTO.getProgressCode());
            responseDTO.setProgressName(resDTO.getProgressName());
            responseDTO.setIsActive(resDTO.getIsActive());
            responseDTO.setIsHidden(resDTO.getIsHidden());
            responseDTO.setOrder(resDTO.getOrder());
            responseLstDTO.add(responseDTO);
        }
        return responseLstDTO;
    }

    public static List<WorkbenchDocStatusResponseDTO> convertToWorkbenchDocStatusResponseDTO(List<WorkbenchDocStatusResDTO> resLstDTO) {
        ArrayList<WorkbenchDocStatusResponseDTO> responseLstDTO = new ArrayList<WorkbenchDocStatusResponseDTO>();
        if (CollectionUtils.isEmpty(resLstDTO)) {
            return responseLstDTO;
        }
        for (WorkbenchDocStatusResDTO resDTO : resLstDTO) {
            WorkbenchDocStatusResponseDTO responseDTO = new WorkbenchDocStatusResponseDTO();
            responseDTO.setDocumentType(resDTO.getDocumentType());
            responseDTO.setDocumentName(resDTO.getDocumentName());
            responseDTO.setStatus(resDTO.getStatus());
            responseDTO.setDocumentId(resDTO.getDocumentId());
            responseDTO.setMeetingId(resDTO.getMeetingId());
            responseLstDTO.add(responseDTO);
        }
        return responseLstDTO;
    }
}

