/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.page.PageQuery;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseMeetingIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetCodeQrRequestDTO;
import com.beiming.odr.mastiff.service.backend.referee.CaseMeetingApiService;
import com.beiming.odr.referee.api.CaseMeetingApi;
import com.beiming.odr.referee.api.CaseMeetingNewApi;
import com.beiming.odr.referee.api.MediationMeetingApi;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingInviteReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawAttachmentUpFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.MeetingNewSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateTimeReqDTO;
import com.beiming.odr.referee.dto.responsedto.BookedCaseMeetingListResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingVideoResDTO;
import com.beiming.odr.referee.dto.responsedto.InviteWatchResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CaseMeetingApiServiceImpl
implements CaseMeetingApiService {
    private static final Logger log = LoggerFactory.getLogger(CaseMeetingApiServiceImpl.class);
    @Resource
    private CaseMeetingApi caseMeetingApi;
    @Resource
    private MediationMeetingApi mediationMeetingApi;
    @Resource
    private CaseMeetingNewApi caseMeetingNewApi;

    @Override
    public DubboResult caseMeetingSave(@Valid CaseMeetingSaveReqDTO caseMeetingSaveReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseMeetingSaveReqDTO);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingApi.caseMeetingSave(caseMeetingSaveReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public List<CaseMeetingVideoResDTO> getVideo(@Valid CaseMeetingIdReqDTO caseMeetingIdReqDTO, String cType) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseMeetingIdReqDTO);
        List caseMeetingList = null;
        try {
            DubboResult dubboResult = this.caseMeetingApi.getVideo(caseMeetingIdReqDTO, cType);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                caseMeetingList = (List)((Object)dubboResult.getData());
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return caseMeetingList;
    }

    @Override
    public DubboResult sendViewSms(CaseMeetingInviteReqDTO caseMeetingInvite) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseMeetingInvite);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingApi.sendViewSms(caseMeetingInvite);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult saveUpFile(LawAttachmentUpFileReqDTO lawAttachmentUpFileReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)lawAttachmentUpFileReqDTO);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingApi.saveUpFile(lawAttachmentUpFileReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public ArrayList<CaseMeetingListResDTO> queryCaseMeetingList(Long caseId) {
        ArrayList caseMeetingListResDTO = null;
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        try {
            DubboResult dubboResult = this.caseMeetingApi.queryCaseMeetingList(caseId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                caseMeetingListResDTO = (ArrayList)dubboResult.getData();
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return caseMeetingListResDTO;
    }

    @Override
    public DubboResult updateStart(CaseMeetingIdRequestDTO caseMeetingIdRequestDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseMeetingIdRequestDTO);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingApi.updateMeetingStartTime(caseMeetingIdRequestDTO.getMeetingId());
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult updateEnd(UpdateTimeReqDTO updateTimeReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)updateTimeReqDTO);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingApi.updateMeetingEndTime(updateTimeReqDTO);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult<InviteWatchResDTO> inviteWatch(String inviteCode, String userId, String userName) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)inviteCode);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingApi.inviteWatching(inviteCode, userId, userName);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public CaseMeetingPersonnelResDTO queryMeetingMessage(Long userId) {
        CaseMeetingPersonnelResDTO caseMeetingPersonnelResDTOs = null;
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)userId);
        try {
            DubboResult dubboResult = this.mediationMeetingApi.queryMeetingTime(userId, "NOT_END", 60);
            if (dubboResult.isSuccess()) {
                caseMeetingPersonnelResDTOs = (CaseMeetingPersonnelResDTO)dubboResult.getData();
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return caseMeetingPersonnelResDTOs;
    }

    @Override
    public DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingUrl(GetCodeQrRequestDTO getCodeQrRequestDTO, String userId) {
        DubboResult result = null;
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)getCodeQrRequestDTO);
        try {
            result = this.mediationMeetingApi.queryMeetingPersonnel(getCodeQrRequestDTO.getMeetingId(), Long.valueOf(userId), "NOT_END");
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return result;
    }

    @Override
    public DubboResult saveNewCaseMeeting(@Valid MeetingNewSaveReqDTO meetingNewSaveReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)meetingNewSaveReqDTO);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingNewApi.caseNewMeetingSave(meetingNewSaveReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult<PageInfo<BookedCaseMeetingListResponseDTO>> bookedCaseMeetingList(String userId, PageQuery pageQuery) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)userId);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.caseMeetingApi.bookedCaseMeetingList(userId, pageQuery);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }
}

