/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.referee.ClerkConfirmBackService;
import com.beiming.odr.referee.api.ClerkConfirmApi;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmAllReqDTO;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmPerReqDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmAllResDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmPerResDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClerkConfirmBackServiceImpl
implements ClerkConfirmBackService {
    private static final Logger log = LoggerFactory.getLogger(ClerkConfirmBackServiceImpl.class);
    @Resource
    private ClerkConfirmApi clerkConfirmApi;

    @Override
    public ClerkConfirmPerResDTO getMediationClerkConfirm(ClerkConfirmPerReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        ClerkConfirmPerResDTO clerkConfirmPerResDTO = null;
        DubboResult dubboResult = this.clerkConfirmApi.getMediationClerkConfirm(reqDTO);
        if (dubboResult.isSuccess()) {
            clerkConfirmPerResDTO = (ClerkConfirmPerResDTO)dubboResult.getData();
        }
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ACCESS_DENIED, (String)dubboResult.getMessage());
        log.info("dubbo result=============={}", (Object)dubboResult);
        return clerkConfirmPerResDTO;
    }

    @Override
    public List<ClerkConfirmAllResDTO> getAllMediationClerkConfirm(ClerkConfirmAllReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        ArrayList clerkConfirmAllResDTO = null;
        try {
            DubboResult dubboResult = this.clerkConfirmApi.getAllMediationClerkConfirm(reqDTO);
            if (dubboResult.isSuccess()) {
                clerkConfirmAllResDTO = (ArrayList)dubboResult.getData();
            }
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return clerkConfirmAllResDTO;
    }

    @Override
    public DubboResult<ClerkConfirmPerResDTO> judgeSignaturePermission(Long userId, Long documentId) {
        log.info("{} core request userId {} documentId {}", new Object[]{JavaFileUtil.getMethodName(), userId, documentId});
        ClerkConfirmPerResDTO clerkConfirmPerResDTO = new ClerkConfirmPerResDTO();
        try {
            DubboResult dubboResult = this.clerkConfirmApi.judgeSignaturePermission(userId, documentId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            return dubboResult;
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
            return DubboResultBuilder.success((Serializable)clerkConfirmPerResDTO);
        }
    }
}

