/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.mastiff.common.enums.SubjectTypeEnum;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuditLawDossierReqDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierGenerateRequestDTO;
import com.beiming.odr.mastiff.service.backend.referee.LawCaseDossierApiService;
import com.beiming.odr.referee.api.LawCaseDossierApi;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossGeneraterReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierAuditFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierListReqDTO;
import com.beiming.odr.referee.dto.responsedto.DisplayDossierResDTO;
import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierAttchmentListResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierVolumeResDTO;
import com.beiming.odr.referee.dto.responsedto.LawAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.LawProgressResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LawCaseDossierApiServiceImpl
implements LawCaseDossierApiService {
    private static final Logger log = LoggerFactory.getLogger(LawCaseDossierApiServiceImpl.class);
    @Resource
    private LawCaseDossierApi lawCaseDossierApi;

    @Override
    public List<LawAttachmentResDTO> getLawAttachment(@Valid @NotNull(message="\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a") @Valid @NotNull(message="\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a") Long caseId, String categoryBig) {
        List lawAttachmentResDTO = null;
        log.info("{} core request dto {}", new Object[]{JavaFileUtil.getMethodName(), caseId, categoryBig});
        try {
            DubboResult dubboResult = this.lawCaseDossierApi.getLawAttachment(caseId, categoryBig);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                lawAttachmentResDTO = (List)((Object)dubboResult.getData());
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return lawAttachmentResDTO;
    }

    @Override
    public String getGenerateFile(DossierGenerateRequestDTO dossierGenerateRequestDTO, Long userId, String userName) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dossierGenerateRequestDTO);
        String message = null;
        try {
            DossGeneraterReqDTO dossGeneraterReqDTO = new DossGeneraterReqDTO();
            dossGeneraterReqDTO.setAttachmentIds(dossierGenerateRequestDTO.getAttachmentIds());
            dossGeneraterReqDTO.setCaseId(dossierGenerateRequestDTO.getCaseId());
            dossGeneraterReqDTO.setUserId(userId);
            dossGeneraterReqDTO.setUserName(userName);
            DubboResult dubboResult = this.lawCaseDossierApi.getGenerateFile(dossGeneraterReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (!dubboResult.isSuccess()) {
                message = dubboResult.getMessage();
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return message;
    }

    @Override
    public PageInfo<DossierAttchmentListResDTO> getDossierList(@Valid DossierListReqDTO dossierListReqDTO) {
        PageInfo dossierAttchmentListResDTO = null;
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dossierListReqDTO);
        try {
            DubboResult dubboResult = this.lawCaseDossierApi.getDossierList(dossierListReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                dossierAttchmentListResDTO = (PageInfo)dubboResult.getData();
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dossierAttchmentListResDTO;
    }

    @Override
    public List<LawProgressResDTO> queryDossierList(Long caseId, String subjectType) {
        List lawProgressResDTO = null;
        log.info("{} core request dto {}", new Object[]{JavaFileUtil.getMethodName(), caseId, subjectType});
        try {
            DubboResult dubboResult = this.lawCaseDossierApi.queryDossierList(caseId, subjectType);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                lawProgressResDTO = (List)((Object)dubboResult.getData());
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return lawProgressResDTO;
    }

    @Override
    public DubboResult dossierBack(DossierAuditFailReqDTO dossierAuditFailReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dossierAuditFailReqDTO);
        return this.lawCaseDossierApi.dossierBack(dossierAuditFailReqDTO);
    }

    @Override
    public DubboResult backOutDossier(Long caseId) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        return this.lawCaseDossierApi.backOutDossier(caseId);
    }

    @Override
    public DubboResult submitLawCaseDossier(AuditLawDossierReqDTO auditLawDossierReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)auditLawDossierReqDTO);
        return this.lawCaseDossierApi.submitLawCaseDossier(auditLawDossierReqDTO.getCaseId(), auditLawDossierReqDTO.getAgreementNumber(), auditLawDossierReqDTO.getRemark());
    }

    @Override
    public DubboResult auditLawCaseDossierPass(Long caseId, Long userId, String userName) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        return this.lawCaseDossierApi.auditLawCaseDossierPass(caseId, userId, userName);
    }

    @Override
    public DubboResult saveDossierFile(DossierFileReqDTO dossierFileReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dossierFileReqDTO);
        return this.lawCaseDossierApi.saveDossierFile(dossierFileReqDTO);
    }

    @Override
    public DisplayDossierResDTO displayFileDossier(@Valid @NotNull(message="\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a") @Valid @NotNull(message="\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a") Long caseId) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        DisplayDossierResDTO displayDossierResponseDTO = null;
        try {
            DubboResult dubboResult = this.lawCaseDossierApi.displayFileDossier(caseId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                displayDossierResponseDTO = (DisplayDossierResDTO)dubboResult.getData();
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return displayDossierResponseDTO;
    }

    @Override
    public DubboResult delDossierFile(DelFileReqDTO delFileReqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)delFileReqDTO.getCaseId());
        DubboResult dubboResult = null;
        try {
            dubboResult = this.lawCaseDossierApi.delDossierFile(delFileReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public List<DossAttachmentResDTO> downloadFile(AttachmentListReqDTO attachmentListReqDTO) {
        List<Object> list = new ArrayList<DossAttachmentResDTO>();
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)attachmentListReqDTO);
        try {
            attachmentListReqDTO.setObjectType(SubjectTypeEnum.LAW_CASE_TYPE.toString());
            DubboResult dubboResult = this.lawCaseDossierApi.attachmentList(attachmentListReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                list = (List)((Object)dubboResult.getData());
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return list;
    }

    @Override
    public DossierVolumeResDTO queryDossier(Long dossierId) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dossierId);
        DossierVolumeResDTO dossierVolumeResDTO = null;
        try {
            DubboResult dubboResult = this.lawCaseDossierApi.queryDossier(dossierId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                dossierVolumeResDTO = (DossierVolumeResDTO)dubboResult.getData();
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dossierVolumeResDTO;
    }

    @Override
    public List<DossAttachmentResDTO> queryAttachmentList(Long caseId) {
        List<Object> list = new ArrayList<DossAttachmentResDTO>();
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        try {
            DubboResult dubboResult = this.lawCaseDossierApi.queryAttachmentListDossier(caseId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                list = (List)((Object)dubboResult.getData());
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<LawAttachmentResDTO> getLawAttachmentListByUserIdAndCaseId(Long caseId, Long personId) {
        List lawAttachmentResDTO = null;
        log.info("{} core request dto {}", new Object[]{JavaFileUtil.getMethodName(), caseId, personId});
        try {
            DubboResult dubboResult = this.lawCaseDossierApi.getLawAttachmentByUserIdAndCaseId(caseId, personId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                lawAttachmentResDTO = (List)((Object)dubboResult.getData());
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return lawAttachmentResDTO;
    }
}

