/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.referee.MediationDissentBackService;
import com.beiming.odr.referee.api.MediationDocDissentApi;
import com.beiming.odr.referee.dto.requestdto.MediationDissentGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSendResDTO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MediationDissentBackServiceImpl
implements MediationDissentBackService {
    private static final Logger log = LoggerFactory.getLogger(MediationDissentBackServiceImpl.class);
    @Resource
    private MediationDocDissentApi mediationDocDissentApi;

    @Override
    public MediationDissentSendResDTO sendMediationDissent(MediationDissentSendReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        MediationDissentSendResDTO promiseSendDTO = null;
        try {
            DubboResult dubboResult = this.mediationDocDissentApi.sendMediationDissent(reqDTO);
            if (dubboResult.isSuccess()) {
                promiseSendDTO = (MediationDissentSendResDTO)dubboResult.getData();
            }
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return promiseSendDTO;
    }

    @Override
    public MediationDissentSaveResDTO saveMediationDissent(MediationDissentSaveReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        MediationDissentSaveResDTO dissentSaveDTO = null;
        try {
            DubboResult dubboResult = this.mediationDocDissentApi.saveMediationDissent(reqDTO);
            if (dubboResult.isSuccess()) {
                dissentSaveDTO = (MediationDissentSaveResDTO)dubboResult.getData();
            }
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dissentSaveDTO;
    }

    @Override
    public MediationDissentGetResDTO viewMediationDissent(MediationDissentGetReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        MediationDissentGetResDTO dissentGetDTO = null;
        try {
            DubboResult dubboResult = this.mediationDocDissentApi.getMediationDissent(reqDTO);
            if (dubboResult.isSuccess()) {
                dissentGetDTO = (MediationDissentGetResDTO)dubboResult.getData();
            }
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dissentGetDTO;
    }
}

