/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.exception.APIBusinessException;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.referee.SignatureBackService;
import com.beiming.odr.mastiff.service.backend.storage.StorageDubboService;
import com.beiming.odr.referee.api.SignatureApi;
import com.beiming.odr.referee.dto.requestdto.SignatureInfoReqDTO;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SignatureBackServiceImpl
implements SignatureBackService {
    private static final Logger log = LoggerFactory.getLogger(SignatureBackServiceImpl.class);
    @Resource
    SignatureApi signatureApi;
    @Resource
    StorageDubboService storageDubboServiceImpl;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public DubboResult<String> confirmSignature(SignatureInfoReqDTO reqDTO) {
        Serializable resStr = null;
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult res = this.signatureApi.confirmSignature(reqDTO);
            log.info("dubbo result=============={}", (Object)res);
            return res;
        }
        catch (Exception e) {
            log.error("error ", (Throwable)e);
            return DubboResultBuilder.success(resStr);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DubboResult<String> confirmSignature(SignatureInfoReqDTO reqDTO, MultipartFile signFile) {
        Serializable resStr = null;
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            String fileName = signFile.getOriginalFilename();
            byte[] signFileByteArr = signFile.getBytes();
            Integer degree = reqDTO.getDegree();
            if (null != degree && degree != 0) {
                signFileByteArr = JavaFileUtil.rotateImg((byte[])signFile.getBytes(), (int)degree, null);
            }
            DubboResult<SaveFileResponseDTO> saveFileRes = this.storageDubboServiceImpl.save(fileName, signFileByteArr);
            AssertUtils.assertNotNull(saveFileRes, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)this.mastiffMessages.getSignatureImgIdNotBlank());
            SaveFileResponseDTO resDTO = (SaveFileResponseDTO)saveFileRes.getData();
            String signatureImgId = resDTO.getFileId();
            AssertUtils.assertHasText((String)signatureImgId, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)this.mastiffMessages.getSignatureImgIdNotBlank());
            reqDTO.setImgId(signatureImgId);
            DubboResult res = this.signatureApi.confirmSignature(reqDTO);
            log.info("dubbo result=============={}", (Object)res);
            return res;
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
            if (e instanceof IOException) {
                throw new APIBusinessException((APIResultCode)APIResultCodeEnums.RESULT_EMPTY, this.mastiffMessages.getSignatureImageRotateError());
            }
            return DubboResultBuilder.success(resStr);
        }
    }
}

