/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.user.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.referee.api.MediationMeetingApi;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserDubboServiceImpl
implements UserDubboService {
    private static final Logger log = LoggerFactory.getLogger(UserDubboServiceImpl.class);
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private MediationMeetingApi mediationMeetingApi;

    @Override
    public DubboResult<CaseUserRegisterResDTO> caseUserRegister(CaseUserRegisterReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        DubboResult dubboResult = this.userServiceApi.caseUserregister(reqDTO);
        log.info("dubbo result=============={}", (Object)dubboResult);
        return dubboResult;
    }

    @Override
    public CommonUserSearchResDTO searchCommonUser(Long userId) {
        try {
            CommonIdReqDTO idReqDTO = new CommonIdReqDTO();
            idReqDTO.setId(userId);
            DubboResult dubboResult = this.userServiceApi.searchCommonUser(idReqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (CommonUserSearchResDTO)dubboResult.getData();
            }
            log.error("{} reqDTO {} result {}", new Object[]{JavaFileUtil.getMethodName(), userId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Boolean isRealName(Long userId) {
        Boolean isRealName = false;
        CommonUserSearchResDTO commonUserSearchResDTO = this.searchCommonUser(userId);
        if (null != commonUserSearchResDTO) {
            isRealName = commonUserSearchResDTO.getIsRealName();
        }
        return isRealName;
    }

    @Override
    public boolean checkRealNameAuthentication(String userName, String idCard) {
        RealNameAuthenticationReqDTO reqDTO = new RealNameAuthenticationReqDTO();
        reqDTO.setUserName(userName);
        reqDTO.setIdCard(idCard);
        DubboResult dubboResult = this.userServiceApi.checkRealNameAuthentication(reqDTO);
        if (dubboResult.isSuccess()) {
            return (Boolean)dubboResult.getData();
        }
        return false;
    }

    @Override
    public Boolean checkIsMediator(Long lawCaseId) {
        String userId = JWTContextUtil.getCurrentUserId();
        DubboResult dubboResult = this.mediationMeetingApi.personList(lawCaseId, Long.valueOf(userId));
        if (!dubboResult.isSuccess()) {
            return false;
        }
        ArrayList datas = (ArrayList)dubboResult.getData();
        return datas.stream().anyMatch(data -> UserRoleEnum.MEDIATOR.name().equals(data.getCaseUserType()));
    }

    @Override
    public String getUserNameByJWT() {
        String userName = JWTContextUtil.getCurrentUserName();
        if (StringUtils.isBlank((String)userName)) {
            String userId = JWTContextUtil.getCurrentUserId();
            CommonUserSearchResDTO resDTO = this.searchCommonUser(Long.valueOf(userId));
            userName = resDTO.getUserName();
        }
        return userName;
    }
}

