/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.center.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.PlatformEnums;
import com.beiming.framework.exception.APIBusinessException;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.consultancy.api.DisputesApi;
import com.beiming.odr.consultancy.dto.requestdto.DisputeLawCaseReqDTO;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.utils.ClassUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.AddressRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.AttributeDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.CenterMediationCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.CenterSaveCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.CaseDubboService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationCaseConvert;
import com.beiming.odr.mastiff.service.backend.user.BackstageOrganizationService;
import com.beiming.odr.mastiff.service.backend.user.ServicePersonDubboService;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.center.CenterCaseService;
import com.beiming.odr.mastiff.service.utils.AttributeUtil;
import com.beiming.odr.mastiff.service.utils.RedisSequenceFactory;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.FormBoxTypeEnum;
import com.beiming.odr.referee.enums.RegisterOriginEnum;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CenterCaseServiceImpl
implements CenterCaseService {
    private static final Logger log = LoggerFactory.getLogger(CenterCaseServiceImpl.class);
    @Value(value="${center.template.url}")
    private String templateUrl;
    @Resource
    private CaseDubboService caseDubboService;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private ServicePersonDubboService servicePersonDubboService;
    @Resource
    private BackstageOrganizationService backstageOrganizationService;
    @Resource
    private DisputesApi disputesApi;
    @Resource
    private RedisSequenceFactory redisSequenceFactory;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public MediationCaseResponseDTO saveCase(CenterMediationCaseRequestDTO dto) {
        MediationCaseResponseDTO response = new MediationCaseResponseDTO();
        ArrayList allTemplateAttributeList = Lists.newArrayList();
        ArrayList userAndAdreessList = Lists.newArrayList();
        List<Object> attributeDTOList = Lists.newArrayList();
        List applyUserList = dto.getApplyUserList();
        List respondentUserList = dto.getRespondentUserList();
        userAndAdreessList.addAll(applyUserList);
        userAndAdreessList.addAll(respondentUserList);
        List<AttributeDTO> applyAttrList = this.getUserAttrList(applyUserList);
        List<AttributeDTO> agentAttrList = this.getAgentAttrList(applyUserList);
        List<AttributeDTO> respondentAttrList = this.getUserAttrList(respondentUserList);
        List<AttributeDTO> agentAttrList2 = this.getAgentAttrList(respondentUserList);
        List disputeList = dto.getDisputeList();
        attributeDTOList.addAll(applyAttrList);
        attributeDTOList.addAll(respondentAttrList);
        attributeDTOList.addAll(agentAttrList);
        attributeDTOList.addAll(agentAttrList2);
        attributeDTOList.addAll(disputeList);
        String attributes = this.getAttributesByTemplet(dto);
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)attributes), (ResultCode)ErrorCode.TEMPLATE_NOT_DATA, (String)this.mastiffMessages.getTemplateNotData());
        JSONObject jsonObject = JSON.parseObject((String)attributes);
        AssertUtils.assertTrue((APIResultCodeEnums.SUCCESS.value() == jsonObject.getIntValue("code") ? 1 : 0) != 0, (ResultCode)ErrorCode.TEMPLATE_NOT_DATA, (String)this.mastiffMessages.getTemplateRequestError());
        JSONArray dataArr = jsonObject.getJSONArray("data");
        HashMap groupByTemplateTypeMap = Maps.newHashMap();
        HashMap groupByTemplateIdMap = Maps.newHashMap();
        this.setAttribute(groupByTemplateTypeMap, groupByTemplateIdMap, allTemplateAttributeList, dataArr);
        Map<Long, List<AttributeDTO>> groupByAttrIdMap = allTemplateAttributeList.stream().collect(Collectors.groupingBy(AttributeDTO::getId));
        attributeDTOList = attributeDTOList.stream().filter(attr -> !FormBoxTypeEnum.FOUR_LINKAGE_SELECT_BOX.equals((Object)attr.getAttributeType())).collect(Collectors.toList());
        Predicate<AttributeDTO> predicate = attr -> attr.getRequiredFlag() != false && StringUtils.isBlank((String)attr.getAttributeValue()) && attr.getDisplayFlag() != false;
        Optional<AttributeDTO> attributeDTO = AttributeUtil.findAttributeByConditionFail(attributeDTOList, groupByAttrIdMap, predicate);
        attributeDTO.ifPresent(attr -> {
            throw new APIBusinessException((APIResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, Joiner.on((String)"-").join((Object)attr.getTemplateName(), (Object)attr.getAttributeName(), new Object[]{this.mastiffMessages.getParameterNotBlank()}));
        });
        this.checkAttribute(dto, userAndAdreessList, applyUserList, respondentUserList, groupByTemplateTypeMap);
        this.insertUserNotExist(applyUserList);
        List applyUserIds = applyUserList.stream().map(CenterSaveCaseUserRequestDTO::getUserId).collect(Collectors.toList());
        List agentUserIds = applyUserList.stream().map(CenterSaveCaseUserRequestDTO::getAgentId).collect(Collectors.toList());
        List roles = JWTContextUtil.getRoles();
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        if (!roles.contains(UserRoleEnum.DISPUTE_REGISTRAR.name())) {
            boolean isExists = applyUserIds.contains(userId) || agentUserIds.contains(userId);
            AssertUtils.assertTrue((boolean)isExists, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_AGENT, (String)this.mastiffMessages.getUserMustApplicantOrAgent());
        }
        this.insertUserNotExist(respondentUserList);
        MediationCaseReqDTO reqDTO = MediationCaseConvert.getMediationCaseReqConvert(dto);
        this.gettMediatorInfo(reqDTO);
        Long creatorId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        reqDTO.setCreatorId(creatorId);
        CommonUserSearchResDTO resDTO = this.userDubboService.searchCommonUser((long)userId);
        reqDTO.setCreateUser(resDTO.getUserName());
        reqDTO.setUpdateUser(resDTO.getUserName());
        reqDTO.setSmsOff(Boolean.valueOf(null == dto.getSmsOff() ? false : dto.getSmsOff()));
        if (((String)roles.get(0)).equals(UserRoleEnum.COMMON.name())) {
            reqDTO.setCreatorType(UserRoleEnum.COMMON);
        } else {
            reqDTO.setCreatorType(UserRoleEnum.DISPUTE_REGISTRAR);
        }
        reqDTO.setLawCaseStatus(CaseStatusEnum.APPLY_SUBMIT.name());
        reqDTO.setOrigin(PlatformEnums.MASTIFF_API.name());
        reqDTO.setCaseProgress(CaseProgressEnum.APPLY.name());
        String caseNo = this.getCaseNo();
        reqDTO.setCaseNo(caseNo);
        Long caseId = this.caseDubboService.insertMediationCase(reqDTO);
        AssertUtils.assertNotNull((Object)caseId, (ResultCode)ErrorCode.SUBMIT_CASE_FAIL, (String)this.mastiffMessages.getSubmitCaseFail());
        response.setCaseId(caseId);
        if (Objects.nonNull(reqDTO.getDisputesId())) {
            this.disputesApi.updateDisputesLawCaseId(new DisputeLawCaseReqDTO(reqDTO.getDisputesId(), caseId, creatorId));
        }
        if (dto.getMediationType().equals((Object)MediationTypeEnum.ADMINISTRATION_MEDIATION)) {
            Long orgId = Long.valueOf(MediationCaseConvert.getFieldValue(dto.getDisputeList(), "mediationAgency"));
            BackstageOrganizationResDTO result = this.backstageOrganizationService.searchBackstageOrganization(orgId);
            AssertUtils.assertNotNull((Object)result, (ResultCode)ErrorCode.MEDIATION_ORG_INQUIRY_FAIL, (String)this.mastiffMessages.getMediationOrgInquiryFail());
            response.setOrgName(result.getName());
            response.setOrgId(result.getOrgId());
            response.setOrgIntroduction(result.getIntroduction());
        }
        return response;
    }

    private void gettMediatorInfo(MediationCaseReqDTO reqDTO) {
        if (reqDTO.getMediatorId() != null) {
            SearchServicePersonResDTO mediatorInfo = this.servicePersonDubboService.getMediatorInfo(null, reqDTO.getMediatorId());
            AssertUtils.assertNotNull((Object)mediatorInfo, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
            MediationCaseUserReqDTO mediator = new MediationCaseUserReqDTO();
            mediator.setName(mediatorInfo.getUserName());
            mediator.setUserId(mediatorInfo.getUserId());
            mediator.setPhone(mediatorInfo.getMobilePhone());
            mediator.setCaseUserType(CaseUserTypeEnum.MEDIATOR.name());
            reqDTO.getPersonnelList().add(mediator);
            reqDTO.setMediatorName(mediatorInfo.getUserName());
        }
    }

    private void setAttribute(Map<String, List<AttributeDTO>> groupByTemplateTypeMap, Map<Long, List<AttributeDTO>> groupByTemplateIdMap, List<AttributeDTO> allTemplateAttributeList, JSONArray dataArr) {
        for (Object object : dataArr) {
            JSONObject json = (JSONObject)object;
            List<AttributeDTO> attributeList = this.jsonToAttributeList(json);
            groupByTemplateTypeMap.put(json.getString("templateType"), attributeList);
            groupByTemplateIdMap.put(json.getLong("templateId"), attributeList);
            allTemplateAttributeList.addAll(attributeList);
        }
    }

    private void checkAttribute(CenterMediationCaseRequestDTO dto, List<CenterSaveCaseUserRequestDTO> userAndAdreessList, List<CenterSaveCaseUserRequestDTO> applyUserList, List<CenterSaveCaseUserRequestDTO> respondentUserList, Map<String, List<AttributeDTO>> groupByTemplateTypeMap) {
        for (CenterSaveCaseUserRequestDTO userAndAddress : userAndAdreessList) {
            List<AttributeDTO> attrList = this.getUserAttrList(userAndAddress);
            AddressRequestDTO address = userAndAddress.getApplyAddress();
            List<AttributeDTO> templates = groupByTemplateTypeMap.get(address.getTemplateType());
            Optional<AttributeDTO> attrAddress = attrList.stream().filter(attr -> FormBoxTypeEnum.FOUR_LINKAGE_SELECT_BOX.equals((Object)attr.getAttributeType())).findFirst();
            if (!attrAddress.isPresent()) continue;
            AttributeDTO attr2 = attrAddress.get();
            Optional<AttributeDTO> attrTemplate = templates.stream().filter(t -> t.getId().equals(attr2.getId())).findFirst();
            if (!attrTemplate.isPresent()) {
                log.error("\u56db\u7ea7\u8054\u52a8\u5730\u5740\u53c2\u6570\u8bef,\u627e\u4e0d\u5230\u6a21\u677f, \u6a21\u677ftemplates: {},  \u53c2\u6570attr: {} ", templates, (Object)attr2);
                throw new APIBusinessException((APIResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, this.mastiffMessages.getTemplateNotDataParamError());
            }
            this.checkAddressRequired(attrTemplate.get(), address);
        }
        AddressRequestDTO diputeAddressRequestDTO = dto.getAddressRequestDTO();
        List<AttributeDTO> templates = groupByTemplateTypeMap.get(diputeAddressRequestDTO.getTemplateType());
        AttributeDTO disputeAreasTemplate = templates.stream().filter(t -> t.getAttributeCode().equals("disputeAreas")).findFirst().get();
        this.checkAddressRequired(disputeAreasTemplate, dto.getAddressRequestDTO());
        this.checkRepeatByOneTemplateType(applyUserList);
        this.checkRepeatByOneTemplateType(respondentUserList);
        this.checkRepeatByTwoTemplateType(applyUserList, respondentUserList);
        this.checkRepeatAgentAndAgent(applyUserList, respondentUserList);
    }

    private String getAttributesByTemplet(CenterMediationCaseRequestDTO dto) {
        try {
            JSONObject params = new JSONObject();
            params.put("account", (Object)dto.getAccount());
            params.put("templateType", (Object)dto.getTemplateType());
            params.put("businessType", (Object)dto.getBusinessType());
            return MyHttpClientUtils.sendHttpPost((String)(this.templateUrl + "caseManageSystem/template/searchTemplateData"), (String)params.toJSONString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<AttributeDTO> jsonToAttributeList(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        ArrayList attributeDTOList = Lists.newArrayList();
        try {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject json = (JSONObject)jsonArray.get(i);
                AttributeDTO attr = new AttributeDTO();
                attr.setId(json.getLong("id"));
                attr.setTemplateId(json.getLong("templateId"));
                attr.setTemplateType(jsonObject.getString("templateType"));
                attr.setTemplateName(jsonObject.getString("templateName"));
                attr.setAttributeName(json.getString("attributeName"));
                attr.setAttributeCode(json.getString("attributeCode"));
                attr.setRequiredFlag(json.getBoolean("requiredFlag"));
                attr.setDisplayFlag(json.getBoolean("displayFlag"));
                attr.setCheckType(Objects.toString(json.getString("checkType"), null));
                attributeDTOList.add(attr);
            }
            return attributeDTOList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<AttributeDTO> setOrderToAttributeList(Integer order, List<AttributeDTO> applyAttrList) {
        for (AttributeDTO attr : applyAttrList) {
            attr.setOrder(order);
        }
        return applyAttrList;
    }

    private List<AttributeDTO> getUserAttrList(List<CenterSaveCaseUserRequestDTO> userList) {
        return userList.stream().map(uto -> this.setOrderToAttributeList(uto.getOrder(), uto.getApplyList())).flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    private List<AttributeDTO> getUserAttrList(CenterSaveCaseUserRequestDTO userDTO) {
        Integer order = userDTO.getOrder();
        return userDTO.getApplyList().stream().map(attr -> {
            attr.setOrder(order);
            return attr;
        }).collect(Collectors.toList());
    }

    private List<AttributeDTO> getAgentAttrList(List<CenterSaveCaseUserRequestDTO> userList) {
        return userList.stream().map(uto -> this.setOrderToAttributeList(uto.getOrder(), uto.getAgentList())).flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    private void checkAddressRequired(AttributeDTO disputeAreasTemplate, AddressRequestDTO addressRequestDTO) {
        if (disputeAreasTemplate.getDisplayFlag().booleanValue() && disputeAreasTemplate.getRequiredFlag().booleanValue()) {
            AssertUtils.assertNotNull((Object)addressRequestDTO, (ResultCode)ErrorCode.ADDRESS_NOT_NULL, (String)this.mastiffMessages.getAddressNotBlank());
            List fields = ClassUtil.getFields(AddressRequestDTO.class);
            for (String field : fields) {
                String value = (String)ClassUtil.getFieldValueByFieldName((String)field, (Object)addressRequestDTO);
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)value), (ResultCode)ErrorCode.ADDRESS_NOT_NULL, (String)this.mastiffMessages.getAddressNotBlank());
            }
        }
    }

    private void checkRepeatByOneTemplateType(List<CenterSaveCaseUserRequestDTO> userList) {
        ArrayList<CenterSaveCaseUserRequestDTO> userList2 = new ArrayList<CenterSaveCaseUserRequestDTO>(userList);
        for (int i = 0; i < userList.size() - 1; ++i) {
            List applyList = userList.get(i).getApplyList();
            String phone = MediationCaseConvert.getFieldValue(applyList, "phone");
            String idCard = MediationCaseConvert.getFieldValue(applyList, "idCard");
            String attributeName = MediationCaseConvert.getFieldAttributeName(applyList, "name");
            for (int j = i; j < userList2.size(); ++j) {
                List agentList;
                if (i != 0) {
                    List applyList2 = ((CenterSaveCaseUserRequestDTO)userList2.get(j)).getApplyList();
                    String phone2 = MediationCaseConvert.getFieldValue(applyList2, "phone");
                    String idCard2 = MediationCaseConvert.getFieldValue(applyList2, "idCard");
                    if (StringUtils.isNotBlank((CharSequence)phone) && StringUtils.isNotBlank((CharSequence)phone2)) {
                        AssertUtils.assertFalse((boolean)phone.equals(phone2), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u624b\u673a\u53f7\u4e0e\u5176\u4ed6" + attributeName + "\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)idCard) && StringUtils.isNotBlank((CharSequence)idCard2)) {
                        AssertUtils.assertFalse((boolean)idCard.equals(idCard2), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u8eab\u4efd\u8bc1\u53f7\u4e0e\u5176\u4ed6" + attributeName + "\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                    }
                }
                if (CollectionUtils.isEmpty((Collection)(agentList = ((CenterSaveCaseUserRequestDTO)userList2.get(j)).getAgentList()))) continue;
                String agentPhone = MediationCaseConvert.getFieldValue(agentList, "agentPhone");
                String agentIdCard = MediationCaseConvert.getFieldValue(agentList, "agentIdCard");
                if (StringUtils.isNotBlank((CharSequence)idCard) && StringUtils.isNotBlank((CharSequence)agentIdCard)) {
                    AssertUtils.assertFalse((boolean)idCard.equals(agentIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u8eab\u4efd\u8bc1\u53f7\u4e0e" + attributeName + (j + 1) + "\u7684\u4ee3\u7406\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                }
                if (!StringUtils.isNotBlank((CharSequence)phone) || !StringUtils.isNotBlank((CharSequence)agentPhone)) continue;
                AssertUtils.assertFalse((boolean)phone.equals(agentPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u624b\u673a\u53f7\u4e0e" + attributeName + (j + 1) + "\u7684\u4ee3\u7406\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
            }
        }
    }

    private void checkRepeatByTwoTemplateType(List<CenterSaveCaseUserRequestDTO> userList, List<CenterSaveCaseUserRequestDTO> userList2) {
        for (int i = 0; i < userList.size(); ++i) {
            List applyList = userList.get(i).getApplyList();
            String phone = MediationCaseConvert.getFieldValue(applyList, "phone");
            String idCard = MediationCaseConvert.getFieldValue(applyList, "idCard");
            String attributeName = MediationCaseConvert.getFieldAttributeName(applyList, "name");
            for (int j = 0; j < userList2.size(); ++j) {
                List agentList;
                List applyList2 = userList2.get(j).getApplyList();
                String idCard2 = MediationCaseConvert.getFieldValue(applyList2, "idCard");
                String phone2 = MediationCaseConvert.getFieldValue(applyList2, "phone");
                String attributeName2 = MediationCaseConvert.getFieldAttributeName(applyList2, "name");
                if (StringUtils.isNotBlank((CharSequence)phone) && StringUtils.isNotBlank((CharSequence)phone)) {
                    AssertUtils.assertFalse((boolean)phone.equals(phone2), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u624b\u673a\u53f7\u4e0e\u5176\u4ed6" + attributeName2 + (j + 1) + "\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                }
                if (StringUtils.isNotBlank((CharSequence)idCard) && StringUtils.isNotBlank((CharSequence)idCard2)) {
                    AssertUtils.assertFalse((boolean)idCard.equals(idCard2), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u8eab\u4efd\u8bc1\u53f7\u4e0e\u5176\u4ed6" + attributeName2 + (j + 1) + "\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                }
                if (CollectionUtils.isEmpty((Collection)(agentList = userList2.get(j).getAgentList()))) continue;
                String agentPhone = MediationCaseConvert.getFieldValue(agentList, "agentPhone");
                String agentIdCard = MediationCaseConvert.getFieldValue(agentList, "agentIdCard");
                if (StringUtils.isNotBlank((CharSequence)phone) && StringUtils.isNotBlank((CharSequence)agentPhone)) {
                    AssertUtils.assertFalse((boolean)phone.equals(agentPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u624b\u673a\u53f7\u4e0e" + attributeName2 + (j + 1) + "\u7684\u4ee3\u7406\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                }
                if (!StringUtils.isNotBlank((CharSequence)idCard) || !StringUtils.isNotBlank((CharSequence)agentIdCard)) continue;
                AssertUtils.assertFalse((boolean)idCard.equals(agentIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)(attributeName + (i + 1) + "\u8eab\u4efd\u8bc1\u53f7\u4e0e" + attributeName2 + (j + 1) + "\u7684\u4ee3\u7406\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
            }
        }
    }

    private void checkRepeatAgentAndAgent(List<CenterSaveCaseUserRequestDTO> userList, List<CenterSaveCaseUserRequestDTO> userList2) {
        for (int i = 0; i < userList.size(); ++i) {
            List agentList = userList.get(i).getAgentList();
            if (CollectionUtils.isEmpty((Collection)agentList)) continue;
            String agentPhone = MediationCaseConvert.getFieldValue(agentList, "agentPhone");
            String agentIdCard = MediationCaseConvert.getFieldValue(agentList, "agentIdCard");
            for (int j = 0; j < userList2.size(); ++j) {
                List agentList2 = userList2.get(j).getAgentList();
                if (CollectionUtils.isEmpty((Collection)agentList2)) continue;
                String agentPhone2 = MediationCaseConvert.getFieldValue(agentList2, "agentPhone");
                String agentIdCard2 = MediationCaseConvert.getFieldValue(agentList2, "agentIdCard");
                if (StringUtils.isNotBlank((CharSequence)agentIdCard) && StringUtils.isNotBlank((CharSequence)agentIdCard2)) {
                    AssertUtils.assertFalse((boolean)agentIdCard.equals(agentIdCard2), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u7684\u4ee3\u7406\u4eba\u4e0e\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                }
                if (!StringUtils.isNotBlank((CharSequence)agentPhone) || !StringUtils.isNotBlank((CharSequence)agentPhone2)) continue;
                AssertUtils.assertFalse((boolean)agentPhone.equals(agentPhone2), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u624b\u673a\u53f7\u4e0e\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
            }
        }
    }

    private void caseUserRegister(CenterSaveCaseUserRequestDTO dto) {
        CaseUserRegisterReqDTO user = MediationCaseConvert.getCaseUserRegisterReqDTO(dto);
        DubboResult<CaseUserRegisterResDTO> dubboResult = this.userDubboService.caseUserRegister(user);
        if (!dubboResult.isSuccess()) {
            String prefixMsg = "";
            switch (dto.getUserType()) {
                case NATURAL_PERSON: {
                    prefixMsg = "\u7533\u8bf7\u4eba";
                    break;
                }
                case UNINCORPORATED_ORGANIZATION: {
                    prefixMsg = "\u673a\u6784\u4ee3\u8868\u4eba";
                    break;
                }
                case JURIDICAL_PERSON: {
                    prefixMsg = "\u6cd5\u5b9a\u4ee3\u8868\u4eba";
                    break;
                }
            }
            if (dto.getCaseUserType().equals((Object)CaseUserTypeEnum.APPLICANT) || dto.getCaseUserType().equals((Object)CaseUserTypeEnum.RESPONDENT)) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)(prefixMsg + user.getUserName() + dubboResult.getMessage()));
            }
        }
        CaseUserRegisterResDTO data = (CaseUserRegisterResDTO)dubboResult.getData();
        dto.setUserId(data.getUserId());
        if (data.getIsAutoRegist().booleanValue()) {
            dto.setUserRegisterOrigin(RegisterOriginEnum.REGISTER_PLATFORM);
        } else {
            dto.setUserRegisterOrigin(RegisterOriginEnum.REGISTER_SELF);
        }
        List agentList = dto.getAgentList();
        String agentName = MediationCaseConvert.getFieldValue(agentList, "agentName");
        String agentPhone = MediationCaseConvert.getFieldValue(agentList, "agentPhone");
        String agentIdCard = MediationCaseConvert.getFieldValue(agentList, "agentIdCard");
        if (StringUtils.isNotBlank((CharSequence)agentPhone)) {
            CaseUserRegisterReqDTO agent = new CaseUserRegisterReqDTO();
            agent.setUserName(agentName);
            agent.setMobilePhone(agentPhone);
            agent.setIdCard(agentIdCard);
            agent.setPassword("Aa@123456");
            DubboResult<CaseUserRegisterResDTO> dubboResultAgent = this.userDubboService.caseUserRegister(agent);
            CaseUserRegisterResDTO agentReqDTO = (CaseUserRegisterResDTO)dubboResultAgent.getData();
            if (dto.getCaseUserType().equals((Object)CaseUserTypeEnum.APPLICANT)) {
                AssertUtils.assertTrue((boolean)dubboResultAgent.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba" + agentName + dubboResultAgent.getMessage()));
            }
            if (dto.getCaseUserType().equals((Object)CaseUserTypeEnum.RESPONDENT)) {
                AssertUtils.assertTrue((boolean)dubboResultAgent.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba" + agentName + dubboResultAgent.getMessage()));
            }
            dto.setAgentId(agentReqDTO.getUserId());
            if (agentReqDTO.getIsAutoRegist().booleanValue()) {
                dto.setAgentRegisterOrigin(RegisterOriginEnum.REGISTER_PLATFORM);
            } else {
                dto.setAgentRegisterOrigin(RegisterOriginEnum.REGISTER_SELF);
            }
        } else {
            dto.setAgentId(null);
            dto.setAgentRegisterOrigin(null);
        }
    }

    private void insertUserNotExist(List<CenterSaveCaseUserRequestDTO> personnelList) {
        for (CenterSaveCaseUserRequestDTO dto : personnelList) {
            this.caseUserRegister(dto);
        }
    }

    private String getCaseNo() {
        long sequence = 0L;
        try {
            sequence = this.redisSequenceFactory.generate("caseno_Sequence");
        }
        catch (Exception e) {
            log.error("redis\u81ea\u589e\u5e8f\u5217\u751f\u6210\u62a5\u9519:{}", (Throwable)e);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            String date = Long.toHexString(calendar.getTimeInMillis()).toUpperCase();
            String freeRandom = String.valueOf((int)(Math.random() * 90.0) + 10);
            return date + freeRandom;
        }
        return String.format("\uff08%d\uff09\u591a\u5143\u5316\u89e3%d\u53f7", Calendar.getInstance().getWeekYear(), sequence);
    }
}

