/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.ClerkConfirmAllRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.ClerkConfirmPerRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.ClerkConfirmAllResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.ClerkConfirmPerResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.ClerkConfirmBackService;
import com.beiming.odr.mastiff.service.backend.referee.convert.ClerkConfirmConvert;
import com.beiming.odr.mastiff.service.client.ClerkConfirmService;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmAllReqDTO;
import com.beiming.odr.referee.dto.requestdto.ClerkConfirmPerReqDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmAllResDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmPerResDTO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ClerkConfirmServiceImpl
implements ClerkConfirmService {
    @Resource
    private ClerkConfirmBackService clerkConfirmBackServiceImpl;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public ClerkConfirmPerResponseDTO getMediationClerkConfirm(ClerkConfirmPerRequestDTO requestDTO) {
        ClerkConfirmPerReqDTO reqDTO = ClerkConfirmConvert.convertToClerkConfirmPerReqDTO(requestDTO);
        ClerkConfirmPerResDTO resDTO = this.clerkConfirmBackServiceImpl.getMediationClerkConfirm(reqDTO);
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return ClerkConfirmConvert.convertToClerkConfirmPerResponseDTO(resDTO);
    }

    @Override
    public List<ClerkConfirmAllResponseDTO> getAllMediationClerkConfirm(ClerkConfirmAllRequestDTO requestDTO) {
        ClerkConfirmAllReqDTO reqDTO = ClerkConfirmConvert.convertToClerkConfirmAllReqDTO(requestDTO);
        List<ClerkConfirmAllResDTO> resLstDTO = this.clerkConfirmBackServiceImpl.getAllMediationClerkConfirm(reqDTO);
        AssertUtils.assertNotNull(resLstDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return ClerkConfirmConvert.convertToClerkConfirmAllResponseDTO(resLstDTO);
    }
}

