/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.PlatformEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.UpdateCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.CaseDubboService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationCaseConvert;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.CaseService;
import com.beiming.odr.mastiff.service.client.DisputeRegistrarService;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.UserRoleEnum;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DisputeRegistrarServiceImpl
implements DisputeRegistrarService {
    private static final Logger log = Logger.getLogger(DisputeRegistrarServiceImpl.class);
    @Resource
    private CaseService caseService;
    @Resource
    private CaseDubboService caseDubboService;
    @Resource
    private MastiffMessages mastiffMessages;
    @Resource
    private UserDubboService userDubboService;

    @Override
    @Transactional
    public MediationCaseResponseDTO submitThenSaveCase(MediationCaseRequestDTO dto) {
        this.deleteCase(dto);
        MediationCaseResponseDTO mediationCaseResponseDTO = this.caseService.saveCase(dto);
        return mediationCaseResponseDTO;
    }

    @Override
    @Transactional
    public void deleteCase(MediationCaseRequestDTO mediationCaseRequestDTO) {
        DubboResult<Integer> result = this.caseDubboService.deleteLawCase(mediationCaseRequestDTO.getLawCaseId());
        this.caseDubboService.deleteAllCasePersonel(mediationCaseRequestDTO.getLawCaseId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.DELETE_CASE_FAIL, (String)this.mastiffMessages.getUpdateCaseInfoError());
    }

    @Override
    @Transactional
    public MediationCaseResponseDTO saveCaseUnsubmit(MediationCaseRequestDTO dto) {
        MediationCaseResponseDTO response = new MediationCaseResponseDTO();
        MediationCaseReqDTO reqDTO = MediationCaseConvert.getMediationCaseReqConvert(dto);
        Long creatorId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        reqDTO.setCreatorId(creatorId);
        String currentUserName = this.userDubboService.getUserNameByJWT();
        reqDTO.setCreateUser(currentUserName);
        reqDTO.setUpdateUser(currentUserName);
        reqDTO.setCreatorType(UserRoleEnum.DISPUTE_REGISTRAR);
        reqDTO.setOrigin(PlatformEnums.MASTIFF_API.name());
        reqDTO.setLawCaseStatus(CaseStatusEnum.UNSUBMIT.name());
        reqDTO.setCaseProgress(CaseProgressEnum.UNSUBMIT.name());
        reqDTO.setDisputeStatus(dto.getDisputeStatus());
        Long caseId = this.caseDubboService.insertMediationCase(reqDTO);
        AssertUtils.assertNotNull((Object)caseId, (ResultCode)ErrorCode.SUBMIT_CASE_FAIL, (String)this.mastiffMessages.getSubmitCaseFail());
        response.setCaseId(caseId);
        return response;
    }

    @Override
    public void updateCaseUnsubmit(UpdateCaseRequestDTO dto) {
        this.caseService.editCaseDisputeInfo(dto.getEditCaseDisputeRequestDTO());
        this.caseService.saveCaseUserList(dto.getSaveCaseUserListRequestDTO());
    }
}

