/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.EvaluateCallBackRequestDTO;
import com.beiming.odr.mastiff.service.client.EvaluateService;
import com.beiming.odr.referee.api.EvaluateAPi;
import com.beiming.odr.referee.dto.requestdto.EvaluateApplyReqDTO;
import com.beiming.odr.referee.dto.requestdto.EvaluateListReqDTO;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.dto.UserAddressInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class EvaluateServiceImpl
implements EvaluateService {
    @Resource
    EvaluateAPi evaluateAPi;
    @Resource
    UserServiceApi userServiceApi;

    @Override
    public APIResult saveEvaluate(EvaluateApplyReqDTO reqDTO) {
        DubboResult result;
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        CommonIdReqDTO commonIdReqDTO = new CommonIdReqDTO();
        commonIdReqDTO.setId(userId);
        DubboResult userResult = this.userServiceApi.searchCommonUser(commonIdReqDTO);
        UserAddressInfoDTO currentAddress = null;
        if (userResult.isSuccess()) {
            CommonUserSearchResDTO data = (CommonUserSearchResDTO)userResult.getData();
            reqDTO.setUserId(data.getUserId());
            reqDTO.setApplyIdcard(data.getIdCard());
            reqDTO.setApplyPhone(data.getMobilePhone());
            currentAddress = data.getCurrentAddress();
            reqDTO.setApplySex("FEMALE".equals(data.getSex()) ? Boolean.TRUE : Boolean.FALSE);
        }
        if (currentAddress != null) {
            reqDTO.setArea(currentAddress.getAreaName());
            reqDTO.setApplyProvince(currentAddress.getProvinceName());
            reqDTO.setApplyCity(currentAddress.getCityName());
            reqDTO.setApplyAddr(currentAddress.getDetailedAddress());
        }
        if ((result = this.evaluateAPi.saveEvaluate(reqDTO)).isSuccess()) {
            return APIResult.success();
        }
        return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
    }

    @Override
    public APIResult selectEvaluateList(EvaluateListReqDTO req) {
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        req.setUserId(userId);
        DubboResult pageInfoDubboResult = this.evaluateAPi.selectEvaluateList(req);
        if (pageInfoDubboResult.isSuccess()) {
            return APIResult.success((Object)pageInfoDubboResult.getData());
        }
        return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
    }

    @Override
    public void callBack(EvaluateCallBackRequestDTO dto) {
        EvaluateApplyReqDTO reqDTO = new EvaluateApplyReqDTO();
        reqDTO.setId(dto.getLawCaseId());
        reqDTO.setUserStatus(dto.getUserStatus());
        reqDTO.setStatus(dto.getStatus());
        reqDTO.setUserReportUrl(dto.getUserReportURL());
        this.evaluateAPi.saveEvaluate(reqDTO);
    }
}

