/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.enums.SubjectTypeEnum;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.domain.dto.DictionaryDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.AgentAuthorizeProxyRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuthorizeProxyRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.BatchFilesRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MaterialTypeResponseDTO;
import com.beiming.odr.mastiff.service.backend.user.DictionaryDubboService;
import com.beiming.odr.mastiff.service.client.FileService;
import com.beiming.odr.referee.api.AttachmentApi;
import com.beiming.odr.referee.dto.FileDTO;
import com.beiming.odr.referee.dto.requestdto.AgentAuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.AuthorizeProxyReqDTO;
import com.beiming.odr.referee.dto.requestdto.BatchFilesReqDTO;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FileServiceImpl
implements FileService {
    @Resource
    private DictionaryDubboService dictionaryDubboService;
    @Resource
    private AttachmentApi attachmentApi;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public MaterialTypeResponseDTO queryMaterialTypeInfo() {
        List<DictionaryInfoDTO> typeList = this.dictionaryDubboService.getDictionaryByParentCode("MEDIATE_MATERIAL_TYPE");
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty(typeList), (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)this.mastiffMessages.getNoInitMaterialType());
        List parentList = typeList.stream().map(dto -> new DictionaryDTO(null, dto.getCode(), dto.getName())).collect(Collectors.toList());
        List<String> parentCodeList = typeList.stream().map(DictionaryInfoDTO::getCode).collect(Collectors.toList());
        DubboResult<DictionaryResDTO> dtoDubboResult = this.dictionaryDubboService.getDictionaryByParentCodes(parentCodeList);
        List codeList = ((DictionaryResDTO)dtoDubboResult.getData()).getData();
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)codeList), (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)this.mastiffMessages.getNoInitMaterialSubType());
        Map<String, List<DictionaryDTO>> listMap = codeList.stream().map(dto -> new DictionaryDTO(dto.getParentCode(), dto.getCode(), dto.getName())).collect(Collectors.groupingBy(DictionaryDTO::getParentCode));
        return new MaterialTypeResponseDTO(parentList, listMap);
    }

    @Override
    public DubboResult batchFilesUpload(BatchFilesRequestDTO dto) {
        List files = dto.getFiles();
        ArrayList fileDTOList = Lists.newArrayList();
        files.forEach(file -> {
            String fileName = file.getFileName();
            String fileIdExtensionName = JavaFileUtil.getExtensionName((String)file.getFileId());
            String fileNameExtensionName = JavaFileUtil.getExtensionName((String)fileName);
            if (StringUtils.isBlank((String)fileNameExtensionName) && StringUtils.isNotBlank((CharSequence)fileIdExtensionName)) {
                fileName = fileName + "." + fileIdExtensionName;
            }
            fileDTOList.add(new FileDTO(file.getFileId(), fileName, file.getPreviewUrl(), file.getTdhFileId()));
        });
        AssertUtils.assertFalse((boolean)CollectionUtils.isEmpty((Collection)fileDTOList), (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getFilesIsEmpty());
        BatchFilesReqDTO batchFilesReqDTO = new BatchFilesReqDTO();
        batchFilesReqDTO.setFiles((List)fileDTOList);
        batchFilesReqDTO.setCaseId(dto.getCaseId());
        batchFilesReqDTO.setCategoryMiddle(dto.getCategoryMiddle());
        batchFilesReqDTO.setSign(dto.getSign());
        batchFilesReqDTO.setUserId(dto.getUserId());
        batchFilesReqDTO.setUserName(dto.getUserName());
        batchFilesReqDTO.setObjectType(SubjectTypeEnum.LAW_CASE_TYPE.toString());
        batchFilesReqDTO.setMeetingId(dto.getMeetingId());
        batchFilesReqDTO.setFileType(dto.getFileType());
        return this.attachmentApi.batchSaveFile(batchFilesReqDTO);
    }

    @Override
    public void getAuthorizeProxy(Long caseId, Long userId, Long personnelId) {
        DubboResult authorizeProxy = this.attachmentApi.getAuthorizeProxy(caseId, userId, personnelId);
        AssertUtils.assertNotNull((Object)authorizeProxy, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        Boolean flag = (Boolean)authorizeProxy.getData();
        AssertUtils.assertFalse((boolean)flag, (ResultCode)ErrorCode.AUTHORIZE_PROXY_EXIT, (String)this.mastiffMessages.getAuthorizeProxyExit());
    }

    @Override
    public Long uploadAuthorizeProxy(AuthorizeProxyRequestDTO dto) {
        AuthorizeProxyReqDTO reqDTO = new AuthorizeProxyReqDTO();
        reqDTO.setCaseId(dto.getCaseId());
        reqDTO.setPetitionAgentId(dto.getPetitionAgentId());
        reqDTO.setFileId(dto.getFileId());
        reqDTO.setFileName(dto.getFileName());
        reqDTO.setCreateUser(dto.getCreateUser());
        reqDTO.setUpdateUser(dto.getCreateUser());
        DubboResult dubboResult = this.attachmentApi.uploadAuthorizeProxy(reqDTO);
        AssertUtils.assertNotNull((Object)dubboResult, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        Long attachmentId = (Long)dubboResult.getData();
        AssertUtils.assertNotNull((Object)attachmentId, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return attachmentId;
    }

    @Override
    public Long uploadAgentAuthorizeProxy(AgentAuthorizeProxyRequestDTO dto) {
        AgentAuthorizeProxyReqDTO reqDTO = new AgentAuthorizeProxyReqDTO();
        reqDTO.setCaseId(dto.getCaseId());
        reqDTO.setCaseUserId(dto.getCaseUserId());
        reqDTO.setAgentType(dto.getAgentType().name());
        reqDTO.setProxyFileId(dto.getProxyFileId());
        reqDTO.setProxyFileName(dto.getProxyFileName());
        reqDTO.setCreateUser(dto.getCreateUser());
        reqDTO.setUpdateUser(dto.getCreateUser());
        DubboResult dubboResult = this.attachmentApi.uploadAgentAuthorizeProxy(reqDTO);
        AssertUtils.assertTrue((dubboResult != null && dubboResult.getData() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return (Long)dubboResult.getData();
    }

    @Override
    public void getAgentAuthorizeProxy(Long caseId, Long personnelId, String agentType) {
        DubboResult authorizeProxy = this.attachmentApi.getAgentAuthorizeProxy(caseId, personnelId, agentType);
        AssertUtils.assertNotNull((Object)authorizeProxy, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        Boolean flag = (Boolean)authorizeProxy.getData();
        AssertUtils.assertFalse((boolean)flag, (ResultCode)ErrorCode.AUTHORIZE_PROXY_EXIT, (String)this.mastiffMessages.getAuthorizeProxyExit());
    }
}

