/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.DossierAttachmentTypeEnum;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.enums.SubjectTypeEnum;
import com.beiming.odr.mastiff.common.enums.TableContextEnums;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuditLawDossierReqDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DelFileRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierAttachListRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierDownloadRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierFileRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierGenerateRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierListRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.LawDossierBackRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.LawProgressRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.UserAttachmentListRequestDTO;
import com.beiming.odr.mastiff.service.backend.referee.LawCaseDossierApiService;
import com.beiming.odr.mastiff.service.client.LawCaseDossierService;
import com.beiming.odr.referee.api.LawCasePersonnelApi;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.DelFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierAuditFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.DossierListReqDTO;
import com.beiming.odr.referee.dto.responsedto.DisplayDossierResDTO;
import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierAttchmentListResDTO;
import com.beiming.odr.referee.dto.responsedto.DossierVolumeResDTO;
import com.beiming.odr.referee.dto.responsedto.LawAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.LawProgressResDTO;
import com.beiming.odr.referee.enums.CategoryBigTypeEnum;
import com.beiming.odr.referee.enums.DocumentEvidenceTypeEnum;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.Borders;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LawCaseDossierServiceImpl
implements LawCaseDossierService {
    @Resource
    private LawCaseDossierApiService lawCaseDossierApiService;
    @Resource
    private LawCasePersonnelApi lawCasePersonnelApi;
    @Resource
    private MastiffMessages mastiffMessages;
    @Value(value="${file.storage.mastiff.dir}")
    private String storageDir;

    @Override
    public List<LawAttachmentResDTO> getLawAttachmentList(DossierAttachListRequestDTO dossierAttachListRequestDTO) {
        return this.lawCaseDossierApiService.getLawAttachment(dossierAttachListRequestDTO.getCaseId(), dossierAttachListRequestDTO.getObjectType());
    }

    @Override
    public String getGenerateFile(DossierGenerateRequestDTO dossierGenerateRequestDTO, Long userId, String userName) {
        return this.lawCaseDossierApiService.getGenerateFile(dossierGenerateRequestDTO, userId, userName);
    }

    @Override
    public PageInfo<DossierAttchmentListResDTO> queryDossierList(DossierListRequestDTO dossierListRequestDTO) {
        DossierListReqDTO dossierListReqDTO = new DossierListReqDTO();
        dossierListReqDTO.setCaseNo(dossierListRequestDTO.getCaseNo());
        if (!dossierListRequestDTO.getCreateEndTime().equals("") && dossierListRequestDTO.getCreateEndTime() != null) {
            dossierListReqDTO.setCreateEntTime(dossierListRequestDTO.getCreateEndTime() + " 23:59:59");
        }
        if (!dossierListRequestDTO.getCreateStartTime().equals("") && dossierListRequestDTO.getCreateStartTime() != null) {
            dossierListReqDTO.setCreateStartTime(dossierListRequestDTO.getCreateStartTime() + " 00:00:00");
        }
        dossierListReqDTO.setCreateUser(dossierListRequestDTO.getCreateUser());
        dossierListReqDTO.setDisputeType(dossierListRequestDTO.getDisputeType());
        dossierListReqDTO.setOrgId(dossierListRequestDTO.getOrgId());
        dossierListReqDTO.setPageIndex(dossierListRequestDTO.getPageIndex());
        dossierListReqDTO.setPageSize(dossierListRequestDTO.getPageSize());
        return this.lawCaseDossierApiService.getDossierList(dossierListReqDTO);
    }

    @Override
    public List<LawProgressResDTO> queryLawProgressList(LawProgressRequestDTO lawProgressRequestDTO) {
        return this.lawCaseDossierApiService.queryDossierList(lawProgressRequestDTO.getCaseId(), SubjectTypeEnum.DOSSIER_TYPE.toString());
    }

    @Override
    public String lawDossierBack(LawDossierBackRequestDTO lawDossierBackRequestDTO, Long userId, String userName) {
        String message = null;
        DossierAuditFailReqDTO dossierAuditFailReqDTO = new DossierAuditFailReqDTO();
        dossierAuditFailReqDTO.setFailReason(lawDossierBackRequestDTO.getFailReason());
        dossierAuditFailReqDTO.setId(lawDossierBackRequestDTO.getCaseId());
        dossierAuditFailReqDTO.setUserId(userId);
        dossierAuditFailReqDTO.setUserName(userName);
        DubboResult result = this.lawCaseDossierApiService.dossierBack(dossierAuditFailReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String lawBackOutDossier(CaseIdRequestDTO caseIdRequestDTO) {
        String message = null;
        DubboResult result = this.lawCaseDossierApiService.backOutDossier(caseIdRequestDTO.getCaseId());
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String submitLawDossier(AuditLawDossierReqDTO auditLawDossierReqDTO) {
        String message = null;
        DubboResult result = this.lawCaseDossierApiService.submitLawCaseDossier(auditLawDossierReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String auditLawDossier(CaseIdRequestDTO caseIdRequestDTO, String userName, Long userId) {
        String message = null;
        DubboResult result = this.lawCaseDossierApiService.auditLawCaseDossierPass(caseIdRequestDTO.getCaseId(), userId, userName);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String uploadFile(DossierFileRequestDTO dossierFileRequestDTO) {
        String message = null;
        String fileName = dossierFileRequestDTO.getFileName();
        String fileIdExtensionName = JavaFileUtil.getExtensionName((String)dossierFileRequestDTO.getFileId());
        String fileNameExtensionName = JavaFileUtil.getExtensionName((String)fileName);
        if (StringUtils.isBlank((String)fileNameExtensionName) && StringUtils.isNotBlank((CharSequence)fileIdExtensionName)) {
            fileName = fileName + "." + fileIdExtensionName;
        }
        DossierFileReqDTO dossierFileReqDTO = new DossierFileReqDTO();
        dossierFileReqDTO.setCaseId(dossierFileRequestDTO.getCaseId());
        dossierFileReqDTO.setCategoryMiddle(dossierFileRequestDTO.getCategoryMiddle());
        dossierFileReqDTO.setFileId(dossierFileRequestDTO.getFileId());
        dossierFileReqDTO.setFileType(dossierFileRequestDTO.getFileType());
        dossierFileReqDTO.setFileName(fileName);
        dossierFileReqDTO.setSign(dossierFileRequestDTO.getSign());
        dossierFileReqDTO.setUesrId(dossierFileRequestDTO.getUserId());
        dossierFileReqDTO.setUserName(dossierFileRequestDTO.getUserName());
        dossierFileReqDTO.setRoles(dossierFileRequestDTO.getRoles());
        dossierFileReqDTO.setObjectType(SubjectTypeEnum.LAW_CASE_TYPE.toString());
        dossierFileReqDTO.setMeetingId(dossierFileRequestDTO.getMeetingId());
        dossierFileReqDTO.setCategoryBig(CategoryBigTypeEnum.MEDIATION.toString());
        DubboResult result = this.lawCaseDossierApiService.saveDossierFile(dossierFileReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String delFile(DelFileRequestDTO delFileRequestDTO) {
        String message = null;
        DelFileReqDTO delFileReqDTO = new DelFileReqDTO();
        delFileReqDTO.setCaseId(delFileRequestDTO.getCaseId());
        delFileReqDTO.setFileId(delFileRequestDTO.getFileId());
        delFileReqDTO.setId(delFileRequestDTO.getId());
        delFileReqDTO.setRoles(delFileRequestDTO.getRoles());
        delFileReqDTO.setUserId(delFileRequestDTO.getUserId());
        try {
            this.lawCasePersonnelApi.checkDel(delFileReqDTO);
        }
        catch (Exception e) {
            throw new AssertUtils.AssertionException((ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, e.getMessage());
        }
        DubboResult result = this.lawCaseDossierApiService.delDossierFile(delFileReqDTO);
        AssertUtils.assertNotNull((Object)result, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getFilesIsEmpty());
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public List<DossAttachmentResDTO> downloadFile(DossierDownloadRequestDTO dossierDownloadRequestDTO) {
        AttachmentListReqDTO attachmentListReqDTO = new AttachmentListReqDTO();
        attachmentListReqDTO.setId(dossierDownloadRequestDTO.getId());
        attachmentListReqDTO.setCaseId(dossierDownloadRequestDTO.getCaseId());
        attachmentListReqDTO.setCategoryBig("");
        attachmentListReqDTO.setCategoryMiddle(dossierDownloadRequestDTO.getCategoryMiddle());
        attachmentListReqDTO.setFileId(dossierDownloadRequestDTO.getFileId());
        attachmentListReqDTO.setSign(dossierDownloadRequestDTO.getSign());
        attachmentListReqDTO.setUserId(dossierDownloadRequestDTO.getUserId());
        attachmentListReqDTO.setRoles(dossierDownloadRequestDTO.getRoles());
        this.lawCasePersonnelApi.checkDownload(attachmentListReqDTO);
        List<DossAttachmentResDTO> listAttachmentList = this.lawCaseDossierApiService.downloadFile(attachmentListReqDTO);
        return listAttachmentList;
    }

    @Override
    public String getStorageRootDir() {
        return this.storageDir;
    }

    @Override
    public XWPFDocument directoryContent(DossierDownloadRequestDTO dossierDownloadRequestDTO) {
        List<Object> listAttachmentList = new ArrayList();
        dossierDownloadRequestDTO.setCategoryMiddle("");
        listAttachmentList = this.lawCaseDossierApiService.queryAttachmentList(dossierDownloadRequestDTO.getCaseId());
        AssertUtils.assertTrue((listAttachmentList.size() > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.UNEXCEPTED, (String)this.mastiffMessages.getAttamentNoExist());
        List<DossAttachmentResDTO> mapList = this.displayDossierResList(listAttachmentList);
        XWPFDocument document = new XWPFDocument();
        XWPFParagraph titleParagraph = document.createParagraph();
        XWPFRun run = titleParagraph.createRun();
        run.setText(TableContextEnums.DOSSIER_CATALOGUE.getName());
        run.setFontSize(20);
        run.setBold(true);
        titleParagraph.setAlignment(ParagraphAlignment.CENTER);
        titleParagraph.addRun(run);
        XWPFRun titleParagraphRun = titleParagraph.createRun();
        titleParagraphRun.setFontSize(20);
        XWPFTable comTable = document.createTable();
        comTable.setCellMargins(0, 1, 0, 1);
        comTable.setRowBandSize(24);
        comTable.setColBandSize(24);
        CTTblWidth comTableWidth = comTable.getCTTbl().addNewTblPr().addNewTblW();
        comTableWidth.setType(STTblWidth.DXA);
        comTableWidth.setW(BigInteger.valueOf(9072L));
        XWPFTableRow comTableRowOne = comTable.createRow();
        comTableRowOne.getCell(0).setText(TableContextEnums.SERIAL_NUMBER.getName());
        comTableRowOne.addNewTableCell().setText(TableContextEnums.DOCUMENT_NAME.getName());
        comTableRowOne.addNewTableCell().setText(TableContextEnums.PAGE_NUMBER.getName());
        comTableRowOne.addNewTableCell().setText(TableContextEnums.REMARK.getName());
        comTableRowOne.setHeight(1200);
        int i = 0;
        for (DossAttachmentResDTO dossAttachmentResDTO : mapList) {
            if (dossAttachmentResDTO.getFileType().equals(DocumentEvidenceTypeEnum.AGENT_IDENTIFICATION_PAPER.toString())) continue;
            XWPFTableRow comTableRowTwo = comTable.createRow();
            comTableRowTwo.getCell(0).setText("" + ++i + "");
            comTableRowTwo.addNewTableCell().setText("" + DossierAttachmentTypeEnum.valueOf((String)dossAttachmentResDTO.getFileType()).getName() + "");
            comTableRowTwo.addNewTableCell().setText("");
            comTableRowTwo.addNewTableCell().setText("");
            comTableRowTwo.setHeight(1200);
            comTableRowTwo.setRepeatHeader(true);
        }
        List rows = comTable.getRows();
        for (XWPFTableRow xwpfTableRow : rows) {
            List cells = xwpfTableRow.getTableCells();
            for (int j = 0; j < cells.size(); ++j) {
                XWPFTableCell cell = (XWPFTableCell)cells.get(j);
                CTTc cttc = cell.getCTTc();
                CTTcPr ctPr = cttc.addNewTcPr();
                ctPr.addNewVAlign().setVal(STVerticalJc.CENTER);
            }
        }
        CTSectPr cTSectPr = document.getDocument().getBody().addNewSectPr();
        XWPFHeaderFooterPolicy policy = new XWPFHeaderFooterPolicy(document, cTSectPr);
        return document;
    }

    private List<DossAttachmentResDTO> displayDossierResList(List<DossAttachmentResDTO> listAttachmentList) {
        HashMap<DocumentEvidenceTypeEnum, List> map = new HashMap<DocumentEvidenceTypeEnum, List>();
        ArrayList<DossAttachmentResDTO> dossList = new ArrayList<DossAttachmentResDTO>();
        for (DossAttachmentResDTO lawAttachment : listAttachmentList) {
            DocumentEvidenceTypeEnum documEnum = DocumentEvidenceTypeEnum.valueOf((String)lawAttachment.getFileType());
            List lists = map.computeIfAbsent(documEnum, k -> new ArrayList());
            DossAttachmentResDTO dossAttachmentResDTO = new DossAttachmentResDTO();
            dossAttachmentResDTO.setFileType(lawAttachment.getFileType());
            dossAttachmentResDTO.setFileId(lawAttachment.getFileId());
            lists.add(dossAttachmentResDTO);
        }
        for (DocumentEvidenceTypeEnum documentEnum : DocumentEvidenceTypeEnum.values()) {
            if (map.get(documentEnum) == null) continue;
            DossAttachmentResDTO dossierAttachmentResDTO = new DossAttachmentResDTO();
            dossierAttachmentResDTO.setFileType(documentEnum.toString());
            dossList.add(dossierAttachmentResDTO);
        }
        return dossList;
    }

    @Override
    public XWPFDocument finalTable(DossierDownloadRequestDTO dossierDownloadRequestDTO) {
        XWPFDocument document = new XWPFDocument();
        DossierVolumeResDTO dossierVolumeResDTO = this.lawCaseDossierApiService.queryDossier(dossierDownloadRequestDTO.getCaseId());
        AssertUtils.assertNotNull((Object)dossierVolumeResDTO, (ResultCode)ErrorCode.CASE_NOT_EXIST, (String)this.mastiffMessages.getCaseNotExist());
        AssertUtils.assertTrue((boolean)dossierVolumeResDTO.getCheckStatus().equals("AUDIT_SUCCESS"), (ResultCode)ErrorCode.CASE_NOT_EXIST, (String)this.mastiffMessages.getCaseNotExist());
        if (dossierVolumeResDTO != null) {
            XWPFParagraph paras = document.createParagraph();
            paras.setAlignment(ParagraphAlignment.RIGHT);
            paras.setBorderLeft(Borders.LIGHT_BULB);
            paras.setBorderRight(Borders.LIGHT_BULB);
            paras.setBorderTop(Borders.LIGHT_BULB);
            paras.setBorderBottom(Borders.LIGHT_BULB);
            paras.setVerticalAlignment(TextAlignment.BOTTOM);
            XWPFRun run = paras.createRun();
            run.setTextPosition(1200);
            run.setText(".");
            run = paras.createRun();
            run.setText(TableContextEnums.CREATE_NAME.getName());
            run.setText(":");
            run.setUnderline(UnderlinePatterns.SINGLE);
            run.setText(dossierVolumeResDTO.getCreateUser());
            run.setFontSize(12);
            run.addBreak();
            run = paras.createRun();
            run.setText(TableContextEnums.AUDITOR_NAME.getName());
            run.setText(":");
            run.setUnderline(UnderlinePatterns.SINGLE);
            run.setText(dossierVolumeResDTO.getAuditorName());
            run.setFontSize(12);
            run.addBreak();
            run = paras.createRun();
            run.setText(TableContextEnums.CREATE_TIME.getName());
            run.setText(":");
            run.setUnderline(UnderlinePatterns.SINGLE);
            run.setText(Java8DateUtil.formatter((Date)dossierVolumeResDTO.getAuditorTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
            run.setFontSize(12);
            run.addBreak();
        }
        return document;
    }

    @Override
    public DisplayDossierResDTO displayFileDossiers(Long caseId) {
        DisplayDossierResDTO display = this.lawCaseDossierApiService.displayFileDossier(caseId);
        return display;
    }

    @Override
    public List<LawAttachmentResDTO> getLawAttachmentListByUserIdAndCaseId(UserAttachmentListRequestDTO userAttachmentListRequestDTO) {
        return this.lawCaseDossierApiService.getLawAttachmentListByUserIdAndCaseId(userAttachmentListRequestDTO.getCaseId(), userAttachmentListRequestDTO.getPersonId());
    }
}

