/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.CasePersonAuthorityEnum;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationInfoRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationDocumentResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationInfoResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationMeetingResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationProgressResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.WorkbenchDocStatusResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.LawCasePersonnelService;
import com.beiming.odr.mastiff.service.backend.referee.MediationInfoBackService;
import com.beiming.odr.mastiff.service.backend.referee.MediationMeetingApiService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationInfoConvert;
import com.beiming.odr.mastiff.service.client.MediationService;
import com.beiming.odr.referee.api.DictServiceApi;
import com.beiming.odr.referee.dto.requestdto.MediationInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationProgressReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationProgressResDTO;
import com.beiming.odr.referee.dto.responsedto.WorkbenchDocStatusResDTO;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MediationServiceImpl
implements MediationService {
    @Resource
    MediationInfoBackService mediationInfoBackServiceImpl;
    @Resource
    MediationMeetingApiService mediationMeetingApiService;
    @Resource
    LawCasePersonnelService lawCasePersonnelService;
    @Resource
    MastiffMessages mastiffMessages;
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private DictServiceApi dictServiceApi;

    @Override
    public List<MediationProgressResponseDTO> getMediationProgress(MediationInfoRequestDTO requestDTO) {
        this.lawCasePersonnelService.authorityCheck(requestDTO.getLawCaseId(), CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_RESPONDENT, this.mastiffMessages.getUserMustApplicantOrRespondentOrAgent());
        MediationProgressReqDTO reqDTO = MediationInfoConvert.convertToMediationProgressReqDTO(requestDTO);
        DubboResult<ArrayList<MediationProgressResDTO>> resDTO = this.mediationInfoBackServiceImpl.getMediationProgress(reqDTO);
        AssertUtils.assertNotNull(resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        ArrayList resLstDTO = (ArrayList)resDTO.getData();
        return MediationInfoConvert.convertToMediationProgressResponseDTO(resLstDTO);
    }

    @Override
    public MediationInfoResponseDTO getMediationInfo(MediationInfoRequestDTO requestDTO) {
        List data1;
        MediationInfoReqDTO reqDTO = MediationInfoConvert.convertToMediationInfoReqDTO(requestDTO);
        String userId = JWTContextUtil.getCurrentUserId();
        this.lawCasePersonnelService.authorityCheck(requestDTO.getLawCaseId(), CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_RESPONDENT, this.mastiffMessages.getUserMustApplicantOrRespondentOrAgent());
        DubboResult lawCasedubboResult = this.mediationMeetingApiService.personList(reqDTO.getLawCaseId(), Long.valueOf(userId));
        ArrayList data = (ArrayList)lawCasedubboResult.getData();
        Boolean isNew = data.stream().anyMatch(a -> UserRoleEnum.MEDIATOR.name().equals(a.getCaseUserType()));
        Boolean workbenchModel = requestDTO.getWorkbenchModel() != null ? requestDTO.getWorkbenchModel() : true;
        DubboResult<MediationInfoResDTO> resDTO = this.mediationInfoBackServiceImpl.getMediationInfo(reqDTO, workbenchModel, isNew);
        AssertUtils.assertNotNull(resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        MediationInfoResDTO resInfoDTO = (MediationInfoResDTO)resDTO.getData();
        if (null != resInfoDTO.getDocuments()) {
            resInfoDTO.getDocuments().forEach(document -> {
                document.setValidity(this.mastiffMessages.getEvidenceOpinion(document.getValidity()));
                document.setRelevance(this.mastiffMessages.getEvidenceOpinion(document.getRelevance()));
                document.setAuthenticity(this.mastiffMessages.getEvidenceOpinion(document.getAuthenticity()));
            });
        }
        resInfoDTO = this.operateCardType(resInfoDTO);
        MediationInfoResponseDTO mediationInfoResponseDTO = MediationInfoConvert.convertToMediationInfoResponseDTO(resInfoDTO);
        DictionaryReqDTO dictionaryReqDTO = new DictionaryReqDTO();
        dictionaryReqDTO.setCode(mediationInfoResponseDTO.getDisputeTypeCode());
        DubboResult dictionaryResDTODubboResult = this.dictionaryServiceApi.searchDictionaryInfo(dictionaryReqDTO);
        if (dictionaryResDTODubboResult.isSuccess() && !CollectionUtils.isEmpty((Collection)(data1 = ((DictionaryResDTO)dictionaryResDTODubboResult.getData()).getData()))) {
            data1.get(0);
            mediationInfoResponseDTO.setDisputeType(((DictionaryInfoDTO)data1.get(0)).getName());
        }
        mediationInfoResponseDTO.setDisputeType((String)((Object)this.dictionaryServiceApi.translateCaseReason(mediationInfoResponseDTO.getDisputeTypeCode()).getData()));
        return mediationInfoResponseDTO;
    }

    private MediationInfoResDTO operateCardType(MediationInfoResDTO resInfoDTO) {
        List applicants = resInfoDTO.getApplicants();
        List respondents = resInfoDTO.getRespondents();
        if (!CollectionUtils.isEmpty((Collection)applicants)) {
            applicants.forEach(res -> {
                res.setCardTypeName(this.dictServiceApi.getDictName(res.getCardType()));
                res.setAgentCardTypeName(this.dictServiceApi.getDictName(res.getAgentCardType()));
            });
        }
        if (!CollectionUtils.isEmpty((Collection)respondents)) {
            respondents.forEach(res -> {
                res.setCardTypeName(this.dictServiceApi.getDictName(res.getCardType()));
                res.setAgentCardTypeName(this.dictServiceApi.getDictName(res.getAgentCardType()));
            });
        }
        resInfoDTO.setApplicants(applicants);
        resInfoDTO.setRespondents(respondents);
        return resInfoDTO;
    }

    @Override
    public List<MediationMeetingResponseDTO> getMediatorMeetings(@Valid CaseIdRequestDTO reqDTO) {
        this.lawCasePersonnelService.authorityCheck(reqDTO.getCaseId(), CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_RESPONDENT, this.mastiffMessages.getUserMustApplicantOrRespondentOrAgent());
        String userId = JWTContextUtil.getCurrentUserId();
        DubboResult lawCasedubboResult = this.mediationMeetingApiService.personList(reqDTO.getCaseId(), Long.valueOf(userId));
        ArrayList data = (ArrayList)lawCasedubboResult.getData();
        Boolean isNew = data.stream().anyMatch(a -> UserRoleEnum.MEDIATOR.name().equals(a.getCaseUserType()));
        DubboResult<ArrayList<CaseMeetingListResDTO>> resDTO = this.mediationInfoBackServiceImpl.getMediatorMeetings(reqDTO.getCaseId(), isNew);
        AssertUtils.assertNotNull(resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return MediationInfoConvert.convertToMediationMeetingResponseDTO((List)((Object)resDTO.getData()));
    }

    @Override
    public List<MediationDocumentResponseDTO> getMediatorDocuments(@Valid CaseIdRequestDTO reqDTO) {
        this.lawCasePersonnelService.authorityCheck(reqDTO.getCaseId(), CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_RESPONDENT, this.mastiffMessages.getUserMustApplicantOrRespondentOrAgent());
        DubboResult<ArrayList<CaseMaterialResDTO>> resDTO = this.mediationInfoBackServiceImpl.getMediatorDocuments(reqDTO.getCaseId());
        AssertUtils.assertNotNull(resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        List<MediationDocumentResponseDTO> mediationDocumentResponseDTOS = MediationInfoConvert.convertToMediationDocumentResponseDTO((List)((Object)resDTO.getData()));
        mediationDocumentResponseDTOS.forEach(data -> {
            data.setValidity(this.mastiffMessages.getEvidenceOpinion(data.getValidity()));
            data.setRelevance(this.mastiffMessages.getEvidenceOpinion(data.getRelevance()));
            data.setAuthenticity(this.mastiffMessages.getEvidenceOpinion(data.getAuthenticity()));
        });
        return mediationDocumentResponseDTOS;
    }

    @Override
    public List<WorkbenchDocStatusResponseDTO> getMediationWorkbenchs(@Valid MediationInfoRequestDTO requestDTO) {
        MediationInfoReqDTO reqDTO = MediationInfoConvert.convertToMediationInfoReqDTO(requestDTO);
        this.lawCasePersonnelService.authorityCheck(requestDTO.getLawCaseId(), CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_RESPONDENT, this.mastiffMessages.getUserMustApplicantOrRespondentOrAgent());
        Boolean workbenchModel = requestDTO.getWorkbenchModel() != null ? requestDTO.getWorkbenchModel() : true;
        String userId = JWTContextUtil.getCurrentUserId();
        DubboResult<ArrayList<WorkbenchDocStatusResDTO>> resDTO = this.mediationInfoBackServiceImpl.getMediationWorkbenchs(requestDTO.getLawCaseId(), Long.parseLong(userId), workbenchModel);
        AssertUtils.assertNotNull(resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return MediationInfoConvert.convertToWorkbenchDocStatusResponseDTO((List)((Object)resDTO.getData()));
    }
}

