/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.exception.APIBusinessException;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.SignatureMediatorRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SignatureRequestDTO;
import com.beiming.odr.mastiff.service.backend.referee.ClerkConfirmBackService;
import com.beiming.odr.mastiff.service.backend.referee.DocumentDubboService;
import com.beiming.odr.mastiff.service.backend.referee.SignatureBackService;
import com.beiming.odr.mastiff.service.backend.referee.convert.SignatureInfoConvert;
import com.beiming.odr.mastiff.service.backend.storage.StorageDubboService;
import com.beiming.odr.mastiff.service.client.SignatureService;
import com.beiming.odr.referee.dto.requestdto.SignatureInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmPerResDTO;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SignatureServiceImpl
implements SignatureService {
    private static final Logger log = LoggerFactory.getLogger(SignatureServiceImpl.class);
    @Resource
    SignatureBackService signatureBackServiceImpl;
    @Resource
    DocumentDubboService documentDubboServiceImpl;
    @Resource
    ClerkConfirmBackService clerkConfirmBackServiceImpi;
    @Resource
    StorageDubboService storageDubboServiceImpl;
    @Resource
    MastiffMessages mastiffMessages;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String confirmSignature(@Valid SignatureRequestDTO requestDTO) {
        SignatureInfoReqDTO reqDTO = SignatureInfoConvert.convertToSignatureInfoReqDTO(requestDTO);
        DubboResult<String> resDTO = this.signatureBackServiceImpl.confirmSignature(reqDTO);
        AssertUtils.assertTrue((boolean)resDTO.isSuccess(), (ResultCode)ErrorCode.RESULT_IS_NULL, (String)resDTO.getMessage());
        AssertUtils.assertNotNull((Object)resDTO.getData(), (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return (String)((Object)resDTO.getData());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String confirmSignature(@Valid SignatureMediatorRequestDTO requestDTO, MultipartFile signFile) {
        Long userId = requestDTO.getUserId();
        Long documentId = requestDTO.getDocumentId();
        Integer degree = requestDTO.getDegree();
        AssertUtils.assertNotNull((Object)signFile, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getSignatureImageNotExit());
        String fileName = signFile.getOriginalFilename();
        AssertUtils.assertTrue((boolean)JavaFileUtil.isPictureExt((String)fileName), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getSignatureImageNotExit());
        DubboResult<ClerkConfirmPerResDTO> judgeRes = this.clerkConfirmBackServiceImpi.judgeSignaturePermission(userId, documentId);
        AssertUtils.assertTrue((boolean)judgeRes.isSuccess(), (ResultCode)ErrorCode.RESULT_IS_NULL, (String)judgeRes.getMessage());
        AssertUtils.assertNotNull((Object)judgeRes.getData(), (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        byte[] signFileByteArr = null;
        try {
            signFileByteArr = signFile.getBytes();
            if (null != degree && !degree.equals(0)) {
                signFileByteArr = JavaFileUtil.rotateImg((byte[])signFile.getBytes(), (int)degree, null);
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
            throw new APIBusinessException((APIResultCode)APIResultCodeEnums.RESULT_EMPTY, this.mastiffMessages.getSignatureImageRotateError());
        }
        DubboResult<SaveFileResponseDTO> saveFileRes = this.storageDubboServiceImpl.save(fileName, signFileByteArr);
        AssertUtils.assertNotNull(saveFileRes, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)this.mastiffMessages.getSignatureImageSaveFail());
        SaveFileResponseDTO saveFileresDTO = (SaveFileResponseDTO)saveFileRes.getData();
        String imgId = saveFileresDTO.getFileId();
        AssertUtils.assertHasText((String)imgId, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)this.mastiffMessages.getSignatureImgIdNotBlank());
        SignatureInfoReqDTO reqDTO = new SignatureInfoReqDTO(userId, documentId, imgId, degree);
        DubboResult<String> resDTO = this.signatureBackServiceImpl.confirmSignature(reqDTO);
        AssertUtils.assertTrue((boolean)resDTO.isSuccess(), (ResultCode)ErrorCode.RESULT_IS_NULL, (String)resDTO.getMessage());
        AssertUtils.assertNotNull((Object)resDTO.getData(), (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return (String)((Object)resDTO.getData());
    }
}

