/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.thirty.tdh;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.odr.mastiff.common.enums.MastiffRedisKeyEnums;
import com.beiming.odr.referee.api.EvaluateAPi;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class TDHCodeCacheService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TDHCodeCacheService.class);
    @Resource
    private EvaluateAPi evaluateAPi;
    @Resource
    private RedisService redisService;
    private boolean initSuccess = false;

    public <T> T getCacheValueByTHDCode(String suffix) {
        if (this.initSuccess) {
            return (T)this.redisService.get((RedisKey)MastiffRedisKeyEnums.THD_CODE, suffix);
        }
        try {
            this.initCache();
            Thread.sleep(3000L);
            return this.getCacheValueByTHDCode(suffix);
        }
        catch (Exception e) {
            log.error("constant init fail", (Throwable)e);
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        try {
            log.info("constant init...................  ............");
            this.initCache();
            log.info("constant init successful...................  ............");
        }
        catch (Exception e) {
            log.error("constant init fail", (Throwable)e);
        }
    }

    private void initCache() {
        DubboResult dictList = this.evaluateAPi.getDictList();
        AppNameContextHolder.setAppName((String)"hnswodr");
        if (dictList.isSuccess()) {
            ((ArrayList)dictList.getData()).stream().filter(dictDTO -> null != dictDTO.getGhCode()).forEach(dictDTO -> this.redisService.set((RedisKey)MastiffRedisKeyEnums.THD_CODE, dictDTO.getCode(), (Object)dictDTO.getGhCode()));
            this.initSuccess = true;
        }
    }
}

