/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.utils;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.PetitionAgentRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveCaseUserRequestDTO;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;
import java.util.List;

public class CaseCheckHelper {
    public static void checkApplicantRequired(List<SaveCaseUserRequestDTO> list) {
        for (int j = 0; j < list.size(); ++j) {
            SaveCaseUserRequestDTO dto = list.get(j);
            int i = j + 1;
            dto.setCaseUserType(CaseUserTypeEnum.APPLICANT);
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getUserName()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + i + "\u540d\u79f0\u4e3a\u7a7a"));
            AssertUtils.assertFalse((StringUtils.isBlank((String)dto.getPhone()) && StringUtils.isBlank((String)dto.getEmail()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u8054\u7cfb\u7535\u8bdd\u4e0e\u7535\u5b50\u90ae\u7bb1\u6700\u5c11\u9009\u586b\u4e00\u9879"));
            if (StringUtils.isNotBlank((CharSequence)dto.getPhone())) {
                AssertUtils.assertTrue((boolean)dto.getPhone().matches("^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if ("09_00015-1".equals(dto.getCardType()) && StringUtils.isNotBlank((CharSequence)dto.getIdCard())) {
                AssertUtils.assertTrue((18 == dto.getIdCard().length() || 15 == dto.getIdCard().length() ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba\u8eab\u4efd\u8bc1" + dto.getIdCard() + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if ("09_00015-1".equals(dto.getAgentCardType())) {
                AssertUtils.assertTrue((!StringUtils.isEmpty((String)dto.getAgentIdCard()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba\u8eab\u4efd\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.assertTrue((18 == dto.getAgentIdCard().length() || 15 == dto.getAgentIdCard().length() ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba\u8eab\u4efd\u8bc1" + dto.getAgentIdCard() + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getCreditCode())) {
                AssertUtils.assertTrue((boolean)dto.getCreditCode().matches("^(?:(?![IOZSV])[\\dA-Z]){2}\\d{6}(?:(?![IOZSV])[\\dA-Z]){10}$|(^\\d{15})$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if (UserTypeEnum.NATURAL_PERSON.equals((Object)dto.getUserType())) {
                AssertUtils.assertTrue((dto.getSex() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e3a\u7a7a"));
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u8eab\u4efd\u8bc1\u4e3a\u7a7a"));
            }
            if (UserTypeEnum.JURIDICAL_PERSON.equals((Object)dto.getUserType())) {
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCorporation()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e3a\u7a7a"));
            }
            if (UserTypeEnum.UNINCORPORATED_ORGANIZATION.equals((Object)dto.getUserType())) {
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCorporation()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e3a\u7a7a"));
            }
            if ((dto.getAgentUserType() == null || !StringUtils.isNotBlank((CharSequence)dto.getAgentName())) && !StringUtils.isNotBlank((CharSequence)dto.getAgentPhone()) && !StringUtils.isNotBlank((CharSequence)dto.getAgentIdCard()) && !StringUtils.isNotBlank((CharSequence)dto.getAgentFileId())) continue;
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getAgentName()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u59d3\u540d\u4e3a\u7a7a"));
            AssertUtils.assertFalse((StringUtils.isBlank((String)dto.getAgentPhone()) && StringUtils.isBlank((String)dto.getAgentEmail()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0e\u7535\u5b50\u90ae\u7bb1\u6700\u5c11\u9009\u586b\u4e00\u9879"));
            if (StringUtils.isNotBlank((CharSequence)dto.getAgentPhone())) {
                AssertUtils.assertTrue((boolean)dto.getAgentPhone().matches("^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getAgentCardType()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u7a7a"));
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getAgentIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u8eab\u4efd\u8bc1\u4e3a\u7a7a"));
            AssertUtils.assertTrue((dto.getAgentSex() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u6027\u522b\u4e3a\u7a7a"));
        }
    }

    public static void checkRespondentRequired(List<SaveCaseUserRequestDTO> list) {
        for (int j = 0; j < list.size(); ++j) {
            SaveCaseUserRequestDTO dto = list.get(j);
            int i = j + 1;
            dto.setCaseUserType(CaseUserTypeEnum.RESPONDENT);
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getUserName()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + i + "\u540d\u79f0\u4e3a\u7a7a"));
            AssertUtils.assertFalse((StringUtils.isBlank((String)dto.getPhone()) && StringUtils.isBlank((String)dto.getEmail()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u8054\u7cfb\u7535\u8bdd\u4e0e\u7535\u5b50\u90ae\u7bb1\u6700\u5c11\u9009\u586b\u4e00\u9879"));
            if (StringUtils.isNotBlank((CharSequence)dto.getPhone())) {
                AssertUtils.assertTrue((boolean)dto.getPhone().matches("^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if ("09_00015-1".equals(dto.getCardType()) && null != dto.getIdCard()) {
                AssertUtils.assertTrue((18 == dto.getIdCard().length() || 15 == dto.getIdCard().length() ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba\u8eab\u4efd\u8bc1" + dto.getIdCard() + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if ("09_00015-1".equals(dto.getAgentCardType()) && null != dto.getAgentIdCard()) {
                AssertUtils.assertTrue((18 == dto.getAgentIdCard().length() || 15 == dto.getAgentIdCard().length() ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba\u8eab\u4efd\u8bc1" + dto.getAgentIdCard() + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getCreditCode())) {
                AssertUtils.assertTrue((boolean)dto.getCreditCode().matches("^(?:(?![IOZSV])[\\dA-Z]){2}\\d{6}(?:(?![IOZSV])[\\dA-Z]){10}$|(^\\d{15})$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            if (UserTypeEnum.NATURAL_PERSON.equals((Object)dto.getUserType())) {
                AssertUtils.assertTrue((dto.getSex() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u6027\u522b\u4e3a\u7a7a"));
            }
            if (UserTypeEnum.JURIDICAL_PERSON.equals((Object)dto.getUserType())) {
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCorporation()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e3a\u7a7a"));
            }
            if (UserTypeEnum.UNINCORPORATED_ORGANIZATION.equals((Object)dto.getUserType())) {
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCorporation()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u673a\u6784\u4ee3\u8868\u4eba\u4e3a\u7a7a"));
            }
            if ((dto.getAgentUserType() == null || !StringUtils.isNotBlank((CharSequence)dto.getAgentName())) && !StringUtils.isNotBlank((CharSequence)dto.getAgentPhone()) && !StringUtils.isNotBlank((CharSequence)dto.getAgentIdCard()) && !StringUtils.isNotBlank((CharSequence)dto.getAgentFileId())) continue;
            AssertUtils.assertFalse((StringUtils.isBlank((String)dto.getAgentPhone()) && StringUtils.isBlank((String)dto.getAgentEmail()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0e\u7535\u5b50\u90ae\u7bb1\u6700\u5c11\u9009\u586b\u4e00\u9879"));
            if (!StringUtils.isNotBlank((CharSequence)dto.getAgentPhone())) continue;
            AssertUtils.assertTrue((boolean)dto.getAgentPhone().matches("^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4ee3\u7406\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
    }

    public static void checkPetitionAgentInfo(PetitionAgentRequestDTO dto, List<SaveCaseUserRequestDTO> appList, List<SaveCaseUserRequestDTO> resList) {
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getUserName()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4fe1\u8bbf\u4ee3\u7406\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.assertTrue((dto.getSex() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4fe1\u8bbf\u4ee3\u7406\u4eba\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getPhone()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4fe1\u8bbf\u4ee3\u7406\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.assertTrue((boolean)dto.getPhone().matches("^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4fe1\u8bbf\u4ee3\u7406\u4eba\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getIdCard()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4fe1\u8bbf\u4ee3\u7406\u4eba\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.assertTrue((boolean)dto.getIdCard().matches("^\\d{6}(18|19|20)?\\d{2}(0[1-9]|1[012])(0[1-9]|[12]\\d|3[01])\\d{3}(\\d|[xX])$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4fe1\u8bbf\u4ee3\u7406\u4eba\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getProxyFileId()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4fe1\u8bbf\u4ee3\u7406\u4eba\u6388\u6743\u59d4\u6258\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
        for (SaveCaseUserRequestDTO requestDTO : appList) {
            AssertUtils.assertFalse((boolean)dto.getPhone().equals(requestDTO.getPhone()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u4fe1\u8bbf\u4ee3\u7406\u4eba\u4e0e\u7533\u8bf7\u4eba" + requestDTO.getUserName() + "\u91cd\u590d"));
            AssertUtils.assertFalse((StringUtils.isNotBlank((CharSequence)requestDTO.getAgentPhone()) && dto.getPhone().equals(requestDTO.getAgentPhone()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u4fe1\u8bbf\u4ee3\u7406\u4eba\u4e0e\u7533\u8bf7\u65b9" + requestDTO.getUserName() + "\u7684\u4ee3\u7406\u4eba\u91cd\u590d"));
        }
        for (SaveCaseUserRequestDTO requestDTO : resList) {
            AssertUtils.assertFalse((boolean)dto.getPhone().equals(requestDTO.getPhone()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u4fe1\u8bbf\u4ee3\u7406\u4eba\u4e0e\u88ab\u7533\u8bf7\u4eba" + requestDTO.getUserName() + "\u91cd\u590d"));
            AssertUtils.assertFalse((StringUtils.isNotBlank((CharSequence)requestDTO.getAgentPhone()) && dto.getPhone().equals(requestDTO.getAgentPhone()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u4fe1\u8bbf\u4ee3\u7406\u4eba\u4e0e\u88ab\u7533\u8bf7\u65b9" + requestDTO.getUserName() + "\u7684\u4ee3\u7406\u4eba\u91cd\u590d"));
        }
    }

    public static boolean checkAddress(SaveCaseUserRequestDTO req) {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)req.getProvCode()) && StringUtils.isNotBlank((CharSequence)req.getCityCode()) && StringUtils.isNotBlank((CharSequence)req.getAreaCode()) && StringUtils.isNotBlank((CharSequence)req.getStreetCode()) && StringUtils.isNotBlank((CharSequence)req.getProvName()) && StringUtils.isNotBlank((CharSequence)req.getCityName()) && StringUtils.isNotBlank((CharSequence)req.getAreaName()) && StringUtils.isNotBlank((CharSequence)req.getStreetName())) {
            flag = true;
        }
        return flag;
    }
}

