/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.utils;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

@Component
public class RedisSequenceFactory {
    @Autowired
    RedisTemplate<String, Serializable> mRedisTemp;

    public void set(String key, int value, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.mRedisTemp.getConnectionFactory());
        counter.set((long)value);
        counter.expireAt(expireTime);
    }

    public void set(String key, int value, long timeout, TimeUnit unit) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.mRedisTemp.getConnectionFactory());
        counter.set((long)value);
        counter.expire(timeout, unit);
    }

    public long generate(String key) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.mRedisTemp.getConnectionFactory());
        return counter.incrementAndGet();
    }

    public long generate(String key, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.mRedisTemp.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.incrementAndGet();
    }

    public long generate(String key, int increment) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.mRedisTemp.getConnectionFactory());
        return counter.addAndGet((long)increment);
    }

    public long generate(String key, int increment, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.mRedisTemp.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.addAndGet((long)increment);
    }
}

