/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.convert;

import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.enums.FileTypeEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.BatchFilesRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.EditCaseDisputeRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.EvidenceRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.FilesRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.PetitionAgentRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.AddressRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.AttributeDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.CenterMediationCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.center.CenterSaveCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.SaveCaseUserResponseDTO;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.requestdto.BatchFilesDTO;
import com.beiming.odr.referee.dto.requestdto.EditCaseDisputeReqDTO;
import com.beiming.odr.referee.dto.requestdto.FilesUploadDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationTdhCaseUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.PartyAgentFilesRequestDTO;
import com.beiming.odr.referee.dto.requestdto.PetitionAgentReqDTO;
import com.beiming.odr.referee.dto.responsedto.SaveCaseUserResDTO;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public class MediationCaseConvert {
    public static CaseUserRegisterReqDTO getCaseUserRegisterReqDTO(CenterSaveCaseUserRequestDTO dto) {
        CaseUserRegisterReqDTO reqDTO = new CaseUserRegisterReqDTO();
        List applyList = dto.getApplyList();
        AddressRequestDTO address = dto.getApplyAddress();
        if (dto.getUserType().equals((Object)UserTypeEnum.NATURAL_PERSON)) {
            reqDTO.setUserName(MediationCaseConvert.getFieldValue(applyList, "name"));
        } else {
            reqDTO.setUserName(MediationCaseConvert.getFieldValue(applyList, "representName"));
        }
        reqDTO.setMobilePhone(MediationCaseConvert.getFieldValue(applyList, "phone"));
        reqDTO.setIdCard(MediationCaseConvert.getFieldValue(applyList, "idCard"));
        reqDTO.setPassword("Aa@123456");
        reqDTO.setProvinceCode(address.getProvCode());
        reqDTO.setProvinceName(address.getProvName());
        reqDTO.setCityCode(address.getCityCode());
        reqDTO.setCityName(address.getCityName());
        reqDTO.setAreaCode(address.getAreaCode());
        reqDTO.setAreaName(address.getAreaName());
        reqDTO.setStreetCode(address.getStreetCode());
        reqDTO.setStreetName(address.getStreetName());
        reqDTO.setDetailedAddress(MediationCaseConvert.getFieldValue(applyList, "address"));
        return reqDTO;
    }

    public static String getFieldValue(List<AttributeDTO> applyList, String field) {
        Optional<AttributeDTO> value = applyList.stream().filter(f -> field.equals(f.getAttributeCode())).findFirst();
        if (value.isPresent()) {
            return value.get().getAttributeValue();
        }
        return "";
    }

    public static String getFieldAttributeName(List<AttributeDTO> applyList, String field) {
        Optional<String> value = applyList.stream().filter(f -> field.equals(f.getAttributeCode())).map(AttributeDTO::getAttributeName).findFirst();
        return value.orElse("");
    }

    public static CaseUserRegisterReqDTO getCaseUserRegisterReqDTO(SaveCaseUserRequestDTO dto) {
        CaseUserRegisterReqDTO reqDTO = new CaseUserRegisterReqDTO();
        if (dto.getUserType().equals((Object)UserTypeEnum.NATURAL_PERSON)) {
            reqDTO.setUserName(dto.getUserName());
        } else {
            reqDTO.setUserName(dto.getCorporation());
        }
        reqDTO.setMobilePhone(dto.getPhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setPassword("Aa@123456");
        reqDTO.setProvinceCode(dto.getProvCode());
        reqDTO.setProvinceName(dto.getProvName());
        reqDTO.setCityCode(dto.getCityCode());
        reqDTO.setCityName(dto.getCityName());
        reqDTO.setAreaCode(dto.getAreaCode());
        reqDTO.setAreaName(dto.getAreaName());
        reqDTO.setStreetCode(dto.getStreetCode());
        reqDTO.setStreetName(dto.getStreetName());
        reqDTO.setDetailedAddress(dto.getAddress());
        reqDTO.setCardType(dto.getCardType());
        reqDTO.setNation(dto.getNation());
        reqDTO.setNationality(dto.getNationality());
        reqDTO.setEmail(dto.getEmail());
        return reqDTO;
    }

    public static MediationCaseReqDTO getMediationCaseReqConvert(CenterMediationCaseRequestDTO requestDTO) {
        MediationCaseUserReqDTO userReqDTO;
        MediationCaseReqDTO reqDTO = new MediationCaseReqDTO();
        AddressRequestDTO address = requestDTO.getAddressRequestDTO();
        List disputeAttrList = requestDTO.getDisputeList();
        reqDTO.setDisputesId(requestDTO.getDisputeId());
        reqDTO.setMediationType(requestDTO.getMediationType().name());
        reqDTO.setDisputeTypeCode(requestDTO.getDisputeType().name());
        reqDTO.setDisputeType(requestDTO.getDisputeType().getName());
        reqDTO.setProvCode(address.getProvCode());
        reqDTO.setCityCode(address.getCityCode());
        reqDTO.setAreaCode(address.getAreaCode());
        reqDTO.setStreetCode(address.getStreetCode());
        reqDTO.setProvName(address.getProvName());
        reqDTO.setCityName(address.getCityName());
        reqDTO.setAreaName(address.getAreaName());
        reqDTO.setStreetName(address.getStreetName());
        reqDTO.setAddress(MediationCaseConvert.getFieldValue(disputeAttrList, "address"));
        reqDTO.setDisputeContent(MediationCaseConvert.getFieldValue(disputeAttrList, "disputeDesc"));
        reqDTO.setAppeal(MediationCaseConvert.getFieldValue(disputeAttrList, "appealContent"));
        reqDTO.setOrgId(Long.valueOf(MediationCaseConvert.getFieldValue(disputeAttrList, "mediationAgency")));
        reqDTO.setOrgName(requestDTO.getOrgName());
        reqDTO.setOrgAreaCode(requestDTO.getOrgAreaCode());
        String mediatorId = MediationCaseConvert.getFieldValue(disputeAttrList, "mediator");
        reqDTO.setMediatorId(StringUtils.isBlank((String)mediatorId) ? null : Long.valueOf(mediatorId));
        ArrayList personnelList = Lists.newArrayList();
        for (CenterSaveCaseUserRequestDTO userRequestDTO : requestDTO.getApplyUserList()) {
            userReqDTO = MediationCaseConvert.getMediationCaseUserReqConvert(userRequestDTO);
            userReqDTO.setCaseUserType(CaseUserTypeEnum.APPLICANT.name());
            personnelList.add(userReqDTO);
        }
        for (CenterSaveCaseUserRequestDTO userRequestDTO : requestDTO.getRespondentUserList()) {
            userReqDTO = MediationCaseConvert.getMediationCaseUserReqConvert(userRequestDTO);
            userReqDTO.setCaseUserType(CaseUserTypeEnum.RESPONDENT.name());
            personnelList.add(userReqDTO);
        }
        reqDTO.setPersonnelList((List)personnelList);
        return reqDTO;
    }

    public static MediationCaseReqDTO getMediationCaseReqConvert(MediationCaseRequestDTO requestDTO) {
        List respondentUserList;
        MediationCaseReqDTO reqDTO = new MediationCaseReqDTO();
        reqDTO.setGsCaseId(requestDTO.getGsCaseId());
        reqDTO.setGsCaseNo(requestDTO.getGsCaseNo());
        reqDTO.setDisputesId(requestDTO.getDisputeId());
        reqDTO.setMediationType(null == requestDTO.getMediationType() ? null : requestDTO.getMediationType().name());
        reqDTO.setDisputeTypeCode(requestDTO.getDisputeTypeCode());
        reqDTO.setDisputeType(requestDTO.getDisputeType());
        reqDTO.setProvCode(requestDTO.getProvCode());
        reqDTO.setCityCode(requestDTO.getCityCode());
        reqDTO.setAreaCode(requestDTO.getAreaCode());
        reqDTO.setStreetCode(requestDTO.getStreetCode());
        reqDTO.setCommunityCode(requestDTO.getCommunityCode());
        reqDTO.setProvName(requestDTO.getProvName());
        reqDTO.setCityName(requestDTO.getCityName());
        reqDTO.setAreaName(requestDTO.getAreaName());
        reqDTO.setStreetName(requestDTO.getStreetName());
        reqDTO.setCommunityName(requestDTO.getCommunityName());
        reqDTO.setDisputeContent(requestDTO.getDisputeContent());
        reqDTO.setAppeal(requestDTO.getAppeal());
        reqDTO.setAddress(requestDTO.getAddress());
        reqDTO.setOrgId(requestDTO.getOrgId());
        reqDTO.setOrgName(requestDTO.getOrgName());
        reqDTO.setOrgAreaCode(requestDTO.getOrgAreaCode());
        reqDTO.setMediatorId(requestDTO.getMediatorId());
        reqDTO.setCiteCaseId(requestDTO.getCiteCaseId());
        reqDTO.setCiteCaseName(requestDTO.getCiteCaseName());
        reqDTO.setNationCode(requestDTO.getNationCode());
        reqDTO.setNationName(requestDTO.getNationName());
        ArrayList<MediationCaseUserReqDTO> personnelList = new ArrayList<MediationCaseUserReqDTO>();
        List applyUserList = requestDTO.getApplyUserList();
        if (null != applyUserList) {
            for (int i = 0; i < applyUserList.size(); ++i) {
                SaveCaseUserRequestDTO userRequestDTO = (SaveCaseUserRequestDTO)applyUserList.get(i);
                MediationCaseUserReqDTO userReqDTO = MediationCaseConvert.getMediationCaseUserReqConvert(userRequestDTO);
                userReqDTO.setOrder(Integer.valueOf(i + 1));
                userReqDTO.setCaseUserType(CaseUserTypeEnum.APPLICANT.name());
                userReqDTO.setCiteAgentId(userRequestDTO.getCiteAgentId());
                userReqDTO.setCitePartyId(userRequestDTO.getCitePartyId());
                personnelList.add(userReqDTO);
            }
        }
        if (null != (respondentUserList = requestDTO.getRespondentUserList())) {
            for (int i = 0; i < respondentUserList.size(); ++i) {
                SaveCaseUserRequestDTO userRequestDTO = (SaveCaseUserRequestDTO)respondentUserList.get(i);
                MediationCaseUserReqDTO userReqDTO = MediationCaseConvert.getMediationCaseUserReqConvert(userRequestDTO);
                userReqDTO.setOrder(Integer.valueOf(i + 1));
                userReqDTO.setCaseUserType(CaseUserTypeEnum.RESPONDENT.name());
                userReqDTO.setCiteAgentId(userRequestDTO.getCiteAgentId());
                userReqDTO.setCitePartyId(userRequestDTO.getCitePartyId());
                personnelList.add(userReqDTO);
            }
        }
        reqDTO.setPersonnelList(personnelList);
        PetitionAgentRequestDTO petitionAgentDTO = requestDTO.getPetitionAgentDTO();
        if (petitionAgentDTO != null) {
            PetitionAgentReqDTO petition = new PetitionAgentReqDTO();
            petition.setUserId(petitionAgentDTO.getUserId());
            petition.setUserName(petitionAgentDTO.getUserName());
            petition.setSex(petitionAgentDTO.getSex());
            petition.setPhone(petitionAgentDTO.getPhone());
            petition.setIdCard(petitionAgentDTO.getIdCard());
            petition.setProxyFileId(petitionAgentDTO.getProxyFileId());
            petition.setProxyFileName(petitionAgentDTO.getProxyFileName());
            reqDTO.setPetitionAgentReqDTO(petition);
        }
        MediationCaseConvert.generateUploadMaterials(requestDTO, reqDTO);
        if (null == requestDTO.getEvidenceList()) {
            return reqDTO;
        }
        ArrayList<com.beiming.odr.referee.dto.requestdto.EvidenceRequestDTO> evidenceList = new ArrayList<com.beiming.odr.referee.dto.requestdto.EvidenceRequestDTO>();
        for (int i = 0; i < requestDTO.getEvidenceList().size(); ++i) {
            com.beiming.odr.referee.dto.requestdto.EvidenceRequestDTO evidence = new com.beiming.odr.referee.dto.requestdto.EvidenceRequestDTO();
            evidence.setEvidenceName(((EvidenceRequestDTO)requestDTO.getEvidenceList().get(i)).getZjmc());
            if (((EvidenceRequestDTO)requestDTO.getEvidenceList().get(i)).getZmdx() != null) {
                evidence.setEvidenceObj(((EvidenceRequestDTO)requestDTO.getEvidenceList().get(i)).getZmdx());
            }
            evidence.setSource(((EvidenceRequestDTO)requestDTO.getEvidenceList().get(i)).getZjly());
            evidence.setUrl(((EvidenceRequestDTO)requestDTO.getEvidenceList().get(i)).getZjwjUrl());
            evidenceList.add(evidence);
        }
        reqDTO.setEvidenceList(evidenceList);
        return reqDTO;
    }

    private static void generateUploadMaterials(MediationCaseRequestDTO requestDTO, MediationCaseReqDTO reqDTO) {
        if (!CollectionUtils.isEmpty((Collection)requestDTO.getUploadMaterials())) {
            ArrayList<BatchFilesDTO> uploadMaterials = new ArrayList<BatchFilesDTO>();
            for (BatchFilesRequestDTO uploadMaterial : requestDTO.getUploadMaterials()) {
                BatchFilesDTO uploadDto = new BatchFilesDTO();
                uploadDto.setCaseId(uploadMaterial.getCaseId());
                uploadDto.setCategoryMiddle(uploadMaterial.getCategoryMiddle());
                uploadDto.setSign(uploadMaterial.getSign());
                if (!CollectionUtils.isEmpty((Collection)uploadMaterial.getFiles())) {
                    ArrayList<FilesUploadDTO> fudList = new ArrayList<FilesUploadDTO>();
                    for (FilesRequestDTO file : uploadMaterial.getFiles()) {
                        FilesUploadDTO fud = new FilesUploadDTO();
                        fud.setFileId(file.getFileId());
                        fud.setFileName(file.getFileName());
                        fud.setFileBase64(file.getFileBase64());
                        fudList.add(fud);
                    }
                    uploadDto.setFiles(fudList);
                }
                uploadDto.setFileType(FileTypeEnum.MEDIATE_FILE.name());
                if (StringUtils.isEmpty((String)requestDTO.getCaseOrigin())) {
                    uploadDto.setUserName(JWTContextUtil.getCurrentUserName());
                } else {
                    uploadDto.setUserName(StringUtils.isEmpty((String)uploadMaterial.getUserName()) ? "\u6d77\u5357\u56fd\u5546\u5e73\u53f0" : uploadDto.getUserName());
                }
                uploadMaterials.add(uploadDto);
            }
            reqDTO.setCaseOrigin(requestDTO.getCaseOrigin());
            reqDTO.setUploadMaterials(uploadMaterials);
        }
    }

    public static MediationCaseUserReqDTO getMediationCaseUserReqConvert(CenterSaveCaseUserRequestDTO requestDTO) {
        MediationCaseUserReqDTO reqDTO = new MediationCaseUserReqDTO();
        List attrApplyList = requestDTO.getApplyList();
        List agentList = requestDTO.getAgentList();
        AddressRequestDTO address = requestDTO.getApplyAddress();
        reqDTO.setId(requestDTO.getId());
        reqDTO.setCaseId(requestDTO.getCaseId());
        reqDTO.setUserId(requestDTO.getUserId());
        reqDTO.setUserType(requestDTO.getUserType().name());
        reqDTO.setName(MediationCaseConvert.getFieldValue(attrApplyList, "name"));
        String applySex = MediationCaseConvert.getFieldValue(attrApplyList, "sex");
        if (StringUtils.isBlank((String)applySex)) {
            reqDTO.setSex(null);
        } else {
            reqDTO.setSex(applySex);
        }
        reqDTO.setPhone(MediationCaseConvert.getFieldValue(attrApplyList, "phone"));
        reqDTO.setIdCard(MediationCaseConvert.getFieldValue(attrApplyList, "idCard"));
        reqDTO.setProvCode(address.getProvCode());
        reqDTO.setCityCode(address.getCityCode());
        reqDTO.setAreaCode(address.getAreaCode());
        reqDTO.setStreetCode(address.getStreetCode());
        reqDTO.setProvName(address.getProvName());
        reqDTO.setCityName(address.getCityName());
        reqDTO.setAreaName(address.getAreaName());
        reqDTO.setStreetName(address.getStreetName());
        reqDTO.setAddress(MediationCaseConvert.getFieldValue(attrApplyList, "address"));
        reqDTO.setCreditCode(MediationCaseConvert.getFieldValue(attrApplyList, "creditCode"));
        reqDTO.setCorporation(MediationCaseConvert.getFieldValue(attrApplyList, "representName"));
        reqDTO.setAgentId(requestDTO.getAgentId());
        reqDTO.setAgentType(requestDTO.getAgentUserType().name());
        reqDTO.setAgentName(MediationCaseConvert.getFieldValue(agentList, "agentName"));
        String agentSex = MediationCaseConvert.getFieldValue(agentList, "sex");
        if (StringUtils.isBlank((String)agentSex)) {
            reqDTO.setAgentSex(null);
        } else {
            reqDTO.setAgentSex(agentSex);
        }
        reqDTO.setAgentPhone(MediationCaseConvert.getFieldValue(agentList, "agentPhone"));
        reqDTO.setAgentEmail(MediationCaseConvert.getFieldValue(agentList, "agentEmail"));
        reqDTO.setAgentIdCard(MediationCaseConvert.getFieldValue(agentList, "agentIdCard"));
        reqDTO.setOrder(requestDTO.getOrder());
        reqDTO.setUserRegisterOrigin(requestDTO.getUserRegisterOrigin());
        reqDTO.setAgentRegisterOrigin(requestDTO.getAgentRegisterOrigin());
        return reqDTO;
    }

    public static MediationCaseUserReqDTO getMediationCaseUserReqConvert(SaveCaseUserRequestDTO requestDTO) {
        MediationCaseUserReqDTO reqDTO = new MediationCaseUserReqDTO();
        reqDTO.setId(requestDTO.getId());
        reqDTO.setCaseId(requestDTO.getCaseId());
        reqDTO.setUserId(requestDTO.getUserId());
        reqDTO.setUserType(null == requestDTO.getUserType() ? null : requestDTO.getUserType().name());
        reqDTO.setName(requestDTO.getUserName());
        if (requestDTO.getSex() == null) {
            reqDTO.setSex(null);
        } else {
            reqDTO.setSex(requestDTO.getSex().name());
        }
        reqDTO.setPhone(requestDTO.getPhone());
        reqDTO.setIdCard(requestDTO.getIdCard());
        reqDTO.setProvCode(requestDTO.getProvCode());
        reqDTO.setCityCode(requestDTO.getCityCode());
        reqDTO.setAreaCode(requestDTO.getAreaCode());
        reqDTO.setStreetCode(requestDTO.getStreetCode());
        reqDTO.setProvName(requestDTO.getProvName());
        reqDTO.setCityName(requestDTO.getCityName());
        reqDTO.setAreaName(requestDTO.getAreaName());
        reqDTO.setStreetName(requestDTO.getStreetName());
        reqDTO.setAddress(requestDTO.getAddress());
        reqDTO.setCreditCode(requestDTO.getCreditCode());
        reqDTO.setCorporation(requestDTO.getCorporation());
        reqDTO.setAgentId(requestDTO.getAgentId());
        reqDTO.setAgentType(requestDTO.getAgentUserType() != null ? requestDTO.getAgentUserType().name() : null);
        reqDTO.setAgentName(requestDTO.getAgentName());
        if (requestDTO.getAgentSex() == null) {
            reqDTO.setAgentSex(null);
        } else {
            reqDTO.setAgentSex(requestDTO.getAgentSex().name());
        }
        reqDTO.setAgentPhone(requestDTO.getAgentPhone());
        reqDTO.setAgentIdCard(requestDTO.getAgentIdCard());
        reqDTO.setAgentFileId(requestDTO.getAgentFileId());
        reqDTO.setAgentFileName(requestDTO.getAgentFileName());
        reqDTO.setAgentBase64File(requestDTO.getAgentBase64File());
        reqDTO.setOrder(requestDTO.getOrder());
        reqDTO.setUserRegisterOrigin(requestDTO.getUserRegisterOrigin());
        reqDTO.setAgentRegisterOrigin(requestDTO.getAgentRegisterOrigin());
        reqDTO.setTelephone(requestDTO.getTelephone());
        reqDTO.setCardType(requestDTO.getCardType());
        reqDTO.setAgentCardType(requestDTO.getAgentCardType());
        reqDTO.setNationality(requestDTO.getNationality());
        reqDTO.setAgentNationality(requestDTO.getAgentNationality());
        reqDTO.setNation(requestDTO.getNation());
        reqDTO.setAgentNation(requestDTO.getAgentNation());
        reqDTO.setEmail(requestDTO.getEmail());
        reqDTO.setAgentEmail(requestDTO.getAgentEmail());
        reqDTO.setAgentProvName(requestDTO.getAgentProvName());
        reqDTO.setAgentProvCode(requestDTO.getAgentProvCode());
        reqDTO.setAgentCityName(requestDTO.getAgentCityName());
        reqDTO.setAgentCityCode(requestDTO.getAgentCityCode());
        reqDTO.setAgentAreaName(requestDTO.getAgentAreaName());
        reqDTO.setAgentAreaCode(requestDTO.getAgentAreaCode());
        reqDTO.setAgentStreetName(requestDTO.getAgentStreetName());
        reqDTO.setAgentStreetCode(requestDTO.getAgentStreetCode());
        reqDTO.setAgentAddress(requestDTO.getAgentAddress());
        reqDTO.setAgentNationName(requestDTO.getAgentNationName());
        reqDTO.setAgentNationCode(requestDTO.getAgentNationCode());
        reqDTO.setNationCode(requestDTO.getNationCode());
        reqDTO.setNationName(requestDTO.getNationName());
        if (requestDTO.getPartyAgentFiles() != null) {
            PartyAgentFilesRequestDTO refereePartyAgentFile = new PartyAgentFilesRequestDTO();
            refereePartyAgentFile.setEvidenceName(requestDTO.getPartyAgentFiles().getEvidenceName());
            refereePartyAgentFile.setEvidenceStream(requestDTO.getPartyAgentFiles().getEvidenceStream());
            reqDTO.setPartyAgentFilesRequestDTO(refereePartyAgentFile);
        }
        return reqDTO;
    }

    public static EditCaseDisputeReqDTO getEditCaseDisputeReqDTO(EditCaseDisputeRequestDTO requestDTO) {
        EditCaseDisputeReqDTO reqDTO = new EditCaseDisputeReqDTO();
        reqDTO.setCaseId(requestDTO.getCaseId());
        reqDTO.setDisputeTypeCode(requestDTO.getDisputeTypeCode());
        reqDTO.setDisputeType(requestDTO.getDisputeType());
        reqDTO.setProvCode(requestDTO.getProvCode());
        reqDTO.setCityCode(requestDTO.getCityCode());
        reqDTO.setAreaCode(requestDTO.getAreaCode());
        reqDTO.setStreetCode(requestDTO.getStreetCode());
        reqDTO.setCommunityCode(requestDTO.getCommunityCode());
        reqDTO.setProvName(requestDTO.getProvName());
        reqDTO.setCityName(requestDTO.getCityName());
        reqDTO.setAreaName(requestDTO.getAreaName());
        reqDTO.setStreetName(requestDTO.getStreetName());
        reqDTO.setCommunityName(requestDTO.getCommunityName());
        reqDTO.setAddress(requestDTO.getAddress());
        reqDTO.setDisputeContent(requestDTO.getDisputeContent());
        reqDTO.setAppeal(requestDTO.getAppeal());
        reqDTO.setNationName(requestDTO.getNationName());
        reqDTO.setNationCode(requestDTO.getNationCode());
        reqDTO.setSaveOrSubmit(requestDTO.getSaveOrSubmit());
        if ("SAVE".equals(requestDTO.getSaveOrSubmit())) {
            reqDTO.setOrgId(requestDTO.getOrgId());
            reqDTO.setOrgName(requestDTO.getOrgName());
        }
        return reqDTO;
    }

    public static SaveCaseUserRequestDTO getSaveCaseUserRequestDTO(MediationCasePersonnelDTO personal) {
        SaveCaseUserRequestDTO request = new SaveCaseUserRequestDTO();
        request.setId(personal.getId());
        request.setCaseId(personal.getLawCaseId());
        request.setUserId(personal.getUserId());
        if (StringUtils.isNotBlank((CharSequence)personal.getUserType())) {
            request.setUserType(Enum.valueOf(UserTypeEnum.class, personal.getUserType()));
        }
        request.setUserName(personal.getName());
        if (StringUtils.isNotBlank((CharSequence)personal.getSex())) {
            request.setSex(Enum.valueOf(UserSexEnum.class, personal.getSex()));
        }
        request.setPhone(personal.getPhone());
        request.setIdCard(personal.getIdCard());
        request.setProvCode(personal.getProvCode());
        request.setCityCode(personal.getCityCode());
        request.setAreaCode(personal.getAreaCode());
        request.setStreetCode(personal.getStreetCode());
        request.setProvName(personal.getProvName());
        request.setCityName(personal.getCityName());
        request.setAreaName(personal.getAreaName());
        request.setStreetName(personal.getStreetName());
        request.setAddress(personal.getAddress());
        request.setCreditCode(personal.getCreditCode());
        request.setCorporation(personal.getCorporation());
        request.setAgentId(personal.getAgentId());
        request.setAgentName(personal.getAgentName());
        if (StringUtils.isNotBlank((CharSequence)personal.getAgentSex())) {
            request.setAgentSex(Enum.valueOf(UserSexEnum.class, personal.getAgentSex()));
        }
        request.setAgentPhone(personal.getAgentPhone());
        request.setAgentIdCard(personal.getAgentIdCard());
        return request;
    }

    public static SaveCaseUserResponseDTO getSaveCaseUserResponseDTO(SaveCaseUserResDTO resDTO) {
        SaveCaseUserResponseDTO responseDTO = new SaveCaseUserResponseDTO();
        responseDTO.setId(resDTO.getId());
        responseDTO.setAttachmentId(resDTO.getAttachmentId());
        responseDTO.setProxyFileId(resDTO.getProxyFileId());
        responseDTO.setProxyFileName(resDTO.getProxyFileName());
        return responseDTO;
    }

    public static CaseUserRegisterReqDTO getCaseUserRegisterReqDTO(MediationTdhCaseUserReqDTO dto) {
        CaseUserRegisterReqDTO reqDTO = new CaseUserRegisterReqDTO();
        if (dto.getUserType().equals(UserTypeEnum.NATURAL_PERSON.name())) {
            reqDTO.setUserName(dto.getName());
        } else {
            reqDTO.setUserName(dto.getCorporation());
        }
        reqDTO.setMobilePhone(dto.getPhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setPassword("Aa@123456");
        reqDTO.setDetailedAddress(dto.getAddress());
        reqDTO.setCardType(dto.getCardType());
        return reqDTO;
    }
}

