/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.convert;

import com.beiming.odr.mastiff.common.utils.MyStringUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationPersonalRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationRecordGetRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationRecordSaveRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationRecordSendRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.ClerkConfirmAllResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationPersonalResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationRecordGetResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationRecordSaveResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationRecordSendResponseDTO;
import com.beiming.odr.referee.dto.requestdto.MediationPersonalReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.ClerkConfirmAllResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationPersonalResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSendResDTO;
import java.util.ArrayList;
import java.util.List;

public class MediationRecordConvert {
    public static MediationRecordGetReqDTO convertToMediationRecordGetReqDTO(MediationRecordGetRequestDTO requestDTO) {
        MediationRecordGetReqDTO reqDTO = new MediationRecordGetReqDTO();
        reqDTO.setDocumentId(requestDTO.getDocumentId());
        reqDTO.setLawCaseId(requestDTO.getLawCaseId());
        reqDTO.setMeetingId(requestDTO.getMeetingId());
        return reqDTO;
    }

    public static MediationRecordSendReqDTO convertToMediationRecordSendReqDTO(MediationRecordSendRequestDTO requestDTO) {
        MediationRecordSendReqDTO reqDTO = new MediationRecordSendReqDTO();
        reqDTO.setDocumentId(requestDTO.getDocumentId());
        reqDTO.setLawCaseId(requestDTO.getLawCaseId());
        reqDTO.setMeetingId(requestDTO.getMeetingId());
        reqDTO.setCaseNo(requestDTO.getCaseNo());
        reqDTO.setDisputeType(requestDTO.getDisputeType());
        reqDTO.setContent(requestDTO.getContent());
        reqDTO.setLocation(requestDTO.getLocation());
        reqDTO.setTime(requestDTO.getTime());
        reqDTO.setRemark(requestDTO.getRemark());
        List<MediationPersonalReqDTO> mediationParticipants = MediationRecordConvert.convertToMediationPersonalReqDTO(requestDTO.getMediationParticipants(), requestDTO.getDocumentId(), requestDTO.getLawCaseId());
        reqDTO.setMediationParticipants(mediationParticipants);
        return reqDTO;
    }

    public static MediationRecordSaveReqDTO convertToMediationRecordSaveReqDTO(MediationRecordSaveRequestDTO requestDTO) {
        MediationRecordSaveReqDTO reqDTO = new MediationRecordSaveReqDTO();
        reqDTO.setDocumentId(requestDTO.getDocumentId());
        reqDTO.setLawCaseId(requestDTO.getLawCaseId());
        reqDTO.setMeetingId(requestDTO.getMeetingId());
        reqDTO.setCaseNo(requestDTO.getCaseNo());
        reqDTO.setDisputeType(requestDTO.getDisputeType());
        reqDTO.setContent(requestDTO.getContent());
        reqDTO.setLocation(requestDTO.getLocation());
        reqDTO.setTime(requestDTO.getTime());
        reqDTO.setRemark(requestDTO.getRemark());
        List<MediationPersonalReqDTO> mediationParticipants = MediationRecordConvert.convertToMediationPersonalReqDTO(requestDTO.getMediationParticipants(), requestDTO.getDocumentId(), requestDTO.getLawCaseId());
        reqDTO.setMediationParticipants(mediationParticipants);
        return reqDTO;
    }

    public static MediationRecordGetResponseDTO convertToMediationRecordGetResponseDTO(MediationRecordGetResDTO resDTO) {
        MediationRecordGetResponseDTO responseDTO = new MediationRecordGetResponseDTO();
        responseDTO.setDocumentId(resDTO.getDocumentId());
        responseDTO.setLawCaseId(resDTO.getLawCaseId());
        responseDTO.setCaseNo(MyStringUtils.translateCaseNo((String)resDTO.getCaseNo()));
        responseDTO.setDisputeType(resDTO.getDisputeType());
        responseDTO.setDisputeTypeCode(resDTO.getDisputeTypeCode());
        responseDTO.setContent(resDTO.getContent());
        responseDTO.setSendStatus(resDTO.getSendStatus());
        responseDTO.setTime(resDTO.getTime());
        responseDTO.setLocation(resDTO.getLocation());
        responseDTO.setRemark(resDTO.getRemark());
        responseDTO.setStatus(resDTO.getStatus());
        List<ClerkConfirmAllResponseDTO> lawWholeConfirms = null;
        if (resDTO.getLawWholeConfirms() != null && resDTO.getLawWholeConfirms().size() > 0) {
            lawWholeConfirms = MediationRecordConvert.convertToClerkConfirmAllResponseDTO(resDTO.getLawWholeConfirms());
        }
        List<MediationPersonalResponseDTO> mediationParticipants = MediationRecordConvert.convertToMediationPersonalResponseDTO(resDTO.getMediationParticipants());
        responseDTO.setLawWholeConfirms(lawWholeConfirms);
        responseDTO.setMediationParticipants(mediationParticipants);
        return responseDTO;
    }

    public static MediationRecordSendResponseDTO convertToMediationRecordSendResponseDTO(MediationRecordSendResDTO resDTO) {
        MediationRecordSendResponseDTO responseDTO = new MediationRecordSendResponseDTO();
        responseDTO.setDocumentId(resDTO.getDocumentId());
        return responseDTO;
    }

    public static MediationRecordSaveResponseDTO convertToMediationRecordSaveResponseDTO(MediationRecordSaveResDTO resDTO) {
        MediationRecordSaveResponseDTO responseDTO = new MediationRecordSaveResponseDTO();
        responseDTO.setDocumentId(resDTO.getDocumentId());
        return responseDTO;
    }

    private static List<MediationPersonalReqDTO> convertToMediationPersonalReqDTO(List<MediationPersonalRequestDTO> requestLstDTO, Long documentId, Long lawCaseId) {
        ArrayList<MediationPersonalReqDTO> reqLstDTO = new ArrayList<MediationPersonalReqDTO>();
        for (MediationPersonalRequestDTO requestDTO : requestLstDTO) {
            MediationPersonalReqDTO reqDTO = new MediationPersonalReqDTO();
            reqDTO.setCaseUserType(requestDTO.getCaseUserType());
            reqDTO.setName(requestDTO.getName());
            reqDTO.setUserId(requestDTO.getUserId());
            reqDTO.setDocumentId(documentId);
            reqDTO.setLawCaseId(lawCaseId);
            reqLstDTO.add(reqDTO);
        }
        return reqLstDTO;
    }

    private static List<ClerkConfirmAllResponseDTO> convertToClerkConfirmAllResponseDTO(List<ClerkConfirmAllResDTO> resLstDTO) {
        ArrayList<ClerkConfirmAllResponseDTO> responseLstDTO = new ArrayList<ClerkConfirmAllResponseDTO>();
        for (ClerkConfirmAllResDTO resDTO : resLstDTO) {
            ClerkConfirmAllResponseDTO responseDTO = new ClerkConfirmAllResponseDTO();
            responseDTO.setConfirm(resDTO.getConfirm());
            responseDTO.setUserId(resDTO.getUserId());
            responseDTO.setUserName(resDTO.getUserName());
            responseDTO.setUserType(resDTO.getUserType());
            responseDTO.setAgentId(resDTO.getAgentId());
            responseDTO.setAgentType(resDTO.getAgentType());
            responseDTO.setAgentName(resDTO.getAgentName());
            responseLstDTO.add(responseDTO);
        }
        return responseLstDTO;
    }

    private static List<MediationPersonalResponseDTO> convertToMediationPersonalResponseDTO(List<MediationPersonalResDTO> resLstDTO) {
        ArrayList<MediationPersonalResponseDTO> responseLstDTO = new ArrayList<MediationPersonalResponseDTO>();
        for (MediationPersonalResDTO resDTO : resLstDTO) {
            MediationPersonalResponseDTO responseDTO = new MediationPersonalResponseDTO();
            responseDTO.setUserId(resDTO.getUserId());
            responseDTO.setName(resDTO.getName());
            responseDTO.setCaseUserType(resDTO.getCaseUserType());
            responseDTO.setDocumentId(resDTO.getDocumentId());
            responseDTO.setLawCaseId(resDTO.getLawCaseId());
            responseLstDTO.add(responseDTO);
        }
        return responseLstDTO;
    }
}

