/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.DubboResultBuilder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuditCaseIdRequestDTO;
import com.beiming.odr.mastiff.service.backend.referee.CaseDubboService;
import com.beiming.odr.referee.api.MediationCaseApi;
import com.beiming.odr.referee.api.ThirdPartyPullApi;
import com.beiming.odr.referee.dto.requestdto.DeleteCasePersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.EditCaseDisputeReqDTO;
import com.beiming.odr.referee.dto.requestdto.FailCancelCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationTdhCaseReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseCancelApplyAuditDTO;
import com.beiming.odr.referee.dto.responsedto.SaveCaseUserResDTO;
import com.beiming.odr.referee.enums.DisputeStatusEnum;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CaseDubboServiceImpl
implements CaseDubboService {
    private static final Logger log = LoggerFactory.getLogger(CaseDubboServiceImpl.class);
    @Resource
    private MediationCaseApi mediationCaseApi;
    @Resource
    private ThirdPartyPullApi thirdPartyPullApi;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public CaseResDTO getMediationCaseInfoById(Long id) {
        log.info("{} core request id {}", (Object)JavaFileUtil.getMethodName(), (Object)id);
        try {
            DubboResult dubboResult = this.mediationCaseApi.getMediationCaseInfoById(id);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (CaseResDTO)dubboResult.getData();
            }
            log.error("{} id {},result {}", new Object[]{JavaFileUtil.getMethodName(), id, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long insertMediationCase(MediationCaseReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = null;
            dubboResult = DisputeStatusEnum.SUBMIT_CASE.getCode().equals(reqDTO.getDisputeStatus()) ? this.mediationCaseApi.insertMediationCase(reqDTO) : this.mediationCaseApi.insertMediationCaseUnsubmit(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} id {} result {}", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long insertYtMediationCase(MediationCaseReqDTO reqDTO) {
        return null;
    }

    @Override
    public Integer cancelCase(FailCancelCaseReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.mediationCaseApi.cancelLawCase(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Integer)dubboResult.getData();
            }
            log.error("{} reqDTO {},result {} ", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return 0;
    }

    @Override
    public Integer startCancelCase(FailCancelCaseReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.mediationCaseApi.startCancelLawCase(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Integer)dubboResult.getData();
            }
            log.error("{} reqDTO {},result {} ", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return 0;
    }

    @Override
    public ArrayList<LawCaseCancelApplyAuditDTO> applyOrAuditDetail(AuditCaseIdRequestDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.mediationCaseApi.applyOrAuditDetail(reqDTO.getCaseId(), reqDTO.getCancelAudit());
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (ArrayList)dubboResult.getData();
            }
            log.error("{} reqDTO {},result {} ", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return new ArrayList<LawCaseCancelApplyAuditDTO>();
    }

    @Override
    public Integer backCancelCase(FailCancelCaseReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.mediationCaseApi.backCancelLawCase(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Integer)dubboResult.getData();
            }
            log.error("{} reqDTO {},result {} ", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return 0;
    }

    @Override
    public void editCaseDisputeInfo(EditCaseDisputeReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.mediationCaseApi.editCaseDisputeInfo(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (!dubboResult.isSuccess()) {
                log.error("{} reqDTO {} result {}", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UPDATE_CASE_INFO_FAIL, (String)this.mastiffMessages.getUpdateCaseInfoError());
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
    }

    @Override
    public SaveCaseUserResDTO saveOrEditCaseUser(MediationCaseUserReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.mediationCaseApi.saveOrEditCaseUser(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (SaveCaseUserResDTO)dubboResult.getData();
            }
            log.error("{} reqDTO {} result {}", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public void deleteCasePersonnel(DeleteCasePersonnelReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.mediationCaseApi.deleteCasePersonnel(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (!dubboResult.isSuccess()) {
                log.error("{} reqDTO {} result {} ", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
    }

    @Override
    public Long insertYtMediationCase(MediationTdhCaseReqDTO data) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)data);
        try {
            DubboResult dubboResult = this.thirdPartyPullApi.insertThirdPartyMediationCase(data);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} id {} result {}", new Object[]{JavaFileUtil.getMethodName(), data, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Integer updateApprovalCase(MediationTdhCaseReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.thirdPartyPullApi.updateApprovalCase(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Integer)dubboResult.getData();
            }
            log.error("{} id {} result {}", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public DubboResult<Integer> deleteLawCase(Long caseId) {
        return this.mediationCaseApi.deleteLawCase(caseId);
    }

    @Override
    public DubboResult<Integer> deleteAllCasePersonel(Long lawCaseId) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)lawCaseId);
        try {
            DubboResult dubboResult = this.mediationCaseApi.deleteAllCasePersonel(lawCaseId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (!dubboResult.isSuccess()) {
                log.error("{} reqDTO {} result {} ", new Object[]{JavaFileUtil.getMethodName(), lawCaseId, dubboResult});
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return DubboResultBuilder.success();
    }
}

