/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.referee.DocumentDubboService;
import com.beiming.odr.referee.api.DocumentApi;
import com.beiming.odr.referee.api.DocumentApiV2;
import com.beiming.odr.referee.dto.requestdto.InvalidDocumentDTO;
import com.beiming.odr.referee.dto.requestdto.SaveJudicialConfirmBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveMediationApplyBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveProtocolBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SendFinalMediationReportReqDTO;
import com.beiming.odr.referee.dto.responsedto.JudicialConfirmBookResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationApplyBookResDTO;
import com.beiming.odr.referee.dto.responsedto.ProtocolBookResDTO;
import com.beiming.odr.referee.dto.responsedto.UnanimityMediationSchemeResDTO;
import com.beiming.odr.referee.enums.DocumentTypeEnum;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentDubboServiceImpl
implements DocumentDubboService {
    private static final Logger log = LoggerFactory.getLogger(DocumentDubboServiceImpl.class);
    @Resource
    private DocumentApi documentApi;
    @Resource
    private DocumentApiV2 documentApiV2;

    @Override
    public Boolean checkDocumentExist(Long documentId) {
        log.info("{} core request documentId {}", (Object)JavaFileUtil.getMethodName(), (Object)documentId);
        try {
            DubboResult dubboResult = this.documentApi.checkDocumentExist(documentId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Boolean)dubboResult.getData();
            }
            log.error("{} documentId {},result {} ", new Object[]{JavaFileUtil.getMethodName(), documentId, dubboResult});
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long getMediationIdByCaseId(Long caseId) {
        log.info("{} core request caseId {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        try {
            DubboResult dubboResult = this.documentApi.getMediationIdByCaseId(caseId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} caseId {},result {} ", new Object[]{JavaFileUtil.getMethodName(), caseId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public ProtocolBookResDTO getProtocolBook(Long caseId, DocumentTypeEnum documentType) {
        log.info("{} core request caseId {}, documentType {}", new Object[]{JavaFileUtil.getMethodName(), caseId, documentType});
        try {
            DubboResult dubboResult = this.documentApi.getProtocolBook(caseId, documentType);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (ProtocolBookResDTO)dubboResult.getData();
            }
            log.error("{} caseId {}, documentType {},result {} ", new Object[]{JavaFileUtil.getMethodName(), caseId, documentType, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public ProtocolBookResDTO getTempProtocolBook(Long caseId, DocumentTypeEnum documentType) {
        log.info("{} core request caseId {}, documentType {}", new Object[]{JavaFileUtil.getMethodName(), caseId, documentType});
        try {
            DubboResult dubboResult = this.documentApi.getTempProtocolBook(caseId, documentType);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (ProtocolBookResDTO)dubboResult.getData();
            }
            log.error("{} caseId {}, documentType {},result {} ", new Object[]{JavaFileUtil.getMethodName(), caseId, documentType, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public ProtocolBookResDTO saveProtocolBook(SaveProtocolBookReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.documentApi.saveProtocolBook(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (ProtocolBookResDTO)dubboResult.getData();
            }
            log.error("{} reqDTO {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long sendProtocolBook(Long documentId) {
        log.info("{} core request documentId {}", (Object)JavaFileUtil.getMethodName(), (Object)documentId);
        try {
            DubboResult dubboResult = this.documentApi.sendProtocolBook(documentId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} documentId {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), documentId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public UnanimityMediationSchemeResDTO getMediationScheme(Long caseId) {
        log.info("{} core request id {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        try {
            DubboResult dubboResult = this.documentApi.getMediationScheme(caseId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (UnanimityMediationSchemeResDTO)dubboResult.getData();
            }
            log.error("{} id {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), caseId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public void savePromiseBook(SavePromiseBookReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.documentApi.savePromiseBook(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (!dubboResult.isSuccess()) {
                log.error("{} reqDTO {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
    }

    @Override
    public void sendFinalMediationReport(SendFinalMediationReportReqDTO reqDTO) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        try {
            DubboResult dubboResult = this.documentApi.sendFinalMediationReport(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (!dubboResult.isSuccess()) {
                log.error("{} reqDTO {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), reqDTO, dubboResult});
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
    }

    @Override
    public Long refuseDocument(Long documentId, String userName) {
        log.info("{} core request reqDTO {}", (Object)JavaFileUtil.getMethodName(), (Object)documentId);
        try {
            String confirmUserId = JWTContextUtil.getCurrentUserId();
            DubboResult dubboResult = this.documentApi.refuseDocument(documentId, Long.valueOf(confirmUserId), userName);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} reqDTO {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), documentId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public JudicialConfirmBookResDTO getJudicialConfirmBook(Long caseId, DocumentTypeEnum documentTypeEnum, Integer isNew) {
        log.info("{} core request caseId {}, documentTypeEnum {}", new Object[]{JavaFileUtil.getMethodName(), caseId, documentTypeEnum});
        try {
            DubboResult dubboResult = this.documentApi.getJudicialConfirmBook(caseId, documentTypeEnum, isNew);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (JudicialConfirmBookResDTO)dubboResult.getData();
            }
            log.error("{} caseId {}, documentTypeEnum {} result {}", new Object[]{JavaFileUtil.getMethodName(), caseId, documentTypeEnum, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long saveJudicialConfirmBook(SaveJudicialConfirmBookReqDTO dto) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dto);
        try {
            DubboResult dubboResult = this.documentApi.saveJudicialConfirmBook(dto);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} dto {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), dto, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long sendJudicialConfirmBook(SaveJudicialConfirmBookReqDTO dto) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dto);
        try {
            DubboResult dubboResult = this.documentApi.sendJudicialConfirmBook(dto);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} dto {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), dto, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public MediationApplyBookResDTO getMediationApplyBook(Long caseId, DocumentTypeEnum documentTypeEnum, Integer isNew) {
        log.info("{} core request caseId {}, documentTypeEnum {}", new Object[]{JavaFileUtil.getMethodName(), caseId, documentTypeEnum});
        try {
            DubboResult dubboResult = this.documentApi.getMediationApplyBook(caseId, documentTypeEnum, isNew);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (MediationApplyBookResDTO)dubboResult.getData();
            }
            log.error("{} caseId {}, documentTypeEnum {} result {}", new Object[]{JavaFileUtil.getMethodName(), caseId, documentTypeEnum, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long saveMediationApplyBook(SaveMediationApplyBookReqDTO dto) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dto);
        try {
            DubboResult dubboResult = this.documentApi.saveMediationApplyBook(dto);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} dto {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), dto, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public Long sendMediationApplyBook(SaveMediationApplyBookReqDTO dto) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)dto);
        try {
            DubboResult dubboResult = this.documentApi.sendMediationApplyBook(dto);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (Long)dubboResult.getData();
            }
            log.error("{} dto {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), dto, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public String previewProtocolBook(Long documentId) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)documentId);
        try {
            DubboResult dubboResult = this.documentApiV2.previewProtocolBook(documentId);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (String)((Object)dubboResult.getData());
            }
            log.error("{} dto {} ,error {}", new Object[]{JavaFileUtil.getMethodName(), documentId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }

    @Override
    public void invalidProtocolBook(InvalidDocumentDTO req) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)req);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.documentApiV2.invalidProtocolBook(req);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        AssertUtils.assertTrue((Objects.nonNull(dubboResult) && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
    }
}

