/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.enums.CasePersonAuthorityEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseProtocolPersonnelRequestDTO;
import com.beiming.odr.mastiff.service.backend.referee.LawCasePersonnelService;
import com.beiming.odr.mastiff.service.backend.referee.convert.DocumentConvert;
import com.beiming.odr.referee.api.LawCasePersonnelApi;
import com.beiming.odr.referee.dto.requestdto.CaseProtocolPersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdatePartyDataReqDTO;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LawCasePersonnelServiceImpl
implements LawCasePersonnelService {
    @Resource
    private LawCasePersonnelApi lawCasePersonnelApi;

    @Override
    public void authorityCheck(Long lawCaseId, CasePersonAuthorityEnum casePersonAuthorityEnum, ResultCode resultCode, String message) {
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        this.authorityCheckByUserId(lawCaseId, userId, casePersonAuthorityEnum, resultCode, message);
    }

    @Override
    public void authorityCheckByUserId(Long lawCaseId, Long userId, CasePersonAuthorityEnum casePersonAuthorityEnum, ResultCode resultCode, String message) {
        if (!JWTContextUtil.getPersonType().equals(PersonTypeEnum.COMMON.name())) {
            return;
        }
        DubboResult lawCaseDubboResult = this.lawCasePersonnelApi.getPersonList(lawCaseId);
        ArrayList data = (ArrayList)lawCaseDubboResult.getData();
        switch (casePersonAuthorityEnum) {
            case USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT: {
                AssertUtils.assertTrue((boolean)data.stream().anyMatch(person -> userId.equals(person.getUserId()) || userId.equals(person.getAgentId()) && !CaseUserTypeEnum.MEDIATOR.equals((Object)person.getCaseUserType())), (ResultCode)resultCode, (String)message);
                break;
            }
            case USER_MUST_APPLICANT_OR_RESPONDENT: {
                AssertUtils.assertTrue((boolean)data.stream().anyMatch(person -> userId.equals(person.getUserId()) && !CaseUserTypeEnum.MEDIATOR.equals((Object)person.getCaseUserType())), (ResultCode)resultCode, (String)message);
                break;
            }
        }
    }

    @Override
    public void updatePartyData(CaseProtocolPersonnelRequestDTO dto) {
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        String userName = JWTContextUtil.getCurrentUserName();
        ArrayList<CaseProtocolPersonnelRequestDTO> personnelList = new ArrayList<CaseProtocolPersonnelRequestDTO>();
        personnelList.add(dto);
        CaseProtocolPersonnelReqDTO caseProtocolPersonnelReqDTO = DocumentConvert.getCaseProtocolPersonnelReqDTOList(personnelList).get(0);
        UpdatePartyDataReqDTO reqDTO = new UpdatePartyDataReqDTO();
        reqDTO.setCaseProtocolPersonnelReqDTO(caseProtocolPersonnelReqDTO);
        reqDTO.setUserId(userId);
        reqDTO.setUserName(userName);
        DubboResult result = this.lawCasePersonnelApi.updatePartyData(reqDTO);
    }
}

