/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.referee.MediationInfoBackService;
import com.beiming.odr.referee.api.MediationAdditionalInfoApi;
import com.beiming.odr.referee.api.MediationInfoApi;
import com.beiming.odr.referee.dto.requestdto.MediationInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationProgressReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationProgressResDTO;
import com.beiming.odr.referee.dto.responsedto.WorkbenchDocStatusResDTO;
import com.beiming.odr.user.api.UserServiceApi;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MediationInfoBackServiceImpl
implements MediationInfoBackService {
    private static final Logger log = LoggerFactory.getLogger(MediationInfoBackServiceImpl.class);
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private MediationInfoApi mediationInfoApi;
    @Resource
    private MediationAdditionalInfoApi mediationAdditionalInfoApi;

    @Override
    public DubboResult<ArrayList<MediationProgressResDTO>> getMediationProgress(MediationProgressReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.mediationInfoApi.getMediationProgress(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult<MediationInfoResDTO> getMediationInfo(MediationInfoReqDTO reqDTO, Boolean workbenchModel, Boolean isNew) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.mediationInfoApi.getMediationInfo(reqDTO, workbenchModel, isNew);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult<ArrayList<CaseMeetingListResDTO>> getMediatorMeetings(Long caseId, Boolean isNew) {
        log.info("{} core request caseId {} isNew {}", new Object[]{JavaFileUtil.getMethodName(), caseId, isNew});
        DubboResult dubboResult = null;
        try {
            dubboResult = this.mediationAdditionalInfoApi.getMediationMeetings(caseId, isNew.booleanValue());
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult<ArrayList<CaseMaterialResDTO>> getMediatorDocuments(Long caseId) {
        log.info("{} core request caseId {}", (Object)JavaFileUtil.getMethodName(), (Object)caseId);
        DubboResult dubboResult = null;
        try {
            dubboResult = this.mediationAdditionalInfoApi.getMediationDocuments(caseId);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }

    @Override
    public DubboResult<ArrayList<WorkbenchDocStatusResDTO>> getMediationWorkbenchs(Long lawCaseId, Long userId, Boolean workbenchModel) {
        log.info("{} core request caseId {} userId {} workbenchModel {}", new Object[]{JavaFileUtil.getMethodName(), lawCaseId, userId, workbenchModel});
        DubboResult dubboResult = null;
        try {
            dubboResult = this.mediationAdditionalInfoApi.getMediationWorkbench(lawCaseId, userId, workbenchModel);
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return dubboResult;
    }
}

