/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.referee.MediationRecordBackService;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.referee.api.MediationDocRecordApi;
import com.beiming.odr.referee.dto.requestdto.MediationRecordGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSendResDTO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MediationRecordBackServiceImpl
implements MediationRecordBackService {
    private static final Logger log = LoggerFactory.getLogger(MediationRecordBackServiceImpl.class);
    @Resource
    MediationDocRecordApi mediationDocRecordApi;
    @Resource
    private UserDubboService userDubboService;

    @Override
    public MediationRecordSendResDTO sendMediationRecord(MediationRecordSendReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        MediationRecordSendResDTO mediationRecordSendDTO = null;
        try {
            DubboResult dubboResult = this.mediationDocRecordApi.sendMediationRecord(reqDTO);
            if (dubboResult.isSuccess()) {
                mediationRecordSendDTO = (MediationRecordSendResDTO)dubboResult.getData();
            }
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return mediationRecordSendDTO;
    }

    @Override
    public MediationRecordSaveResDTO saveMediationRecord(MediationRecordSaveReqDTO reqDTO) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        MediationRecordSaveResDTO mediationRecordSaveDTO = null;
        try {
            DubboResult dubboResult = this.mediationDocRecordApi.saveMediationRecord(reqDTO);
            if (dubboResult.isSuccess()) {
                mediationRecordSaveDTO = (MediationRecordSaveResDTO)dubboResult.getData();
            }
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return mediationRecordSaveDTO;
    }

    @Override
    public MediationRecordGetResDTO viewMediationRecord(MediationRecordGetReqDTO reqDTO) {
        MediationRecordGetResDTO mediationRecordGetDTO = null;
        try {
            Boolean isNew = this.userDubboService.checkIsMediator(reqDTO.getLawCaseId());
            DubboResult dubboResult = this.mediationDocRecordApi.getMediationRecord(reqDTO, isNew);
            if (dubboResult.isSuccess()) {
                mediationRecordGetDTO = (MediationRecordGetResDTO)dubboResult.getData();
            }
            log.info("dubbo result=============={}", (Object)dubboResult);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return mediationRecordGetDTO;
    }
}

