/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.referee.TrialDisciplineService;
import com.beiming.odr.referee.api.MediationCaseApi;
import com.beiming.odr.referee.dto.requestdto.TrialDisciplineReqDTO;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrialDisciplineServiceImpl
implements TrialDisciplineService {
    private static final Logger log = LoggerFactory.getLogger(TrialDisciplineServiceImpl.class);
    @Resource
    private MediationCaseApi mediationCaseApi;

    @Override
    public void insertOrUpdateDiscipline(TrialDisciplineReqDTO reqDTO, HttpServletRequest request) {
        log.info("{} core request dto {}", (Object)JavaFileUtil.getMethodName(), (Object)reqDTO);
        String userId = JWTContextUtil.getCurrentUserId();
        String currentName = JWTContextUtil.getCurrentUserName();
        if (!Objects.isNull(reqDTO) && !Objects.isNull(reqDTO.getId())) {
            reqDTO.setUpdateId(Long.valueOf(userId));
            reqDTO.setUpdateUser(currentName);
            reqDTO.setUpdateTime(new Date());
        } else {
            reqDTO.setCreateId(Long.valueOf(userId));
            reqDTO.setCreateUser(currentName);
            reqDTO.setCreateTime(new Date());
        }
        DubboResult dubboResult = this.mediationCaseApi.insertOrUpdateDiscipline(reqDTO);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
    }

    @Override
    public TrialDisciplineReqDTO searchDiscipline(HttpServletRequest request) {
        DubboResult dubboResult = this.mediationCaseApi.searchDiscipline();
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)APIResultCodeEnums.ILLEGAL_PARAMETER.desc());
        return (TrialDisciplineReqDTO)dubboResult.getData();
    }
}

