/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.backend.user.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.mastiff.common.utils.JavaFileUtil;
import com.beiming.odr.mastiff.service.backend.user.ServicePersonDubboService;
import com.beiming.odr.user.api.ServicePersonServiceApi;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ServicePersonDubboServiceImpl
implements ServicePersonDubboService {
    private static final Logger log = LoggerFactory.getLogger(ServicePersonDubboServiceImpl.class);
    @Resource
    private ServicePersonServiceApi servicePersonServiceApi;

    @Override
    public SearchServicePersonResDTO getMediatorInfo(Long orgId, Long mediatorId) {
        log.info("{} core request orgId {}, mediatorId {}", new Object[]{JavaFileUtil.getMethodName(), orgId, mediatorId});
        try {
            SearchServicePersonReqDTO reqDTO = new SearchServicePersonReqDTO();
            reqDTO.setOrgUserId(orgId);
            reqDTO.setSearchUserId(mediatorId);
            DubboResult dubboResult = this.servicePersonServiceApi.searchServicePerson(reqDTO);
            log.info("dubbo result=============={}", (Object)dubboResult);
            if (dubboResult.isSuccess()) {
                return (SearchServicePersonResDTO)dubboResult.getData();
            }
            log.error("{} orgId {}, mediatorId {} result {}", new Object[]{JavaFileUtil.getMethodName(), orgId, mediatorId, dubboResult});
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        return null;
    }
}

