/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.JWTTokenTypeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.page.PageQuery;
import com.beiming.framework.security.JWTUtils;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.UUIDUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.CasePersonAuthorityEnum;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseMeetingIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseMeetingInviteRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseMeetingSaveRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetCodeQrRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetTokenRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.InviteCodeRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.LawAttachmentUpFileRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MeetingNewSaveRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.UptateEndReqDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.InviteWatchResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.CaseMeetingApiService;
import com.beiming.odr.mastiff.service.backend.referee.LawCasePersonnelService;
import com.beiming.odr.mastiff.service.client.CaseMeetingService;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingInviteReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawAttachmentUpFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateTimeReqDTO;
import com.beiming.odr.referee.dto.responsedto.BookedCaseMeetingListResponseDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingVideoResDTO;
import com.beiming.odr.referee.dto.responsedto.InviteWatchResDTO;
import com.beiming.odr.referee.enums.InviteWachEnum;
import com.beiming.odr.referee.enums.MeetingOrderEnum;
import com.beiming.odr.referee.enums.MeetingTypeNewEnum;
import com.beiming.odr.user.api.ServicePersonServiceApi;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CaseMeetingServiceImpl
implements CaseMeetingService {
    @Resource
    private CaseMeetingApiService caseMeetingApiService;
    @Value(value="${spring.security.jwtSecret}")
    private String jwtSecret;
    @Value(value="${mastiff.inviteWatch.expireTime}")
    private Long expireTime;
    @Resource
    private ServicePersonServiceApi servicePersonServiceApi;
    @Resource
    private LawCasePersonnelService lawCasePersonnelService;
    @Resource
    private JWTUtils jwtUtils;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public String caseMeetingSave(CaseMeetingSaveRequestDTO caseMeetingSaveRequstDTO) {
        String[] userIds;
        for (String joinUserId : userIds = caseMeetingSaveRequstDTO.getJoinUserId().split(",")) {
            Long userId = Long.valueOf(joinUserId);
            this.lawCasePersonnelService.authorityCheckByUserId(caseMeetingSaveRequstDTO.getLawCaseId(), userId, CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_RESPONDENT, this.mastiffMessages.getUserMustApplicantOrRespondentOrAgent());
        }
        String result = null;
        CaseMeetingSaveReqDTO caseMeetingSaveReqDTO = new CaseMeetingSaveReqDTO();
        caseMeetingSaveReqDTO.setCaseMeetingName(caseMeetingSaveRequstDTO.getCaseMeetingName());
        caseMeetingSaveReqDTO.setCreateUser(caseMeetingSaveRequstDTO.getUserName());
        caseMeetingSaveReqDTO.setEndTime(caseMeetingSaveRequstDTO.getEndTime());
        caseMeetingSaveReqDTO.setJoinUserId(caseMeetingSaveRequstDTO.getJoinUserId());
        caseMeetingSaveReqDTO.setLawCaseId(caseMeetingSaveRequstDTO.getLawCaseId());
        caseMeetingSaveReqDTO.setMeetingContent(caseMeetingSaveRequstDTO.getMeetingContent());
        caseMeetingSaveReqDTO.setMeetingHour(caseMeetingSaveRequstDTO.getMeetingHour());
        caseMeetingSaveReqDTO.setMeetingMin(caseMeetingSaveRequstDTO.getMeetingMin());
        caseMeetingSaveReqDTO.setMeetingType(caseMeetingSaveRequstDTO.getMeetingType().toString());
        caseMeetingSaveReqDTO.setOrderAddress(caseMeetingSaveRequstDTO.getOrderAddress());
        caseMeetingSaveReqDTO.setOrderTime(caseMeetingSaveRequstDTO.getOrderTime());
        caseMeetingSaveReqDTO.setUserId(caseMeetingSaveRequstDTO.getUserId());
        caseMeetingSaveReqDTO.setOrderType(caseMeetingSaveRequstDTO.getOrderType());
        caseMeetingSaveReqDTO.setUserName(caseMeetingSaveRequstDTO.getUserName());
        DubboResult dubboResult = this.caseMeetingApiService.caseMeetingSave(caseMeetingSaveReqDTO);
        if (!dubboResult.isSuccess()) {
            result = dubboResult.getMessage();
        }
        return result;
    }

    @Override
    public List<CaseMeetingVideoResDTO> getVideo(CaseMeetingIdRequestDTO caseMeetingIdRequestDTO, String cType) {
        CaseMeetingIdReqDTO caseMeetingIdReqDTO = new CaseMeetingIdReqDTO();
        caseMeetingIdReqDTO.setMeetingId(caseMeetingIdRequestDTO.getMeetingId());
        return this.caseMeetingApiService.getVideo(caseMeetingIdReqDTO, cType);
    }

    @Override
    public String inviteSendSMS(CaseMeetingInviteRequestDTO caseMeetingInviteRequestDTO) {
        String result = null;
        CaseMeetingInviteReqDTO caseMeetingInvite = new CaseMeetingInviteReqDTO();
        caseMeetingInvite.setLawCaseId(caseMeetingInviteRequestDTO.getCaseId());
        caseMeetingInvite.setMeetingId(caseMeetingInviteRequestDTO.getMeetingId());
        caseMeetingInvite.setPhone(caseMeetingInviteRequestDTO.getPhone());
        caseMeetingInvite.setUserId(caseMeetingInviteRequestDTO.getUserId());
        DubboResult dubboResult = this.caseMeetingApiService.sendViewSms(caseMeetingInvite);
        if (!dubboResult.isSuccess()) {
            result = dubboResult.getMessage();
        }
        return result;
    }

    @Override
    public String saveUpFile(LawAttachmentUpFileRequestDTO lawAttachmentUpFileRequestDTO) {
        String result = null;
        LawAttachmentUpFileReqDTO lawAttachmentUpFileReqDTO = new LawAttachmentUpFileReqDTO();
        lawAttachmentUpFileReqDTO.setCaseId(lawAttachmentUpFileReqDTO.getCaseId());
        lawAttachmentUpFileReqDTO.setCategoryBig(lawAttachmentUpFileReqDTO.getCategoryBig());
        lawAttachmentUpFileReqDTO.setFileId(lawAttachmentUpFileReqDTO.getFileId());
        lawAttachmentUpFileReqDTO.setFileName(lawAttachmentUpFileReqDTO.getFileName());
        lawAttachmentUpFileReqDTO.setFileType(lawAttachmentUpFileReqDTO.getFileType());
        lawAttachmentUpFileReqDTO.setMeetingId(lawAttachmentUpFileReqDTO.getMeetingId());
        lawAttachmentUpFileReqDTO.setSign(lawAttachmentUpFileReqDTO.getSign());
        lawAttachmentUpFileReqDTO.setUesrId(lawAttachmentUpFileReqDTO.getUesrId());
        lawAttachmentUpFileReqDTO.setUserName(lawAttachmentUpFileReqDTO.getUserName());
        DubboResult dubboResult = this.caseMeetingApiService.saveUpFile(lawAttachmentUpFileReqDTO);
        if (!dubboResult.isSuccess()) {
            result = dubboResult.getMessage();
        }
        return result;
    }

    @Override
    public List<CaseMeetingListResDTO> queryCaseMeetingList(CaseIdRequestDTO caseIdRequestDTO) {
        return this.caseMeetingApiService.queryCaseMeetingList(caseIdRequestDTO.getCaseId());
    }

    @Override
    public String updateStart(CaseMeetingIdRequestDTO caseMeetingIdRequestDTO) {
        String result = null;
        DubboResult dubboResult = this.caseMeetingApiService.updateStart(caseMeetingIdRequestDTO);
        if (!dubboResult.isSuccess()) {
            result = dubboResult.getMessage();
        }
        return result;
    }

    @Override
    public String updateEnd(UptateEndReqDTO uptateEndReqDTO, String userId, String userName) {
        String result = null;
        UpdateTimeReqDTO updateTimeReqDTO = new UpdateTimeReqDTO();
        updateTimeReqDTO.setId(uptateEndReqDTO.getCaseId());
        updateTimeReqDTO.setMeetingId(uptateEndReqDTO.getMeetingId());
        updateTimeReqDTO.setUserId(Long.valueOf(userId));
        updateTimeReqDTO.setUserName(userName);
        DubboResult dubboResult = this.caseMeetingApiService.updateEnd(updateTimeReqDTO);
        if (!dubboResult.isSuccess()) {
            result = dubboResult.getMessage();
        }
        return result;
    }

    @Override
    public InviteWatchResponseDTO inviteWatch(InviteCodeRequestDTO inviteCodeRequestDTO) {
        InviteWatchResponseDTO inviteWatchResponseDTO = new InviteWatchResponseDTO();
        DubboResult<InviteWatchResDTO> dubboResult = this.caseMeetingApiService.inviteWatch(inviteCodeRequestDTO.getInviteCode(), inviteCodeRequestDTO.getUserId(), inviteCodeRequestDTO.getUserName());
        if (dubboResult.isSuccess()) {
            Date expireTimeDate = Java8DateUtil.getDate((LocalDateTime)LocalDateTime.now().plusMinutes(this.expireTime));
            String roomId = ((InviteWatchResDTO)dubboResult.getData()).getRoomId();
            String uuId = UUIDUtils.uuidWithoutSeparator();
            ArrayList<String> roleCodes = new ArrayList<String>();
            roleCodes.add(InviteWachEnum.ROOM_WATCHER.toString());
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("roomId", roomId);
            inviteWatchResponseDTO = this.getToken(uuId, ((InviteWatchResDTO)dubboResult.getData()).getCaseId(), ((InviteWatchResDTO)dubboResult.getData()).getMeetingId(), roomId, roleCodes, attributes, "", expireTimeDate, this.expireTime, TimeUnit.MINUTES, JWTTokenTypeEnums.INVITATION_TOKEN);
        }
        return inviteWatchResponseDTO;
    }

    @Override
    public CaseMeetingPersonnelResDTO queryMeetingMessage(Long userId) {
        return this.caseMeetingApiService.queryMeetingMessage(userId);
    }

    @Override
    public InviteWatchResponseDTO getToken(String userId, Long caseId, Long meetingId, String roomId, List<String> roleCodes, Map<String, Object> attributes, String personType, Date expireTimeDate, Long timeout, TimeUnit timeUnit, JWTTokenTypeEnums jwtTokenTypeEnums) {
        InviteWatchResponseDTO inviteWatchResponseDTO = new InviteWatchResponseDTO();
        String token = this.jwtUtils.generateJWTToken(expireTimeDate, userId, InviteWachEnum.WATCHER_NAME.getName(), personType, roleCodes, attributes, this.jwtSecret, timeout, timeUnit, jwtTokenTypeEnums);
        inviteWatchResponseDTO.setCaseId(caseId);
        inviteWatchResponseDTO.setMeetingId(meetingId);
        inviteWatchResponseDTO.setRoomId(roomId);
        inviteWatchResponseDTO.setToken(token);
        return inviteWatchResponseDTO;
    }

    @Override
    public String queryMeetingUrl(GetCodeQrRequestDTO getCodeQrRequestDTO, String userId, String userName) {
        String meetingUrl = "";
        DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> result = this.caseMeetingApiService.queryMeetingUrl(getCodeQrRequestDTO, userId);
        if (result.isSuccess() && ((ArrayList)result.getData()).size() > 0) {
            meetingUrl = ((CaseMeetingPersonnelResDTO)((ArrayList)result.getData()).get(0)).getCaseMeetingUrlResDTO().getMeetingUrl();
            SearchServicePersonReqDTO searchServicePersonReqDTO = new SearchServicePersonReqDTO();
            searchServicePersonReqDTO.setSearchUserId(Long.valueOf(userId));
            DubboResult searchServicePerson = this.servicePersonServiceApi.searchServicePerson(searchServicePersonReqDTO);
            AssertUtils.assertTrue((boolean)searchServicePerson.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getUserInfoFail());
            List userRoleInfoDTO = ((SearchServicePersonResDTO)searchServicePerson.getData()).getUserRoleRelationList();
            AssertUtils.assertTrue((userRoleInfoDTO.size() > 0 ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getRoleInfoFail());
            ArrayList<String> roleCodes = new ArrayList<String>();
            for (UserRoleInfoDTO string : userRoleInfoDTO) {
                roleCodes.add(string.getRoleType());
            }
            HashMap attributes = new HashMap();
            Long intervalTime = (((CaseMeetingPersonnelResDTO)((ArrayList)result.getData()).get(0)).getEndTime().getTime() - ((CaseMeetingPersonnelResDTO)((ArrayList)result.getData()).get(0)).getOrderTime().getTime()) / 1000L;
            Date expireTimeDate = Java8DateUtil.getDate((LocalDateTime)Java8DateUtil.getLocalDateTime((Date)new Date()).plusSeconds(intervalTime));
            String token = this.jwtUtils.generateJWTToken(expireTimeDate, userId, userName, ((SearchServicePersonResDTO)searchServicePerson.getData()).getPersonType(), roleCodes, attributes, this.jwtSecret, intervalTime, TimeUnit.SECONDS, JWTTokenTypeEnums.INVITATION_TOKEN);
            meetingUrl.concat("&token=" + token);
        }
        return meetingUrl;
    }

    @Override
    public InviteWatchResponseDTO queryToken(GetTokenRequestDTO getTokenRequestDTO) {
        SearchServicePersonReqDTO searchServicePersonReqDTO = new SearchServicePersonReqDTO();
        searchServicePersonReqDTO.setSearchUserId(Long.valueOf(getTokenRequestDTO.getUserId()));
        DubboResult searchServicePerson = this.servicePersonServiceApi.searchServicePerson(searchServicePersonReqDTO);
        AssertUtils.assertTrue((boolean)searchServicePerson.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getUserInfoFail());
        List userRoleInfoDTO = ((SearchServicePersonResDTO)searchServicePerson.getData()).getUserRoleRelationList();
        AssertUtils.assertTrue((userRoleInfoDTO.size() > 0 ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getRoleInfoFail());
        ArrayList<String> roleCodes = new ArrayList<String>();
        for (UserRoleInfoDTO string : userRoleInfoDTO) {
            roleCodes.add(string.getRoleType());
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        GetCodeQrRequestDTO getCodeQrRequestDTO = new GetCodeQrRequestDTO();
        getCodeQrRequestDTO.setMeetingId(getTokenRequestDTO.getMeetingId());
        DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> result = this.caseMeetingApiService.queryMeetingUrl(getCodeQrRequestDTO, getTokenRequestDTO.getUserId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getMettingUserInfoFail());
        CaseMeetingPersonnelResDTO caseMeetingPersonnelResDTO = null;
        if (result.isSuccess()) {
            caseMeetingPersonnelResDTO = (CaseMeetingPersonnelResDTO)((ArrayList)result.getData()).get(0);
        }
        AssertUtils.assertNotNull(caseMeetingPersonnelResDTO, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getMettingInfoFail());
        Long intervalTime = (caseMeetingPersonnelResDTO.getEndTime().getTime() - caseMeetingPersonnelResDTO.getOrderTime().getTime()) / 1000L;
        Date expireTimeDate = Java8DateUtil.getDate((LocalDateTime)Java8DateUtil.getLocalDateTime((Date)new Date()).plusSeconds(intervalTime));
        InviteWatchResponseDTO inviteWatchResponseDTO = this.getToken(getTokenRequestDTO.getUserId(), caseMeetingPersonnelResDTO.getCaseId(), getTokenRequestDTO.getMeetingId(), caseMeetingPersonnelResDTO.getRoomId(), roleCodes, attributes, ((SearchServicePersonResDTO)searchServicePerson.getData()).getPersonType(), expireTimeDate, intervalTime, TimeUnit.SECONDS, JWTTokenTypeEnums.BASIC_SERVICE_USAGE_TOKEN);
        return inviteWatchResponseDTO;
    }

    @Override
    public String saveNewCaseMeeting(MeetingNewSaveRequestDTO meetingNewSaveRequestDTO) {
        String[] userIds;
        for (String joinUserId : userIds = meetingNewSaveRequestDTO.getJoinUserId().split(",")) {
            Long userId = Long.valueOf(joinUserId);
            this.lawCasePersonnelService.authorityCheckByUserId(meetingNewSaveRequestDTO.getLawCaseId(), userId, CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_RESPONDENT, this.mastiffMessages.getUserMustApplicantOrRespondentOrAgent());
        }
        String result = null;
        CaseMeetingSaveReqDTO caseMeetingSaveReqDTO = new CaseMeetingSaveReqDTO();
        caseMeetingSaveReqDTO.setCaseMeetingName("");
        caseMeetingSaveReqDTO.setCreateUser(meetingNewSaveRequestDTO.getUserName());
        caseMeetingSaveReqDTO.setEndTime(null);
        caseMeetingSaveReqDTO.setJoinUserId(meetingNewSaveRequestDTO.getJoinUserId());
        caseMeetingSaveReqDTO.setLawCaseId(meetingNewSaveRequestDTO.getLawCaseId());
        caseMeetingSaveReqDTO.setMeetingContent(null);
        caseMeetingSaveReqDTO.setMeetingHour(0);
        caseMeetingSaveReqDTO.setMeetingMin(0);
        caseMeetingSaveReqDTO.setOrderAddress(meetingNewSaveRequestDTO.getOrderAddress());
        caseMeetingSaveReqDTO.setOrderTime(meetingNewSaveRequestDTO.getOrderTime());
        caseMeetingSaveReqDTO.setUserId(meetingNewSaveRequestDTO.getUserId());
        caseMeetingSaveReqDTO.setUserName(meetingNewSaveRequestDTO.getUserName());
        if (meetingNewSaveRequestDTO.getMeetingTypeNewEnum().equals((Object)MeetingTypeNewEnum.MEETING_MEDIATE)) {
            caseMeetingSaveReqDTO.setMeetingType(meetingNewSaveRequestDTO.getMeetingTypeNewEnum().toString());
            caseMeetingSaveReqDTO.setOrderType(MeetingOrderEnum.MEETING_ONLINE_MEDIATE);
        } else if (meetingNewSaveRequestDTO.getMeetingTypeNewEnum().equals((Object)MeetingTypeNewEnum.MEETING_SURVEY)) {
            caseMeetingSaveReqDTO.setMeetingType(meetingNewSaveRequestDTO.getMeetingTypeNewEnum().toString());
            caseMeetingSaveReqDTO.setOrderType(MeetingOrderEnum.MEETING_ONLINE_MEDIATE);
        } else if (meetingNewSaveRequestDTO.getMeetingTypeNewEnum().equals((Object)MeetingTypeNewEnum.MEETING_OFFLINE_SURVEY)) {
            caseMeetingSaveReqDTO.setMeetingType(MeetingTypeNewEnum.MEETING_SURVEY.toString());
            caseMeetingSaveReqDTO.setOrderType(MeetingOrderEnum.MEETING_OFFLINE_MEDIATE);
        } else if (meetingNewSaveRequestDTO.getMeetingTypeNewEnum().equals((Object)MeetingTypeNewEnum.MEETING_OFFLINE_MEDIATE)) {
            caseMeetingSaveReqDTO.setMeetingType(MeetingTypeNewEnum.MEETING_MEDIATE.toString());
            caseMeetingSaveReqDTO.setOrderType(MeetingOrderEnum.MEETING_OFFLINE_MEDIATE);
        } else if (meetingNewSaveRequestDTO.getMeetingTypeNewEnum().equals((Object)MeetingTypeNewEnum.MEETING_VIDEO_AUTHENTICATION)) {
            caseMeetingSaveReqDTO.setMeetingType(MeetingTypeNewEnum.MEETING_VIDEO_AUTHENTICATION.toString());
            caseMeetingSaveReqDTO.setOrderType(MeetingOrderEnum.MEETING_ONLINE_MEDIATE);
        }
        DubboResult dubboResult = this.caseMeetingApiService.caseMeetingSave(caseMeetingSaveReqDTO);
        if (!dubboResult.isSuccess()) {
            result = dubboResult.getMessage();
        }
        return result;
    }

    @Override
    public PageInfo<BookedCaseMeetingListResponseDTO> bookedCaseMeetingList(String userId, PageQuery pageQuery) {
        DubboResult<PageInfo<BookedCaseMeetingListResponseDTO>> dubboResult = this.caseMeetingApiService.bookedCaseMeetingList(userId, pageQuery);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)this.mastiffMessages.getBookedMeetingFail());
        return (PageInfo)dubboResult.getData();
    }
}

