/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.basic.storage.api.FileStorageApi;
import com.beiming.basic.storage.api.dto.request.FileInfoRequestDTO;
import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.PlatformEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.consultancy.api.DisputesApi;
import com.beiming.odr.consultancy.dto.requestdto.DisputeLawCaseReqDTO;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.CasePersonAuthorityEnum;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.enums.FileTypeEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuditCaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.BatchFilesRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DeleteCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.EditCaseDisputeRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.FilesRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.PetitionAgentRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveCaseUserListRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.UserAttachmentListRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.SaveCaseUserResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.CaseDubboService;
import com.beiming.odr.mastiff.service.backend.referee.CaseMeetingApiService;
import com.beiming.odr.mastiff.service.backend.referee.LawCasePersonnelService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationCaseConvert;
import com.beiming.odr.mastiff.service.backend.user.BackstageOrganizationService;
import com.beiming.odr.mastiff.service.backend.user.ServicePersonDubboService;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.CaseService;
import com.beiming.odr.mastiff.service.client.FileService;
import com.beiming.odr.mastiff.service.client.LawCaseDossierService;
import com.beiming.odr.mastiff.service.utils.RedisSequenceFactory;
import com.beiming.odr.referee.dto.MediationCaseBaseDTO;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.requestdto.DeleteCasePersonnelReqDTO;
import com.beiming.odr.referee.dto.requestdto.EditCaseDisputeReqDTO;
import com.beiming.odr.referee.dto.requestdto.FailCancelCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationCaseUserReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseResDTO;
import com.beiming.odr.referee.dto.responsedto.LawAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseCancelApplyAuditDTO;
import com.beiming.odr.referee.dto.responsedto.SaveCaseUserResDTO;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.DisputeStatusEnum;
import com.beiming.odr.referee.enums.RegisterOriginEnum;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaseServiceImpl
implements CaseService {
    private static final Logger log = Logger.getLogger(CaseServiceImpl.class);
    @Resource
    private CaseDubboService caseDubboService;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private ServicePersonDubboService servicePersonDubboService;
    @Resource
    private BackstageOrganizationService backstageOrganizationService;
    @Resource
    private LawCasePersonnelService lawCasePersonnelService;
    @Resource
    private DisputesApi disputesApi;
    @Resource
    private RedisSequenceFactory redisSequenceFactory;
    @Resource
    private MastiffMessages mastiffMessages;
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private FileService fileService;
    @Resource
    private FileStorageApi storageApi;
    @Resource
    private LawCaseDossierService lawCaseDossierService;
    @Resource
    private CaseMeetingApiService caseMeetingApiService;
    @Value(value="${thirdparty.hngs.orgAreaCode}")
    private String orgAreaCode;
    @Value(value="${thirdparty.hngs.orgId}")
    private String orgId;
    @Value(value="${thirdparty.hngs.orgName}")
    private String orgName;
    private final String icoImageFlagPre = "ico.";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MediationCaseResponseDTO saveCase(MediationCaseRequestDTO dto) {
        MediationCaseResponseDTO response = new MediationCaseResponseDTO();
        this.checkRepeat(dto.getApplyUserList(), dto.getRespondentUserList());
        this.insertUserNotExist(dto.getApplyUserList());
        String userId = JWTContextUtil.getCurrentUserId();
        List list = JWTContextUtil.getRoles();
        if (!list.contains(UserRoleEnum.DISPUTE_REGISTRAR.name())) {
            this.checkLoginUserInCaseUser(userId, dto);
        }
        this.insertUserNotExist(dto.getRespondentUserList());
        MediationCaseReqDTO reqDTO = MediationCaseConvert.getMediationCaseReqConvert(dto);
        if (dto.getMediatorId() != null) {
            SearchServicePersonResDTO mediatorInfo = this.servicePersonDubboService.getMediatorInfo(null, dto.getMediatorId());
            AssertUtils.assertNotNull((Object)mediatorInfo, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
            MediationCaseUserReqDTO mediator = new MediationCaseUserReqDTO();
            mediator.setUserId(mediatorInfo.getUserId());
            mediator.setName(mediatorInfo.getUserName());
            mediator.setPhone(mediatorInfo.getMobilePhone());
            mediator.setCaseUserType(CaseUserTypeEnum.MEDIATOR.name());
            reqDTO.getPersonnelList().add(mediator);
            reqDTO.setMediatorName(mediatorInfo.getUserName());
        }
        Long creatorId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        reqDTO.setCreatorId(creatorId);
        String currentUserName = this.userDubboService.getUserNameByJWT();
        reqDTO.setCreateUser(currentUserName);
        reqDTO.setUpdateUser(currentUserName);
        reqDTO.setSmsOff(Boolean.valueOf(null == dto.getSmsOff() ? false : dto.getSmsOff()));
        List roles = JWTContextUtil.getRoles();
        if (((String)roles.get(0)).equals(UserRoleEnum.COMMON.name())) {
            reqDTO.setCreatorType(UserRoleEnum.COMMON);
        } else {
            reqDTO.setCreatorType(UserRoleEnum.DISPUTE_REGISTRAR);
        }
        reqDTO.setOrigin(PlatformEnums.MASTIFF_API.name());
        String caseNo = this.getCaseNo();
        reqDTO.setCaseNo(caseNo);
        if (list.contains(UserRoleEnum.DISPUTE_REGISTRAR.name()) && DisputeStatusEnum.SAVE_CASE.getCode() == dto.getDisputeStatus()) {
            reqDTO.setLawCaseStatus(CaseStatusEnum.UNSUBMIT.name());
            reqDTO.setCaseProgress(CaseProgressEnum.UNSUBMIT.name());
        } else {
            reqDTO.setLawCaseStatus(CaseStatusEnum.APPLY_SUBMIT.name());
            reqDTO.setCaseProgress(CaseProgressEnum.APPLY.name());
        }
        reqDTO.setDisputeStatus(dto.getDisputeStatus());
        Long caseId = this.caseDubboService.insertMediationCase(reqDTO);
        AssertUtils.assertNotNull((Object)caseId, (ResultCode)ErrorCode.SUBMIT_CASE_FAIL, (String)this.mastiffMessages.getSubmitCaseFail());
        response.setCaseId(caseId);
        if (Objects.nonNull(reqDTO.getDisputesId())) {
            this.disputesApi.updateDisputesLawCaseId(new DisputeLawCaseReqDTO(reqDTO.getDisputesId(), caseId, creatorId));
        }
        if (MediationTypeEnum.ADMINISTRATION_MEDIATION.equals((Object)dto.getMediationType())) {
            BackstageOrganizationResDTO result = this.backstageOrganizationService.searchBackstageOrganization(dto.getOrgId());
            AssertUtils.assertNotNull((Object)result, (ResultCode)ErrorCode.MEDIATION_ORG_INQUIRY_FAIL, (String)this.mastiffMessages.getMediationOrgInquiryFail());
            response.setOrgId(result.getOrgId());
            response.setOrgName(result.getName());
            response.setOrgIntroduction(result.getIntroduction());
        }
        return response;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MediationCaseResponseDTO saveGsCase(MediationCaseRequestDTO dto) {
        MediationCaseResponseDTO response = new MediationCaseResponseDTO();
        this.checkRepeat(dto.getApplyUserList(), dto.getRespondentUserList());
        this.insertUserNotExist(dto.getApplyUserList());
        this.insertUserNotExist(dto.getRespondentUserList());
        dto.setCaseOrigin("\u6d77\u5357\u56fd\u5546");
        MediationCaseReqDTO reqDTO = MediationCaseConvert.getMediationCaseReqConvert(dto);
        Long creatorId = 0L;
        reqDTO.setCreatorId(creatorId);
        reqDTO.setCreateUser("\u6d77\u5357\u56fd\u5546\u5e73\u53f0");
        reqDTO.setUpdateUser("\u6d77\u5357\u56fd\u5546\u5e73\u53f0");
        reqDTO.setSmsOff(Boolean.valueOf(null == dto.getSmsOff() ? false : dto.getSmsOff()));
        reqDTO.setCreatorType(UserRoleEnum.DISPUTE_REGISTRAR);
        reqDTO.setOrigin(PlatformEnums.MASTIFF_API.name());
        String caseNo = this.getCaseNo();
        reqDTO.setCaseNo(caseNo);
        reqDTO.setLawCaseStatus(CaseStatusEnum.APPLY_SUBMIT.name());
        reqDTO.setCaseProgress(CaseProgressEnum.APPLY.name());
        reqDTO.setDisputeStatus(Integer.valueOf(1));
        reqDTO.setOrgAreaCode(this.orgAreaCode);
        reqDTO.setOrgId(Long.valueOf(Long.parseLong(this.orgId)));
        reqDTO.setOrgName(this.orgName);
        Long caseId = this.caseDubboService.insertMediationCase(reqDTO);
        for (BatchFilesRequestDTO uploadMaterial : dto.getUploadMaterials()) {
            uploadMaterial.setCaseId(caseId);
            uploadMaterial.setUserName("\u6d77\u5357\u56fd\u5546\u5e73\u53f0");
            uploadMaterial.setFileType(FileTypeEnum.MEDIATE_FILE.name());
            for (FilesRequestDTO file : uploadMaterial.getFiles()) {
                String fileBase64 = file.getFileBase64();
                String filename = file.getFileName();
                byte[] byteData = Base64.getDecoder().decode(fileBase64);
                FileInfoRequestDTO requestDto = new FileInfoRequestDTO(filename, byteData);
                DubboResult dubboResult = this.storageApi.save(requestDto);
                String fileId = ((SaveFileResponseDTO)dubboResult.getData()).getFileId();
                String previewUrl = "/basicGateway/file/previewImg/ico." + fileId;
                boolean isImage = ((SaveFileResponseDTO)dubboResult.getData()).isImage();
                boolean flag = isImage;
                file.setFileId(fileId);
                file.setPreviewUrl(flag ? previewUrl : null);
            }
            uploadMaterial.setUserId(Long.valueOf(0L));
            this.fileService.batchFilesUpload(uploadMaterial);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getApplyUserList())) {
            for (SaveCaseUserRequestDTO applyUser : dto.getApplyUserList()) {
                this.uploadAgentFile(applyUser);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getRespondentUserList())) {
            for (SaveCaseUserRequestDTO respondUser : dto.getRespondentUserList()) {
                this.uploadAgentFile(respondUser);
            }
        }
        AssertUtils.assertNotNull((Object)caseId, (ResultCode)ErrorCode.SUBMIT_CASE_FAIL, (String)this.mastiffMessages.getSubmitCaseFail());
        response.setCaseId(caseId);
        response.setCaseNo(caseNo);
        return response;
    }

    private void uploadAgentFile(SaveCaseUserRequestDTO applyUser) {
        if (!StringUtils.isEmpty((String)applyUser.getAgentFileName()) && !StringUtils.isEmpty((String)applyUser.getAgentBase64File())) {
            String fileBase64 = applyUser.getAgentBase64File();
            String filename = applyUser.getAgentFileName();
            byte[] byteData = Base64.getDecoder().decode(fileBase64);
            FileInfoRequestDTO requestDto = new FileInfoRequestDTO(filename, byteData);
            DubboResult dubboResult = this.storageApi.save(requestDto);
            String fileId = ((SaveFileResponseDTO)dubboResult.getData()).getFileId();
            applyUser.setAgentFileId(fileId);
        }
    }

    @Override
    public MediationCaseResponseDTO saveYtCase(MediationCaseRequestDTO dto) {
        MediationCaseResponseDTO response = new MediationCaseResponseDTO();
        this.checkRepeat(dto.getApplyUserList(), dto.getRespondentUserList());
        this.insertUserNotExist(dto.getApplyUserList());
        this.insertUserNotExist(dto.getRespondentUserList());
        MediationCaseReqDTO reqDTO = MediationCaseConvert.getMediationCaseReqConvert(dto);
        Long creatorId = 0L;
        reqDTO.setCreatorId(creatorId);
        reqDTO.setCreateUser("\u6d77\u5357\u6848\u7ba1\u4e2d\u5fc3");
        reqDTO.setUpdateUser("\u6d77\u5357\u6848\u7ba1\u4e2d\u5fc3");
        reqDTO.setSmsOff(Boolean.valueOf(null == dto.getSmsOff() ? false : dto.getSmsOff()));
        reqDTO.setCreatorType(UserRoleEnum.COMMON);
        reqDTO.setOrigin(PlatformEnums.MASTIFF_API.name());
        String caseNo = this.getCaseNo();
        reqDTO.setCaseNo(caseNo);
        reqDTO.setLawCaseStatus(CaseStatusEnum.APPLY_SUBMIT.name());
        reqDTO.setCaseProgress(CaseProgressEnum.APPLY.name());
        reqDTO.setDisputeStatus(dto.getDisputeStatus());
        reqDTO.setOrgConfirm(Boolean.valueOf(false));
        Long caseId = this.caseDubboService.insertMediationCase(reqDTO);
        AssertUtils.assertNotNull((Object)caseId, (ResultCode)ErrorCode.SUBMIT_CASE_FAIL, (String)this.mastiffMessages.getSubmitCaseFail());
        response.setCaseId(caseId);
        return response;
    }

    private void checkRepeat(List<SaveCaseUserRequestDTO> applicants, List<SaveCaseUserRequestDTO> respondents) {
        ArrayList appPhoneList = Lists.newArrayList();
        ArrayList appIdCardList = Lists.newArrayList();
        for (int i = 0; i < applicants.size(); ++i) {
            String appAgentIdCard;
            String appAgentPhone;
            String appIdCard;
            SaveCaseUserRequestDTO app = applicants.get(i);
            String appPhone = app.getPhone();
            if (StringUtils.isNotBlank((CharSequence)appPhone)) {
                AssertUtils.assertFalse((boolean)appPhoneList.contains(appPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u624b\u673a\u53f7\u4e0e\u5176\u4ed6\u7533\u8bf7\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                appPhoneList.add(app.getPhone());
            }
            if (StringUtils.isNotBlank((CharSequence)(appIdCard = app.getIdCard()))) {
                AssertUtils.assertFalse((boolean)appIdCardList.contains(appIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u8eab\u4efd\u8bc1\u53f7\u4e0e\u5176\u4ed6\u7533\u8bf7\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                appIdCardList.add(appIdCard);
            }
            if (StringUtils.isNotBlank((CharSequence)(appAgentPhone = app.getAgentPhone())) && StringUtils.isNotBlank((CharSequence)appPhone)) {
                AssertUtils.assertFalse((boolean)appPhone.equals(appAgentPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4ee3\u7406\u4eba\u4e0e\u5176\u7533\u8bf7\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
            }
            if (StringUtils.isNotBlank((CharSequence)(appAgentIdCard = app.getAgentIdCard()))) {
                AssertUtils.assertFalse((boolean)appAgentIdCard.equals(appIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4ee3\u7406\u4eba\u4e0e\u5176\u7533\u8bf7\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
            }
            ArrayList resPhoneList = Lists.newArrayList();
            ArrayList resIdCardList = Lists.newArrayList();
            for (int j = 0; j < respondents.size(); ++j) {
                String resAgentIdCard;
                String resAgentPhone;
                String resIdCard;
                boolean b;
                SaveCaseUserRequestDTO res = respondents.get(j);
                String resPhone = res.getPhone();
                boolean bl = b = null != app.getId() && null != res.getId();
                if (b && app.getId().equals(res.getId())) continue;
                if (StringUtils.isNotBlank((CharSequence)resPhone)) {
                    AssertUtils.assertFalse((boolean)resPhoneList.contains(resPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u624b\u673a\u53f7\u4e0e\u5176\u4ed6\u88ab\u7533\u8bf7\u4eba\u624b\u673a\u91cd\u590d"));
                    resPhoneList.add(resPhone);
                }
                if (StringUtils.isNotBlank((CharSequence)(resIdCard = res.getIdCard()))) {
                    AssertUtils.assertFalse((boolean)resIdCardList.contains(resIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u8eab\u4efd\u8bc1\u53f7\u4e0e\u5176\u4ed6\u88ab\u7533\u8bf7\u4eba\u8eab\u4efd\u91cd\u590d"));
                    resIdCardList.add(resIdCard);
                }
                if (StringUtils.isNotBlank((CharSequence)(resAgentPhone = res.getAgentPhone()))) {
                    AssertUtils.assertFalse((boolean)resAgentPhone.equals(resPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u4ee3\u7406\u4eba\u4e0e\u5176\u7533\u8bf7\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                    AssertUtils.assertFalse((StringUtils.isNotBlank((CharSequence)appPhone) && resAgentPhone.equals(appPhone) ? 1 : 0) != 0, (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u4ee3\u7406\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                }
                if (StringUtils.isNotBlank((CharSequence)(resAgentIdCard = res.getAgentIdCard()))) {
                    AssertUtils.assertFalse((boolean)resAgentIdCard.equals(resIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u4ee3\u7406\u4eba\u4e0e\u5176\u7533\u8bf7\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                    AssertUtils.assertFalse((boolean)resAgentIdCard.equals(appIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u4ee3\u7406\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                }
                if (b && !app.getId().equals(res.getId())) {
                    AssertUtils.assertFalse((StringUtils.isNotBlank((CharSequence)appPhone) && appPhone.equals(resPhone) ? 1 : 0) != 0, (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                }
                if (StringUtils.isNotBlank((CharSequence)appIdCard) && StringUtils.isNotBlank((CharSequence)resIdCard)) {
                    AssertUtils.assertFalse((boolean)appIdCard.equals(resIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                }
                if (StringUtils.isNotBlank((CharSequence)appAgentPhone)) {
                    AssertUtils.assertFalse((boolean)appAgentPhone.equals(resPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4ee3\u7406\u4eba\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                    AssertUtils.assertFalse((boolean)appAgentPhone.equals(resAgentPhone), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4ee3\u7406\u4eba\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u4ee3\u7406\u4eba\u624b\u673a\u4fe1\u606f\u91cd\u590d"));
                }
                if (!StringUtils.isNotBlank((CharSequence)appAgentIdCard)) continue;
                AssertUtils.assertFalse((boolean)appAgentIdCard.equals(resIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4ee3\u7406\u4eba\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
                AssertUtils.assertFalse((boolean)appAgentIdCard.equals(resAgentIdCard), (ResultCode)ErrorCode.CASE_USER_REPEAT_CHECK, (String)("\u7533\u8bf7\u4eba" + (i + 1) + "\u4ee3\u7406\u4eba\u4e0e\u88ab\u7533\u8bf7\u4eba" + (j + 1) + "\u4ee3\u7406\u4eba\u8eab\u4efd\u4fe1\u606f\u91cd\u590d"));
            }
        }
    }

    @Override
    public void editCaseDisputeInfo(EditCaseDisputeRequestDTO dto) {
        this.lawCasePersonnelService.authorityCheck(dto.getCaseId(), CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_AGENT, this.mastiffMessages.getUserMustApplicantOrAgent());
        DubboResult valueByCode = this.dictionaryServiceApi.getValueByCode(dto.getDisputeTypeCode());
        dto.setDisputeType((String)((Object)valueByCode.getData()));
        EditCaseDisputeReqDTO reqDTO = MediationCaseConvert.getEditCaseDisputeReqDTO(dto);
        reqDTO.setUpdateUser(this.userDubboService.getUserNameByJWT());
        this.caseDubboService.editCaseDisputeInfo(reqDTO);
    }

    private void caseUserRegister(SaveCaseUserRequestDTO dto) {
        if (StringUtils.isEmpty((String)dto.getPhone()) && StringUtils.isEmpty((String)dto.getEmail())) {
            return;
        }
        String prefixMsg = "";
        String userName = "";
        switch (dto.getUserType()) {
            case NATURAL_PERSON: {
                prefixMsg = dto.getCaseUserType().getName();
                userName = dto.getUserName();
                break;
            }
            case JURIDICAL_PERSON: {
                prefixMsg = dto.getCaseUserType().getName() + "\u6cd5\u5b9a\u4ee3\u8868\u4eba";
                userName = dto.getCorporation();
                break;
            }
            case UNINCORPORATED_ORGANIZATION: {
                prefixMsg = dto.getCaseUserType().getName() + "\u673a\u6784\u4ee3\u8868\u4eba";
                userName = dto.getCorporation();
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPhone())) {
            this.caseCreateUser(dto, prefixMsg);
        } else if (StringUtils.isNotBlank((CharSequence)dto.getEmail())) {
            this.caseCreateUser(dto, prefixMsg);
        } else if (StringUtils.isNotBlank((CharSequence)dto.getIdCard())) {
            boolean realNameFlag = this.userDubboService.checkRealNameAuthentication(userName, dto.getIdCard());
            AssertUtils.assertTrue((boolean)realNameFlag, (ResultCode)ErrorCode.REAL_NAME_CHECK_FAIL, (String)(prefixMsg + "\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u4e0d\u5339\u914d"));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAgentPhone())) {
            this.caseAgentCreateUser(dto, prefixMsg);
        } else if (StringUtils.isNotBlank((CharSequence)dto.getAgentEmail())) {
            this.caseAgentCreateUser(dto, prefixMsg);
        } else {
            dto.setAgentId(null);
            dto.setAgentRegisterOrigin(null);
            dto.setAgentSex(null);
        }
    }

    private void caseAgentCreateUser(SaveCaseUserRequestDTO dto, String prefixMsg) {
        CaseUserRegisterReqDTO agent = new CaseUserRegisterReqDTO();
        agent.setUserName(dto.getAgentName());
        agent.setMobilePhone(dto.getAgentPhone());
        agent.setIdCard(dto.getAgentIdCard());
        agent.setPassword("Aa@123456");
        agent.setCardType(dto.getAgentCardType());
        agent.setNation(dto.getAgentNation());
        agent.setNationality(dto.getAgentNationality());
        agent.setEmail(dto.getAgentEmail());
        DubboResult<CaseUserRegisterResDTO> dubboResultAgent = this.userDubboService.caseUserRegister(agent);
        CaseUserRegisterResDTO agentReqDTO = (CaseUserRegisterResDTO)dubboResultAgent.getData();
        AssertUtils.assertTrue((boolean)dubboResultAgent.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)(prefixMsg + "\u4ee3\u7406\u4eba" + dto.getAgentName() + dubboResultAgent.getMessage()));
        dto.setAgentId(agentReqDTO.getUserId());
        if (agentReqDTO.getIsAutoRegist().booleanValue()) {
            dto.setAgentRegisterOrigin(RegisterOriginEnum.REGISTER_PLATFORM);
        } else {
            dto.setAgentRegisterOrigin(RegisterOriginEnum.REGISTER_SELF);
        }
    }

    private void caseCreateUser(SaveCaseUserRequestDTO dto, String prefixMsg) {
        CaseUserRegisterReqDTO user = MediationCaseConvert.getCaseUserRegisterReqDTO(dto);
        DubboResult<CaseUserRegisterResDTO> dubboResult = this.userDubboService.caseUserRegister(user);
        if (!dubboResult.isSuccess() && (dto.getCaseUserType().equals((Object)CaseUserTypeEnum.APPLICANT) || dto.getCaseUserType().equals((Object)CaseUserTypeEnum.RESPONDENT))) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)(prefixMsg + user.getUserName() + dubboResult.getMessage()));
        }
        CaseUserRegisterResDTO data = (CaseUserRegisterResDTO)dubboResult.getData();
        dto.setUserId(data.getUserId());
        if (data.getIsAutoRegist().booleanValue()) {
            dto.setUserRegisterOrigin(RegisterOriginEnum.REGISTER_PLATFORM);
        } else {
            dto.setUserRegisterOrigin(RegisterOriginEnum.REGISTER_SELF);
        }
    }

    private SaveCaseUserResponseDTO saveCaseUser(SaveCaseUserRequestDTO dto) {
        this.caseUserRegister(dto);
        MediationCaseUserReqDTO reqDTO = MediationCaseConvert.getMediationCaseUserReqConvert(dto);
        reqDTO.setCaseUserType(dto.getCaseUserType().name());
        String currentUserName = this.userDubboService.getUserNameByJWT();
        reqDTO.setCreateUser(currentUserName);
        reqDTO.setUpdateUser(currentUserName);
        SaveCaseUserResDTO resDTO = this.caseDubboService.saveOrEditCaseUser(reqDTO);
        SaveCaseUserResponseDTO res = MediationCaseConvert.getSaveCaseUserResponseDTO(resDTO);
        return res;
    }

    private void divideUserList(List<MediationCasePersonnelDTO> personnelList, List<SaveCaseUserRequestDTO> applicantList, List<SaveCaseUserRequestDTO> respondentList) {
        for (MediationCasePersonnelDTO personal : personnelList) {
            SaveCaseUserRequestDTO saveCaseUserRequestDTO = MediationCaseConvert.getSaveCaseUserRequestDTO(personal);
            if (personal.getCaseUserType().equals(CaseUserTypeEnum.APPLICANT.name())) {
                saveCaseUserRequestDTO.setCaseUserType(CaseUserTypeEnum.APPLICANT);
                applicantList.add(saveCaseUserRequestDTO);
            }
            if (!personal.getCaseUserType().equals(CaseUserTypeEnum.RESPONDENT.name())) continue;
            saveCaseUserRequestDTO.setCaseUserType(CaseUserTypeEnum.RESPONDENT);
            respondentList.add(saveCaseUserRequestDTO);
        }
    }

    private void divideUser(SaveCaseUserRequestDTO dto, List<MediationCasePersonnelDTO> personnelList, List<SaveCaseUserRequestDTO> applicantList, List<SaveCaseUserRequestDTO> respondentList) {
        for (MediationCasePersonnelDTO personal : personnelList) {
            if (personal.getId().equals(dto.getId())) {
                if (dto.getCaseUserType().name().equals(CaseUserTypeEnum.APPLICANT.name())) {
                    applicantList.add(dto);
                }
                if (dto.getCaseUserType().name().equals(CaseUserTypeEnum.RESPONDENT.name())) {
                    respondentList.add(dto);
                }
            }
            SaveCaseUserRequestDTO saveCaseUserRequestDTO = MediationCaseConvert.getSaveCaseUserRequestDTO(personal);
            if (personal.getCaseUserType().equals(CaseUserTypeEnum.APPLICANT.name()) && !personal.getId().equals(dto.getId())) {
                saveCaseUserRequestDTO.setCaseUserType(CaseUserTypeEnum.APPLICANT);
                applicantList.add(saveCaseUserRequestDTO);
            }
            if (!personal.getCaseUserType().equals(CaseUserTypeEnum.RESPONDENT.name()) || personal.getId().equals(dto.getId())) continue;
            saveCaseUserRequestDTO.setCaseUserType(CaseUserTypeEnum.RESPONDENT);
            respondentList.add(saveCaseUserRequestDTO);
        }
    }

    @Override
    public SaveCaseUserResponseDTO saveOrEditCaseUser(SaveCaseUserRequestDTO dto) {
        CaseResDTO resDTO = this.caseDubboService.getMediationCaseInfoById(dto.getCaseId());
        List personnelList = resDTO.getPersonnelList();
        ArrayList applicantList = Lists.newArrayList();
        ArrayList respondentList = Lists.newArrayList();
        this.divideUser(dto, personnelList, applicantList, respondentList);
        if (dto.getId() == null) {
            if (dto.getCaseUserType().name().equals(CaseUserTypeEnum.APPLICANT.name())) {
                dto.setOrder(Integer.valueOf(applicantList.size() + 1));
                applicantList.add(dto);
            }
            if (dto.getCaseUserType().name().equals(CaseUserTypeEnum.RESPONDENT.name())) {
                dto.setOrder(Integer.valueOf(respondentList.size() + 1));
                respondentList.add(dto);
            }
        }
        this.checkRepeat(applicantList, respondentList);
        SaveCaseUserResponseDTO responseDTO = this.saveCaseUser(dto);
        AssertUtils.assertNotNull((Object)responseDTO, (ResultCode)ErrorCode.SAVE_CASE_USER_FAIL, (String)this.mastiffMessages.getSaveCaseUserFail());
        return responseDTO;
    }

    @Override
    public void saveCaseUserList(SaveCaseUserListRequestDTO requestDTO) {
        this.lawCasePersonnelService.authorityCheck(requestDTO.getCaseId(), CasePersonAuthorityEnum.USER_MUST_APPLICANT_OR_RESPONDENT_OR_AGENT, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_AGENT, this.mastiffMessages.getUserMustApplicantOrAgent());
        List list = requestDTO.getList();
        SaveCaseUserRequestDTO request = (SaveCaseUserRequestDTO)list.get(0);
        CaseResDTO resDTO = this.caseDubboService.getMediationCaseInfoById(requestDTO.getCaseId());
        List personnelList = resDTO.getPersonnelList();
        ArrayList applicantList = Lists.newArrayList();
        ArrayList respondentList = Lists.newArrayList();
        this.divideUserList(personnelList, applicantList, respondentList);
        if (CaseUserTypeEnum.APPLICANT.name().equals(request.getCaseUserType().name())) {
            this.checkRepeat(list, respondentList);
        } else {
            this.checkRepeat(applicantList, list);
        }
        for (SaveCaseUserRequestDTO dto : list) {
            dto.setCaseId(requestDTO.getCaseId());
            this.saveCaseUser(dto);
        }
    }

    private void insertUserNotExist(List<SaveCaseUserRequestDTO> personnelList) {
        for (SaveCaseUserRequestDTO dto : personnelList) {
            this.caseUserRegister(dto);
        }
    }

    @Override
    public void deleteCasePersonnel(DeleteCaseUserRequestDTO dto) {
        CaseResDTO resDTO = this.caseDubboService.getMediationCaseInfoById(dto.getCaseId());
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        MediationCaseBaseDTO caseInfo = resDTO.getMediationCaseBaseResDTO();
        List personnelList = resDTO.getPersonnelList();
        ArrayList applicantList = Lists.newArrayList();
        ArrayList respondentList = Lists.newArrayList();
        for (MediationCasePersonnelDTO personal : personnelList) {
            if (personal.getCaseUserType().equals(CaseUserTypeEnum.APPLICANT.name())) {
                applicantList.add(personal);
            }
            if (!personal.getCaseUserType().equals(CaseUserTypeEnum.RESPONDENT.name())) continue;
            respondentList.add(personal);
        }
        UserAttachmentListRequestDTO userAttachmentListRequestDTO = new UserAttachmentListRequestDTO();
        userAttachmentListRequestDTO.setPersonId(dto.getPersonnelId());
        userAttachmentListRequestDTO.setCaseId(dto.getCaseId());
        List<LawAttachmentResDTO> attachmentList = this.lawCaseDossierService.getLawAttachmentListByUserIdAndCaseId(userAttachmentListRequestDTO);
        ArrayList<CaseMeetingListResDTO> caseMeetingListResDTOS = this.caseMeetingApiService.queryCaseMeetingList(dto.getCaseId());
        List<Object> collect = new ArrayList();
        if (CollectionUtils.isNotEmpty(caseMeetingListResDTOS)) {
            collect = caseMeetingListResDTOS.stream().filter(meetingDTO -> meetingDTO.getJoinUserId().contains(String.valueOf(dto.getPersonnelId()))).collect(Collectors.toList());
        }
        if (dto.getCaseUserType().equals((Object)CaseUserTypeEnum.APPLICANT)) {
            AssertUtils.assertTrue((applicantList.size() > 1 ? 1 : 0) != 0, (ResultCode)ErrorCode.PERSONNEL_NOT_DELETE, (String)this.mastiffMessages.getApplicantMustOne());
            AssertUtils.assertFalse((boolean)CollectionUtils.isNotEmpty(attachmentList), (ResultCode)ErrorCode.EVIDENCE_NOT_EMPTY, (String)this.mastiffMessages.getEvidenceNotEmpty());
            AssertUtils.assertTrue((CollectionUtils.isEmpty(caseMeetingListResDTOS) || CollectionUtils.isEmpty(collect) ? 1 : 0) != 0, (ResultCode)ErrorCode.EVIDENCE_NOT_EMPTY, (String)this.mastiffMessages.getEvidenceNotEmpty());
            Boolean deleteFlag = applicantList.stream().anyMatch(a -> dto.getPersonnelId().equals(a.getId()) && (caseInfo.getCreatorId().equals(a.getUserId()) || caseInfo.getCreatorId().equals(a.getAgentId())));
            AssertUtils.assertFalse((boolean)deleteFlag, (ResultCode)APIResultCodeEnums.ACCESS_DENIED, (String)this.mastiffMessages.getCreatorNotDeleted());
        }
        if (dto.getCaseUserType().equals((Object)CaseUserTypeEnum.RESPONDENT)) {
            AssertUtils.assertTrue((respondentList.size() > 1 ? 1 : 0) != 0, (ResultCode)ErrorCode.PERSONNEL_NOT_DELETE, (String)this.mastiffMessages.getRespondentMustOne());
            AssertUtils.assertFalse((boolean)CollectionUtils.isNotEmpty(attachmentList), (ResultCode)ErrorCode.EVIDENCE_NOT_EMPTY, (String)this.mastiffMessages.getEvidenceNotEmpty());
            AssertUtils.assertTrue((CollectionUtils.isEmpty(caseMeetingListResDTOS) || CollectionUtils.isEmpty(collect) ? 1 : 0) != 0, (ResultCode)ErrorCode.EVIDENCE_NOT_EMPTY, (String)this.mastiffMessages.getEvidenceNotEmpty());
        }
        DeleteCasePersonnelReqDTO reqDTO = new DeleteCasePersonnelReqDTO();
        reqDTO.setCaseId(dto.getCaseId());
        reqDTO.setPersonnelId(dto.getPersonnelId());
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCaseUserType(dto.getCaseUserType());
        this.caseDubboService.deleteCasePersonnel(reqDTO);
    }

    @Override
    public Integer cancelCase(FailCancelCaseReqDTO dto) {
        String currentUserId = JWTContextUtil.getCurrentUserId();
        CaseResDTO resDTO = this.caseDubboService.getMediationCaseInfoById(dto.getCaseId());
        MediationCaseBaseDTO baseResDTO = resDTO.getMediationCaseBaseResDTO();
        AssertUtils.assertNotNull((Object)baseResDTO, (ResultCode)ErrorCode.CASE_NOT_EXIST, (String)this.mastiffMessages.getCaseNotExist());
        String caseStatus = baseResDTO.getLawCaseStatus();
        AssertUtils.assertFalse((boolean)caseStatus.startsWith(CaseProgressEnum.REFUSE.name()), (ResultCode)ErrorCode.RETRACT_CASE_FAIL, (String)this.mastiffMessages.getNotAcceptCaseNotRetract());
        AssertUtils.assertFalse((boolean)caseStatus.startsWith(CaseProgressEnum.FAIL.name()), (ResultCode)ErrorCode.RETRACT_CASE_FAIL, (String)this.mastiffMessages.getFailCaseNotRetract());
        AssertUtils.assertFalse((boolean)caseStatus.startsWith(CaseProgressEnum.SUCCESS.name()), (ResultCode)ErrorCode.RETRACT_CASE_FAIL, (String)this.mastiffMessages.getSuccessCaseNotRetract());
        AssertUtils.assertFalse((boolean)caseStatus.startsWith(CaseProgressEnum.RETRACT.name()), (ResultCode)ErrorCode.RETRACT_CASE_FAIL, (String)this.mastiffMessages.getRetractCaseNotRetract());
        String currentUserName = this.userDubboService.getUserNameByJWT();
        dto.setUpdateUser(currentUserName);
        int result = this.caseDubboService.cancelCase(dto);
        AssertUtils.assertTrue((result > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.RETRACT_CASE_FAIL, (String)this.mastiffMessages.getRetractCaseFail());
        return result;
    }

    @Override
    public Integer startRetractCase(AuditCaseIdRequestDTO dto) {
        FailCancelCaseReqDTO reqDTO = new FailCancelCaseReqDTO();
        BeanUtils.copyProperties((Object)dto, (Object)reqDTO);
        String currentUserName = this.userDubboService.getUserNameByJWT();
        reqDTO.setCreateId(JWTContextUtil.getCurrentUserId());
        reqDTO.setCreateUser(currentUserName);
        int result = this.caseDubboService.startCancelCase(reqDTO);
        AssertUtils.assertTrue((result > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.RETRACT_CASE_FAIL, (String)this.mastiffMessages.getRetractCaseFail());
        return result;
    }

    @Override
    public ArrayList<LawCaseCancelApplyAuditDTO> applyOrAuditDetail(AuditCaseIdRequestDTO dto) {
        ArrayList<LawCaseCancelApplyAuditDTO> result = this.caseDubboService.applyOrAuditDetail(dto);
        return result;
    }

    @Override
    public Integer auditRetractCase(AuditCaseIdRequestDTO dto) {
        Integer result = null;
        FailCancelCaseReqDTO reqDTO = new FailCancelCaseReqDTO();
        BeanUtils.copyProperties((Object)dto, (Object)reqDTO);
        String currentUserName = this.userDubboService.getUserNameByJWT();
        reqDTO.setCreateId(JWTContextUtil.getCurrentUserId());
        reqDTO.setCreateUser(currentUserName);
        if (CaseStatusEnum.AUDIT_RETRACT_CANCEL_CASE_SUCCESS.equals((Object)dto.getAuditResult())) {
            result = this.cancelCase(reqDTO);
        } else {
            result = this.caseDubboService.backCancelCase(reqDTO);
            AssertUtils.assertTrue((result > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.RETRACT_CASE_FAIL, (String)this.mastiffMessages.getRetractCaseFail());
        }
        return result;
    }

    public String getCaseNo() {
        long sequence = 0L;
        try {
            sequence = this.redisSequenceFactory.generate("caseno_Sequence");
        }
        catch (Exception e) {
            log.error((Object)"redis\u81ea\u589e\u5e8f\u5217\u751f\u6210\u62a5\u9519:{}", (Throwable)e);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            String date = Long.toHexString(calendar.getTimeInMillis()).toUpperCase();
            String freeRandom = String.valueOf((int)(Math.random() * 90.0) + 10);
            return date + freeRandom;
        }
        return String.format("\uff08%d\uff09\u591a\u5143\u5316\u89e3%d\u53f7", Calendar.getInstance().getWeekYear(), sequence);
    }

    private void checkLoginUserInCaseUser(String userId, MediationCaseRequestDTO dto) {
        boolean flag = false;
        PetitionAgentRequestDTO petitionAgentDTO = dto.getPetitionAgentDTO();
        if (petitionAgentDTO != null && userId.equals(String.valueOf(petitionAgentDTO.getUserId()))) {
            flag = true;
        }
        if (!flag) {
            for (SaveCaseUserRequestDTO applyUser : dto.getApplyUserList()) {
                if (!userId.equals(String.valueOf(applyUser.getUserId())) && !userId.equals(String.valueOf(applyUser.getAgentId()))) continue;
                flag = true;
                break;
            }
        }
        AssertUtils.assertTrue((boolean)flag, (ResultCode)ErrorCode.USER_MUST_APPLICANT_OR_AGENT, (String)this.mastiffMessages.getUserMustApplicantOrAgent());
    }
}

