/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.ShortUrlUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.enums.MastiffRedisKeyEnums;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.ProtocolBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SavePromiseBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SendFinalMediationReportRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.SendProtocolBookResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.UnanimityMediationSchemeResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.DocumentDubboService;
import com.beiming.odr.mastiff.service.backend.referee.convert.DocumentConvert;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.DocumentService;
import com.beiming.odr.referee.dto.requestdto.InvalidDocumentDTO;
import com.beiming.odr.referee.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SaveProtocolBookReqDTO;
import com.beiming.odr.referee.dto.requestdto.SendFinalMediationReportReqDTO;
import com.beiming.odr.referee.dto.responsedto.ProtocolBookResDTO;
import com.beiming.odr.referee.dto.responsedto.UnanimityMediationSchemeResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger log = LoggerFactory.getLogger(DocumentServiceImpl.class);
    @Resource
    private DocumentDubboService documentDubboService;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private RedisService redisService;
    @Resource
    private MastiffMessages mastiffMessages;
    @Value(value="${mastiff.qrCodeUrlPrefix}")
    private String qrCodeUrlPrefix;
    @Value(value="${mastiff.accessSignUrlPrefix}")
    private String accessSignUrlPrefix;
    @Value(value="${mastiff.apiAddress}")
    private String apiAddress;

    @Override
    public ProtocolBookResponseDTO getProtocolBook(ProtocolBookRequestDTO dto) {
        ProtocolBookResDTO protocolBook = null;
        protocolBook = this.userDubboService.checkIsMediator(dto.getCaseId()) != false ? this.documentDubboService.getProtocolBook(dto.getCaseId(), dto.getDocumentType()) : this.documentDubboService.getTempProtocolBook(dto.getCaseId(), dto.getDocumentType());
        AssertUtils.assertNotNull((Object)protocolBook, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        ProtocolBookResponseDTO responseDTO = DocumentConvert.getProtocolBookResponseDTO(protocolBook);
        return responseDTO;
    }

    @Override
    public ProtocolBookResponseDTO saveProtocolBook(SaveProtocolBookRequestDTO dto) {
        SaveProtocolBookReqDTO reqDTO = DocumentConvert.getSaveProtocolBookReqDTO(dto);
        CommonUserSearchResDTO searchResDTO = this.userDubboService.searchCommonUser(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCreateUser(searchResDTO.getUserName());
        reqDTO.setUpdateUser(searchResDTO.getUserName());
        ProtocolBookResDTO bookResDTO = this.documentDubboService.saveProtocolBook(reqDTO);
        AssertUtils.assertNotNull((Object)bookResDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        ProtocolBookResponseDTO responseDTO = DocumentConvert.getProtocolBookResponseDTO(bookResDTO);
        return responseDTO;
    }

    @Override
    public UnanimityMediationSchemeResponseDTO getMediationScheme(CaseIdRequestDTO dto) {
        UnanimityMediationSchemeResDTO mediationScheme = this.documentDubboService.getMediationScheme(dto.getCaseId());
        AssertUtils.assertNotNull((Object)mediationScheme, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        UnanimityMediationSchemeResponseDTO responseDTO = DocumentConvert.getUnanimityMediationSchemeResponseDTO(mediationScheme);
        return responseDTO;
    }

    @Override
    public void savePromiseBook(SavePromiseBookRequestDTO dto) {
        SavePromiseBookReqDTO reqDTO = DocumentConvert.getSavePromiseBookReqDTO(dto);
        CommonUserSearchResDTO searchResDTO = this.userDubboService.searchCommonUser(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCreateUser(searchResDTO.getUserName());
        reqDTO.setUpdateUser(searchResDTO.getUserName());
        this.documentDubboService.savePromiseBook(reqDTO);
    }

    @Override
    public void sendFinalMediationReport(SendFinalMediationReportRequestDTO dto) {
        SendFinalMediationReportReqDTO reqDTO = DocumentConvert.getSendFinalMediationReportReqDTO(dto);
        CommonUserSearchResDTO searchResDTO = this.userDubboService.searchCommonUser(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCreateUser(searchResDTO.getUserName());
        reqDTO.setUpdateUser(searchResDTO.getUserName());
        reqDTO.setCreateUserId(searchResDTO.getUserId());
        this.documentDubboService.sendFinalMediationReport(reqDTO);
    }

    @Override
    public String previewProtocolBook(Long documentId) {
        return this.documentDubboService.previewProtocolBook(documentId);
    }

    @Override
    public void invalidProtocolBook(InvalidDocumentDTO req) {
        this.documentDubboService.invalidProtocolBook(req);
    }

    @Override
    public SendProtocolBookResponseDTO sendProtocolBook(SaveProtocolBookRequestDTO dto) {
        SendProtocolBookResponseDTO result = new SendProtocolBookResponseDTO();
        SaveProtocolBookReqDTO reqDTO = DocumentConvert.getSaveProtocolBookReqDTO(dto);
        CommonUserSearchResDTO searchResDTO = this.userDubboService.searchCommonUser(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setCreateUser(searchResDTO.getUserName());
        reqDTO.setUpdateUser(searchResDTO.getUserName());
        ProtocolBookResDTO responseDTO = this.documentDubboService.saveProtocolBook(reqDTO);
        AssertUtils.assertNotNull((Object)responseDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        String launchSign = this.launchSign(responseDTO.getProtocolId(), JWTContextUtil.getCurrentUserId());
        result.setProtocolId(responseDTO.getProtocolId());
        result.setLaunchSign(launchSign);
        return result;
    }

    @Override
    public String launchSign(Long documentId, String currentUserId) {
        String shortQrCodeUrl = ShortUrlUtils.encode((long)documentId) + ShortUrlUtils.encode((long)Long.valueOf(currentUserId));
        String shortUrl = this.qrCodeUrlPrefix.concat(shortQrCodeUrl);
        String longUrl = this.accessSignUrlPrefix.concat(documentId.toString()) + "&userId=" + currentUserId + "&apiUrlPrefix=" + this.apiAddress;
        this.redisService.hSet((RedisKey)MastiffRedisKeyEnums.SHORT_URL, shortQrCodeUrl, (Object)longUrl);
        return shortUrl;
    }

    @Override
    public Long refuserProtocolBook(Long documentId) {
        String userName = this.userDubboService.getUserNameByJWT();
        Long docId = this.documentDubboService.refuseDocument(documentId, userName);
        return docId;
    }
}

