/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.basic.chat.api.dto.response.EmotionalRecognitionStatisticsResDTO;
import com.beiming.basic.chat.api.dto.response.SegmentedEmotionalRecognitionResDTO;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.Java8DateUtils;
import com.beiming.odr.mastiff.common.enums.EmotionEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.MeetingEmotionRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.EmotionResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.EmotionStackListResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MeetingEmotionResponseDTO;
import com.beiming.odr.mastiff.service.backend.chat.EmotionalRecognitionDubboService;
import com.beiming.odr.mastiff.service.client.EmotionService;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.UserEmotionResDTO;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EmotionServiceImpl
implements EmotionService {
    @Value(value="${emotion.date}")
    private String emotionOnlineDate;
    @Resource
    private EmotionalRecognitionDubboService emotionDubboService;

    @Override
    public ArrayList<MeetingEmotionResponseDTO> meetingEmotion(MeetingEmotionRequestDTO requestDTO) {
        ArrayList<MeetingEmotionResponseDTO> result = new ArrayList<MeetingEmotionResponseDTO>();
        if (!this.isEmotionOnline().booleanValue()) {
            return result;
        }
        ArrayList<EmotionalRecognitionStatisticsResDTO> listEmotion = this.emotionDubboService.listEmotionByRoomId(requestDTO.getMeetingVideoId());
        if (null == listEmotion || listEmotion.isEmpty()) {
            return result;
        }
        MeetingEmotionResponseDTO responseDTO = null;
        EmotionStackListResponseDTO stack = null;
        SegmentedEmotionalRecognitionResDTO distribution = null;
        SegmentedEmotionalRecognitionResDTO segment = null;
        for (EmotionalRecognitionStatisticsResDTO resDTO : listEmotion) {
            ArrayList segmentList;
            distribution = resDTO.getTotalDistribution();
            if (Objects.isNull(distribution) || (segmentList = resDTO.getSegmentList()).isEmpty()) continue;
            ArrayList radarList = Lists.newArrayList();
            radarList.add(new EmotionResponseDTO(EmotionEnum.NEUTRAL, distribution.getNeutral()));
            radarList.add(new EmotionResponseDTO(EmotionEnum.HAPPINESS, distribution.getHappiness()));
            radarList.add(new EmotionResponseDTO(EmotionEnum.FEAR, distribution.getFear()));
            radarList.add(new EmotionResponseDTO(EmotionEnum.SURPRISE, distribution.getSurprise()));
            radarList.add(new EmotionResponseDTO(EmotionEnum.ANGER, distribution.getAnger()));
            radarList.add(new EmotionResponseDTO(EmotionEnum.DISGUST, distribution.getDisgust()));
            radarList.add(new EmotionResponseDTO(EmotionEnum.SADNESS, distribution.getSadness()));
            Long startTime = ((SegmentedEmotionalRecognitionResDTO)segmentList.get(0)).getSegmentedTime();
            Long endTime = ((SegmentedEmotionalRecognitionResDTO)segmentList.get(segmentList.size() - 1)).getSegmentedTime();
            Double totalMinutes = (double)(endTime - startTime) / 1000.0 / 60.0;
            Double segTime = totalMinutes / (double)segmentList.size();
            ArrayList userStackList = Lists.newArrayList();
            int size = segmentList.size();
            for (int i = 0; i < size; ++i) {
                segment = (SegmentedEmotionalRecognitionResDTO)segmentList.get(i);
                stack = new EmotionStackListResponseDTO();
                ArrayList stackList = Lists.newArrayList();
                stackList.add(new EmotionResponseDTO("xAxis", "xAxis", this.getSegTime(segmentList.size(), i, segTime, totalMinutes), "#999999"));
                stackList.add(new EmotionResponseDTO(EmotionEnum.NEUTRAL, segment.getNeutral()));
                stackList.add(new EmotionResponseDTO(EmotionEnum.HAPPINESS, segment.getHappiness()));
                stackList.add(new EmotionResponseDTO(EmotionEnum.FEAR, segment.getFear()));
                stackList.add(new EmotionResponseDTO(EmotionEnum.SURPRISE, segment.getSurprise()));
                stackList.add(new EmotionResponseDTO(EmotionEnum.ANGER, segment.getAnger()));
                stackList.add(new EmotionResponseDTO(EmotionEnum.DISGUST, segment.getDisgust()));
                stackList.add(new EmotionResponseDTO(EmotionEnum.SADNESS, segment.getSadness()));
                stack.setStack((List)stackList);
                userStackList.add(stack);
            }
            responseDTO = new MeetingEmotionResponseDTO();
            responseDTO.setRadarList((List)radarList);
            responseDTO.setUserId(Long.valueOf(resDTO.getMemberId()));
            responseDTO.setUserName(resDTO.getMemberName());
            responseDTO.setStackList((List)userStackList);
            result.add(responseDTO);
        }
        return result;
    }

    @Override
    public List<CaseMeetingListResDTO> getJoinUser(List<CaseMeetingListResDTO> caseMeetingList) {
        String personType = JWTContextUtil.getPersonType();
        if (!this.isEmotionOnline().booleanValue() || PersonTypeEnum.COMMON.name().equals(personType)) {
            return caseMeetingList;
        }
        for (CaseMeetingListResDTO caseMeetingListResDTO : caseMeetingList) {
            ArrayList userEmotionResDTOS = Lists.newArrayList();
            ArrayList<EmotionalRecognitionStatisticsResDTO> listEmotion = this.emotionDubboService.listEmotionByRoomId(caseMeetingListResDTO.getMeetingVideoId());
            if (null == listEmotion || listEmotion.isEmpty()) {
                return caseMeetingList;
            }
            for (EmotionalRecognitionStatisticsResDTO tmp : listEmotion) {
                if (Objects.isNull(tmp.getMaxEmotional())) continue;
                UserEmotionResDTO userEmotion = new UserEmotionResDTO();
                userEmotion.setUserId(Long.valueOf(Long.parseLong(tmp.getMemberId())));
                userEmotion.setUserName(tmp.getMemberName());
                userEmotion.setEmotion(EmotionEnum.getByName((String)tmp.getMaxEmotional().toString()).getCode());
                userEmotionResDTOS.add(userEmotion);
            }
            caseMeetingListResDTO.setJoinUser((List)userEmotionResDTOS);
        }
        return caseMeetingList;
    }

    private Boolean isEmotionOnline() {
        return LocalDate.now().compareTo(Java8DateUtils.getLocalDate((String)this.emotionOnlineDate)) >= 0;
    }

    private String getSegTime(Integer size, Integer index, Double segTime, Double totalMinutes) {
        Integer scale = totalMinutes > (double)size.intValue() ? 0 : 2;
        Double segmentedTime = index != size - 1 ? Double.valueOf(segTime * (double)(index + 1)) : totalMinutes;
        BigDecimal b = new BigDecimal(segmentedTime);
        return b.setScale((int)scale, 4).toPlainString();
    }
}

