/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.enums.StatusEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetJudicialConfirmBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.JudicialConfirmPersonnelRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveJudicialConfirmBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.JudicialConfirmBookResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.DocumentDubboService;
import com.beiming.odr.mastiff.service.backend.referee.MediationMeetingApiService;
import com.beiming.odr.mastiff.service.backend.referee.convert.JudicialConfirmConvert;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.JudicialConfirmService;
import com.beiming.odr.referee.dto.requestdto.SaveJudicialConfirmBookReqDTO;
import com.beiming.odr.referee.dto.responsedto.JudicialConfirmBookResDTO;
import com.beiming.odr.referee.enums.DocumentTypeEnum;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class JudicialConfirmServiceImpl
implements JudicialConfirmService {
    @Resource
    private DocumentDubboService documentDubboService;
    @Resource
    private MediationMeetingApiService mediationMeetingApiService;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public JudicialConfirmBookResponseDTO getJudicialConfirmBook(GetJudicialConfirmBookRequestDTO dto) {
        String userId = JWTContextUtil.getCurrentUserId();
        DubboResult dubboResult = this.mediationMeetingApiService.personList(dto.getCaseId(), Long.valueOf(userId));
        ArrayList data = (ArrayList)dubboResult.getData();
        JudicialConfirmBookResDTO judicialConfirmBook = null;
        judicialConfirmBook = data.stream().anyMatch(a -> UserRoleEnum.MEDIATOR.name().equals(a.getCaseUserType())) ? this.documentDubboService.getJudicialConfirmBook(dto.getCaseId(), DocumentTypeEnum.JUDICIAL_CONFIRM_APPLY_BOOK, StatusEnum.USED.getCode()) : this.documentDubboService.getJudicialConfirmBook(dto.getCaseId(), DocumentTypeEnum.JUDICIAL_CONFIRM_APPLY_BOOK, StatusEnum.DELETE.getCode());
        AssertUtils.assertNotNull((Object)judicialConfirmBook, (ResultCode)ErrorCode.JUDICIAL_CONFIRM_GET_FAIL, (String)this.mastiffMessages.getJudicialConfirmGetFail());
        JudicialConfirmBookResponseDTO response = JudicialConfirmConvert.getJudicialConfirmBookResponseDTO(judicialConfirmBook);
        return response;
    }

    @Override
    public JudicialConfirmBookResponseDTO saveJudicialConfirmBook(SaveJudicialConfirmBookRequestDTO dto) {
        this.checkRealName(dto.getPersonnelList());
        SaveJudicialConfirmBookReqDTO reqDTO = JudicialConfirmConvert.getSaveJudicialConfirmBookReqDTO(dto);
        reqDTO.setCreateUser(this.userDubboService.getUserNameByJWT());
        reqDTO.setUpdateUser(this.userDubboService.getUserNameByJWT());
        Long judicialId = this.documentDubboService.saveJudicialConfirmBook(reqDTO);
        AssertUtils.assertNotNull((Object)judicialId, (ResultCode)ErrorCode.JUDICIAL_CONFIRM_SAVE_FAIL, (String)this.mastiffMessages.getJudicialConfirmSaveFail());
        JudicialConfirmBookResDTO judicialConfirmBook = this.documentDubboService.getJudicialConfirmBook(dto.getCaseId(), DocumentTypeEnum.JUDICIAL_CONFIRM_APPLY_BOOK, StatusEnum.USED.getCode());
        AssertUtils.assertNotNull((Object)judicialConfirmBook, (ResultCode)ErrorCode.JUDICIAL_CONFIRM_GET_FAIL, (String)this.mastiffMessages.getJudicialConfirmGetFail());
        JudicialConfirmBookResponseDTO response = JudicialConfirmConvert.getJudicialConfirmBookResponseDTO(judicialConfirmBook);
        return response;
    }

    @Override
    public Long sendJudicialConfirmBook(SaveJudicialConfirmBookRequestDTO dto) {
        this.checkRealName(dto.getPersonnelList());
        SaveJudicialConfirmBookReqDTO reqDTO = JudicialConfirmConvert.getSaveJudicialConfirmBookReqDTO(dto);
        reqDTO.setCreateUser(this.userDubboService.getUserNameByJWT());
        reqDTO.setUpdateUser(this.userDubboService.getUserNameByJWT());
        Long judicialId = this.documentDubboService.sendJudicialConfirmBook(reqDTO);
        AssertUtils.assertNotNull((Object)judicialId, (ResultCode)ErrorCode.JUDICIAL_CONFIRM_SEND_FAIL, (String)this.mastiffMessages.getJudicialConfirmSendFail());
        return judicialId;
    }

    private void checkRealName(List<JudicialConfirmPersonnelRequestDTO> personnelList) {
        for (JudicialConfirmPersonnelRequestDTO req : personnelList) {
            boolean checkFlag;
            String userName = req.getUserType().equals(UserTypeEnum.NATURAL_PERSON.name()) ? req.getName() : req.getCorporation();
            if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)req.getIdCard())) {
                checkFlag = this.userDubboService.checkRealNameAuthentication(userName, req.getIdCard());
                AssertUtils.assertTrue((boolean)checkFlag, (ResultCode)ErrorCode.REAL_NAME_CHECK_FAIL, (String)("\u7533\u8bf7\u4eba" + userName + "\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u4e0d\u5339\u914d"));
            }
            if (!StringUtils.isNotBlank((CharSequence)req.getAgentName()) || !StringUtils.isNotBlank((CharSequence)req.getAgentIdCard())) continue;
            checkFlag = this.userDubboService.checkRealNameAuthentication(req.getAgentName(), req.getAgentIdCard());
            AssertUtils.assertTrue((boolean)checkFlag, (ResultCode)ErrorCode.REAL_NAME_CHECK_FAIL, (String)("\u7533\u8bf7\u4eba" + userName + "\u7684\u4ee3\u7406\u4eba\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u4e0d\u5339\u914d"));
        }
    }
}

