/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.enums.StatusEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetMediationApplyBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.JudicialConfirmPersonnelRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveMediationApplyBookRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationApplyBookResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.DocumentDubboService;
import com.beiming.odr.mastiff.service.backend.referee.MediationMeetingApiService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationApplyConvert;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.MediationApplyService;
import com.beiming.odr.referee.dto.requestdto.SaveMediationApplyBookReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationApplyBookResDTO;
import com.beiming.odr.referee.enums.DocumentTypeEnum;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MediationApplyServiceImpl
implements MediationApplyService {
    @Resource
    private DocumentDubboService documentDubboService;
    @Resource
    private MediationMeetingApiService mediationMeetingApiService;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public MediationApplyBookResponseDTO getMediationApplyBook(GetMediationApplyBookRequestDTO dto) {
        String userId = JWTContextUtil.getCurrentUserId();
        DubboResult dubboResult = this.mediationMeetingApiService.personList(dto.getCaseId(), Long.valueOf(userId));
        ArrayList data = (ArrayList)dubboResult.getData();
        MediationApplyBookResDTO mediationApplyBook = null;
        mediationApplyBook = data.stream().anyMatch(a -> UserRoleEnum.MEDIATOR.name().equals(a.getCaseUserType())) ? this.documentDubboService.getMediationApplyBook(dto.getCaseId(), DocumentTypeEnum.MEDIATION_APPLY_BOOK, StatusEnum.USED.getCode()) : this.documentDubboService.getMediationApplyBook(dto.getCaseId(), DocumentTypeEnum.MEDIATION_APPLY_BOOK, StatusEnum.DELETE.getCode());
        AssertUtils.assertNotNull((Object)mediationApplyBook, (ResultCode)ErrorCode.MEDIATION_APPLY_GET_FAIL, (String)this.mastiffMessages.getMediationApplyGetFail());
        MediationApplyBookResponseDTO response = MediationApplyConvert.getMediationApplyBookResponseDTO(mediationApplyBook);
        return response;
    }

    @Override
    public MediationApplyBookResponseDTO saveMediationApplyBook(SaveMediationApplyBookRequestDTO dto) {
        this.checkRealName(dto.getPersonnelList());
        SaveMediationApplyBookReqDTO reqDTO = MediationApplyConvert.getSaveMediationApplyBookReqDTO(dto);
        reqDTO.setCreateUser(this.userDubboService.getUserNameByJWT());
        reqDTO.setUpdateUser(this.userDubboService.getUserNameByJWT());
        Long judicialId = this.documentDubboService.saveMediationApplyBook(reqDTO);
        AssertUtils.assertNotNull((Object)judicialId, (ResultCode)ErrorCode.MEDIATION_APPLY_SAVE_FAIL, (String)this.mastiffMessages.getMediationApplySaveFail());
        MediationApplyBookResDTO mediationApplyBook = this.documentDubboService.getMediationApplyBook(dto.getCaseId(), DocumentTypeEnum.MEDIATION_APPLY_BOOK, StatusEnum.USED.getCode());
        AssertUtils.assertNotNull((Object)mediationApplyBook, (ResultCode)ErrorCode.MEDIATION_APPLY_GET_FAIL, (String)this.mastiffMessages.getMediationApplyGetFail());
        MediationApplyBookResponseDTO response = MediationApplyConvert.getMediationApplyBookResponseDTO(mediationApplyBook);
        return response;
    }

    @Override
    public Long sendMediationApplyBook(SaveMediationApplyBookRequestDTO dto) {
        this.checkRealName(dto.getPersonnelList());
        SaveMediationApplyBookReqDTO reqDTO = MediationApplyConvert.getSaveMediationApplyBookReqDTO(dto);
        reqDTO.setCreateUser(this.userDubboService.getUserNameByJWT());
        reqDTO.setUpdateUser(this.userDubboService.getUserNameByJWT());
        Long mediationId = this.documentDubboService.sendMediationApplyBook(reqDTO);
        AssertUtils.assertNotNull((Object)mediationId, (ResultCode)ErrorCode.MEDIATION_APPLY_SEND_FAIL, (String)this.mastiffMessages.getMediationApplySendFail());
        return mediationId;
    }

    private void checkRealName(List<JudicialConfirmPersonnelRequestDTO> personnelList) {
        for (JudicialConfirmPersonnelRequestDTO req : personnelList) {
            boolean checkFlag;
            String userName = req.getUserType().equals(UserTypeEnum.NATURAL_PERSON.name()) ? req.getName() : req.getCorporation();
            if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)req.getIdCard())) {
                checkFlag = this.userDubboService.checkRealNameAuthentication(userName, req.getIdCard());
                AssertUtils.assertTrue((boolean)checkFlag, (ResultCode)ErrorCode.REAL_NAME_CHECK_FAIL, (String)("\u7533\u8bf7\u4eba" + userName + "\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u4e0d\u5339\u914d"));
            }
            if (!StringUtils.isNotBlank((CharSequence)req.getAgentName()) || !StringUtils.isNotBlank((CharSequence)req.getAgentIdCard())) continue;
            checkFlag = this.userDubboService.checkRealNameAuthentication(req.getAgentName(), req.getAgentIdCard());
            AssertUtils.assertTrue((boolean)checkFlag, (ResultCode)ErrorCode.REAL_NAME_CHECK_FAIL, (String)("\u7533\u8bf7\u4eba" + userName + "\u7684\u4ee3\u7406\u4eba\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u4e0d\u5339\u914d"));
        }
    }
}

