/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationDissentGetRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationDissentSaveRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationDissentSendRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationDissentGetResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationDissentSaveResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationDissentSendResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.MediationDissentBackService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationDissentConvert;
import com.beiming.odr.mastiff.service.client.DocumentService;
import com.beiming.odr.mastiff.service.client.MediationDissentService;
import com.beiming.odr.referee.dto.requestdto.MediationDissentGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationDissentSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationDissentSendResDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MediationDissentServiceImpl
implements MediationDissentService {
    @Resource
    private MediationDissentBackService mediationDissentBackServiceImpl;
    @Resource
    private DocumentService documentServiceImpl;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public MediationDissentSendResponseDTO sendMediationDissent(MediationDissentSendRequestDTO requestDTO) {
        MediationDissentSendReqDTO reqDTO = MediationDissentConvert.convertToMediationDissentSendReqDTO(requestDTO);
        MediationDissentSendResDTO resDTO = this.mediationDissentBackServiceImpl.sendMediationDissent(reqDTO);
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        String launchSign = this.documentServiceImpl.launchSign(resDTO.getDocumentId(), JWTContextUtil.getCurrentUserId());
        MediationDissentSendResponseDTO responseDto = new MediationDissentSendResponseDTO();
        responseDto.setDocumentId(resDTO.getDocumentId());
        responseDto.setLaunchSign(launchSign);
        return responseDto;
    }

    @Override
    public MediationDissentSaveResponseDTO saveMediationDissent(MediationDissentSaveRequestDTO requestDTO) {
        MediationDissentSaveReqDTO reqDTO = MediationDissentConvert.convertToMediationDissentSaveReqDTO(requestDTO);
        MediationDissentSaveResDTO resDTO = this.mediationDissentBackServiceImpl.saveMediationDissent(reqDTO);
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return MediationDissentConvert.convertToMediationDissentSaveResponseDTO(resDTO);
    }

    @Override
    public MediationDissentGetResponseDTO viewMediationDissent(MediationDissentGetRequestDTO requestDTO) {
        MediationDissentGetReqDTO reqDTO = MediationDissentConvert.convertToMediationDissentGetReqDTO(requestDTO);
        MediationDissentGetResDTO resDTO = this.mediationDissentBackServiceImpl.viewMediationDissent(reqDTO);
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return MediationDissentConvert.convertToMediationDissentGetResponseDTO(resDTO);
    }
}

