/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.AssignOrgRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseDeclinedRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CasePersonRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationReallocateRequsetDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationSuccessFailRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationSuspendRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.ReapportionMediatorApplicationRequsetDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.TransferMediationRequestDTO;
import com.beiming.odr.mastiff.service.backend.referee.LawCaseDossierApiService;
import com.beiming.odr.mastiff.service.backend.referee.MediationMeetingApiService;
import com.beiming.odr.mastiff.service.client.MediationMeetingService;
import com.beiming.odr.referee.api.ThirdPartApi;
import com.beiming.odr.referee.dto.requestdto.AssignOrgReqDTO;
import com.beiming.odr.referee.dto.requestdto.AttachmentListReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseDeclinedReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationReallocateReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationSuccessFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationSuspendReqDTO;
import com.beiming.odr.referee.dto.requestdto.ReapportionMediatorApplicationReqDTO;
import com.beiming.odr.referee.dto.requestdto.TransferMediationReqDTO;
import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MediationMeetingServiceImpl
implements MediationMeetingService {
    private static final Logger log = LoggerFactory.getLogger(MediationMeetingServiceImpl.class);
    @Resource
    private MediationMeetingApiService mediationMeetingApiService;
    @Resource
    private LawCaseDossierApiService lawCaseDossierApiService;
    @Resource
    private MastiffMessages mastiffMessages;
    @Resource
    private ThirdPartApi thirdPartApi;

    @Override
    public String mediationSuccess(MediationSuccessFailRequestDTO mediationSuccessFailRequestDTO, Long userId, String userName) {
        String message = null;
        MediationSuccessFailReqDTO mediationSuccessFailReqDTO = new MediationSuccessFailReqDTO();
        mediationSuccessFailReqDTO.setCaseId(mediationSuccessFailRequestDTO.getCaseId());
        mediationSuccessFailReqDTO.setDetailRason(mediationSuccessFailRequestDTO.getDetailRason());
        mediationSuccessFailReqDTO.setReasonType(mediationSuccessFailRequestDTO.getReasonType());
        mediationSuccessFailReqDTO.setUserId(userId);
        mediationSuccessFailReqDTO.setUserName(userName);
        mediationSuccessFailReqDTO.setCloseType(mediationSuccessFailRequestDTO.getCloseType());
        DubboResult result = this.mediationMeetingApiService.mediationSuccess(mediationSuccessFailReqDTO);
        this.thirdPartApi.syncToHngs(mediationSuccessFailRequestDTO.getCaseId(), CaseStatusEnum.SUCCESS_MEDIATION, mediationSuccessFailRequestDTO.getReasonType(), mediationSuccessFailRequestDTO.getDetailRason());
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String mediationSuspend(MediationSuspendRequestDTO requestDTO, Long userId, String userName) {
        String message = null;
        MediationSuspendReqDTO mediationSuspendReqDTO = new MediationSuspendReqDTO();
        mediationSuspendReqDTO.setCaseId(requestDTO.getCaseId());
        mediationSuspendReqDTO.setReasonType(requestDTO.getReasonType());
        mediationSuspendReqDTO.setDetailRason(requestDTO.getDetailRason());
        mediationSuspendReqDTO.setUserId(userId);
        mediationSuspendReqDTO.setUserName(userName);
        DubboResult result = this.mediationMeetingApiService.mediationSuspend(mediationSuspendReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String mediationFail(MediationSuccessFailRequestDTO mediationSuccessFailRequestDTO, Long userId, String userName) {
        String message = null;
        MediationSuccessFailReqDTO mediationSuccessFailReqDTO = new MediationSuccessFailReqDTO();
        mediationSuccessFailReqDTO.setCaseId(mediationSuccessFailRequestDTO.getCaseId());
        mediationSuccessFailReqDTO.setDetailRason(mediationSuccessFailRequestDTO.getDetailRason());
        mediationSuccessFailReqDTO.setReasonType(mediationSuccessFailRequestDTO.getReasonType());
        mediationSuccessFailReqDTO.setUserId(userId);
        mediationSuccessFailReqDTO.setUserName(userName);
        DubboResult result = this.mediationMeetingApiService.mediationFail(mediationSuccessFailReqDTO);
        this.thirdPartApi.syncToHngs(mediationSuccessFailRequestDTO.getCaseId(), CaseStatusEnum.FAIL_MEDIATION, mediationSuccessFailRequestDTO.getReasonType(), mediationSuccessFailRequestDTO.getDetailRason());
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String reallocate(MediationReallocateRequsetDTO mediationReallocateRequsetDTO, Long userId, String userName) {
        String message = null;
        MediationReallocateReqDTO diationReallocateReqDTO = new MediationReallocateReqDTO();
        diationReallocateReqDTO.setCaseId(mediationReallocateRequsetDTO.getCaseId());
        diationReallocateReqDTO.setDetailRason(mediationReallocateRequsetDTO.getReasonDetail());
        diationReallocateReqDTO.setReallocateEnum(mediationReallocateRequsetDTO.getReasonCode());
        diationReallocateReqDTO.setUserId(userId);
        diationReallocateReqDTO.setUserName(userName);
        DubboResult result = this.mediationMeetingApiService.reallocate(diationReallocateReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String accept(Long caseId, Long userId, String userName) {
        String message = null;
        DubboResult result = this.mediationMeetingApiService.accept(caseId, userId, userName);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String caseDeclined(CaseDeclinedRequestDTO caseDeclinedRequestDTO, Long userId, String userName) {
        String message = null;
        CaseDeclinedReqDTO caseDeclinedReqDTO = new CaseDeclinedReqDTO();
        caseDeclinedReqDTO.setCaseId(caseDeclinedRequestDTO.getCaseId());
        caseDeclinedReqDTO.setCaseDeclinedEnum(caseDeclinedRequestDTO.getTab());
        caseDeclinedReqDTO.setTabDetail(caseDeclinedRequestDTO.getTabDetail());
        caseDeclinedReqDTO.setUserId(userId);
        caseDeclinedReqDTO.setUserName(userName);
        DubboResult result = this.mediationMeetingApiService.caseDeclined(caseDeclinedReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String reMediatorApplication(ReapportionMediatorApplicationRequsetDTO reapportionMediatorApplicationRequsetDTO, Long userId, String userName) {
        String message = null;
        ReapportionMediatorApplicationReqDTO reapportionMediatorApplicationReqDTO = new ReapportionMediatorApplicationReqDTO();
        reapportionMediatorApplicationReqDTO.setCaseId(reapportionMediatorApplicationRequsetDTO.getCaseId());
        reapportionMediatorApplicationReqDTO.setCmId(reapportionMediatorApplicationRequsetDTO.getCmId());
        reapportionMediatorApplicationReqDTO.setUserId(userId);
        reapportionMediatorApplicationReqDTO.setUserName(userName);
        DubboResult result = this.mediationMeetingApiService.reMediatorApplication(reapportionMediatorApplicationReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String transferMediation(TransferMediationRequestDTO transferMediationRequestDTO, Long userId, String userName) {
        String message = null;
        TransferMediationReqDTO transferMediationReqDTO = new TransferMediationReqDTO();
        transferMediationReqDTO.setCaseId(transferMediationRequestDTO.getCaseId());
        transferMediationReqDTO.setDetailRason(transferMediationRequestDTO.getDetailRason());
        transferMediationReqDTO.setOrgId(transferMediationRequestDTO.getOrgId());
        transferMediationReqDTO.setUserId(userId);
        transferMediationReqDTO.setUserName(userName);
        DubboResult result = this.mediationMeetingApiService.transferMediation(transferMediationReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }

    @Override
    public String queryPersonList(CasePersonRequestDTO casePersonRequestDTO, String fileId) {
        String fileName = null;
        AttachmentListReqDTO attachmentListReqDTO = new AttachmentListReqDTO();
        attachmentListReqDTO.setCaseId(casePersonRequestDTO.getCaseId());
        attachmentListReqDTO.setFileId(fileId);
        List<DossAttachmentResDTO> list = this.lawCaseDossierApiService.downloadFile(attachmentListReqDTO);
        AssertUtils.assertTrue((list.size() > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.SAVE_CASE_FAIL, (String)this.mastiffMessages.getAttamentNoExist());
        fileName = list.get(0).getFileName();
        return fileName;
    }

    @Override
    public String assignOrg(AssignOrgRequestDTO requestDTO, Long userId, String userName) {
        String message = null;
        AssignOrgReqDTO assignOrgReqDTO = new AssignOrgReqDTO();
        assignOrgReqDTO.setCaseIds(requestDTO.getCaseIds());
        assignOrgReqDTO.setOrgId(requestDTO.getOrgId());
        assignOrgReqDTO.setUserId(userId);
        assignOrgReqDTO.setUserName(userName);
        DubboResult result = this.mediationMeetingApiService.assignOrg(assignOrgReqDTO);
        if (!result.isSuccess()) {
            message = result.getMessage();
        }
        return message;
    }
}

