/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationRecordGetRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationRecordSaveRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationRecordSendRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationRecordGetResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationRecordSaveResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationRecordSendResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.MediationRecordBackService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationRecordConvert;
import com.beiming.odr.mastiff.service.client.DocumentService;
import com.beiming.odr.mastiff.service.client.MediationRecordService;
import com.beiming.odr.referee.dto.requestdto.MediationRecordGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSendResDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MediationRecordServiceImpl
implements MediationRecordService {
    @Resource
    MediationRecordBackService mediationRecordBackServiceImpl;
    @Resource
    private DocumentService documentServiceImpl;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public MediationRecordSendResponseDTO sendMediationRecord(MediationRecordSendRequestDTO requestDTO) {
        MediationRecordSendReqDTO reqDTO = MediationRecordConvert.convertToMediationRecordSendReqDTO(requestDTO);
        MediationRecordSendResDTO resDTO = this.mediationRecordBackServiceImpl.sendMediationRecord(reqDTO);
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        String launchSign = this.documentServiceImpl.launchSign(resDTO.getDocumentId(), JWTContextUtil.getCurrentUserId());
        MediationRecordSendResponseDTO responseDto = new MediationRecordSendResponseDTO();
        responseDto.setDocumentId(resDTO.getDocumentId());
        responseDto.setLaunchSign(launchSign);
        return responseDto;
    }

    @Override
    public MediationRecordSaveResponseDTO saveMediationRecord(MediationRecordSaveRequestDTO requestDTO) {
        MediationRecordSaveReqDTO reqDTO = MediationRecordConvert.convertToMediationRecordSaveReqDTO(requestDTO);
        MediationRecordSaveResDTO resDTO = this.mediationRecordBackServiceImpl.saveMediationRecord(reqDTO);
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return MediationRecordConvert.convertToMediationRecordSaveResponseDTO(resDTO);
    }

    @Override
    public MediationRecordGetResponseDTO viewMediationRecord(MediationRecordGetRequestDTO requestDTO) {
        MediationRecordGetReqDTO reqDTO = MediationRecordConvert.convertToMediationRecordGetReqDTO(requestDTO);
        MediationRecordGetResDTO resDTO = this.mediationRecordBackServiceImpl.viewMediationRecord(reqDTO);
        AssertUtils.assertNotNull((Object)resDTO, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)this.mastiffMessages.getResultIsNull());
        return MediationRecordConvert.convertToMediationRecordGetResponseDTO(resDTO);
    }
}

