/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.client.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.context.DataSourceContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.utils.AESUtil;
import com.beiming.odr.mastiff.common.utils.IpUtil;
import com.beiming.odr.mastiff.common.utils.TreeUtils;
import com.beiming.odr.mastiff.domain.dto.OrganizationDTO;
import com.beiming.odr.mastiff.domain.dto.ServicePersonListResponseDTO;
import com.beiming.odr.mastiff.domain.dto.thridparty.LoginTokenResponseDTO;
import com.beiming.odr.mastiff.domain.dto.thridparty.ThirdCertificateRequestDTO;
import com.beiming.odr.mastiff.domain.dto.thridparty.ThirdOrganizationListDTO;
import com.beiming.odr.mastiff.domain.dto.thridparty.ThirdOrganizationListRequestDTO;
import com.beiming.odr.mastiff.service.client.ThirdPartyService;
import com.beiming.odr.mastiff.service.enums.RedisKeyEnums;
import com.beiming.odr.referee.api.MediationInfoApi;
import com.beiming.odr.referee.api.ThirdPartApi;
import com.beiming.odr.referee.dto.ThirdPartMediationInfoTO;
import com.beiming.odr.referee.dto.responsedto.MediationCountResDTO;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.IUserActionLogServiceApi;
import com.beiming.odr.user.api.OrganizationServiceApi;
import com.beiming.odr.user.api.ServicePersonServiceApi;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.common.enums.ServicePersonStatusEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.UserActionLogDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.GetStaffPersonReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateGradeCountListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateGradeCountReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonNumberResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateGradeCountListResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateGradeCountResDTO;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ThirdPartyServiceImpl
implements ThirdPartyService {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyServiceImpl.class);
    @Resource
    private ThirdPartApi thirdPartApi;
    @Resource
    private OrganizationServiceApi organizationServiceApi;
    @Resource
    private RedisService redisService;
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private MediationInfoApi mediationInfoApi;
    @Resource
    private ServicePersonServiceApi servicePersonServiceApi;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private IUserActionLogServiceApi userActionLogServiceApi;

    @Override
    public ThirdPartMediationInfoTO query(Long caseId) {
        DubboResult result = this.thirdPartApi.queryCaseInfo(caseId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)"\u67e5\u8be2\u5931\u8d25");
        return (ThirdPartMediationInfoTO)result.getData();
    }

    @Override
    public PageInfo<ThirdOrganizationListDTO> getMediateOrganizationList(ThirdOrganizationListRequestDTO requestDTO) {
        OrganizationListReqDTO organizationListReqDTO = new OrganizationListReqDTO();
        organizationListReqDTO.setOrgName(requestDTO.getOrgName());
        if (requestDTO.getMediateCode() != null) {
            organizationListReqDTO.setMediateCode(requestDTO.getMediateCode().name());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{requestDTO.getDisputeTypeCode()}) && !requestDTO.getDisputeTypeCode().startsWith("PETITION_")) {
            organizationListReqDTO.setDisputeTypeCode(requestDTO.getDisputeTypeCode());
        }
        organizationListReqDTO.setDisputeAreaCode(requestDTO.getDisputeAreaCode());
        organizationListReqDTO.setExcludeOrgId(requestDTO.getExcludeOrgId());
        organizationListReqDTO.setPageIndex(requestDTO.getPageIndex());
        organizationListReqDTO.setPageSize(requestDTO.getPageSize());
        organizationListReqDTO.setOrgIds(requestDTO.getOrgIds());
        DubboResult result = this.organizationServiceApi.getMediateOrganizationListPage(organizationListReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
        AssertUtils.assertTrue((result.getData() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)APIResultCodeEnums.RESULT_EMPTY.desc());
        PageInfo pageInfo = (PageInfo)result.getData();
        List organizationResDTOs = pageInfo.getList();
        ArrayList<ThirdOrganizationListDTO> responseDTOs = new ArrayList<ThirdOrganizationListDTO>();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (OrganizationResDTO organizationResDTO : organizationResDTOs) {
            ThirdOrganizationListDTO responseDTO = new ThirdOrganizationListDTO(organizationResDTO);
            orgIds.add(responseDTO.getOrgId());
            responseDTOs.add(responseDTO);
        }
        return new PageInfo(responseDTOs, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }

    @Override
    public JSONArray selectNode() {
        ArrayList dictCaseReasonDTOS;
        String languageType = LocaleContextHolder.getLocale().toString();
        JSONArray jsonArray = (JSONArray)this.redisService.get((RedisKey)RedisKeyEnums.CASE_REASON, languageType);
        if (Objects.nonNull(jsonArray)) {
            return jsonArray;
        }
        DubboResult dubboResult = this.dictionaryServiceApi.selectNode(languageType);
        if (200 == dubboResult.getCode() && !CollectionUtils.isEmpty((Collection)(dictCaseReasonDTOS = (ArrayList)dubboResult.getData()))) {
            JSONArray s = JSONArray.parseArray((String)JSONArray.toJSONString((Object)dictCaseReasonDTOS));
            JSONArray array = TreeUtils.listToTree((JSONArray)s, (String)"value", (String)"parentCode", (String)"children");
            this.redisService.set((RedisKey)RedisKeyEnums.CASE_REASON, languageType, (Object)array, 8L, TimeUnit.HOURS);
            return array;
        }
        return new JSONArray();
    }

    @Override
    public PageInfo<OrganizationDTO> getOrganizationListToGs(OrganizationListReqDTO organizationListReqDTO) {
        organizationListReqDTO.setPageIndex(organizationListReqDTO.getPageIndex());
        organizationListReqDTO.setPageSize(organizationListReqDTO.getPageSize());
        DubboResult result = this.organizationServiceApi.getOrganizationListPage(organizationListReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
        AssertUtils.assertTrue((result.getData() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)APIResultCodeEnums.RESULT_EMPTY.desc());
        PageInfo pageInfo = (PageInfo)result.getData();
        List organizationResDTOs = pageInfo.getList();
        ArrayList<OrganizationDTO> responseDTOs = new ArrayList<OrganizationDTO>();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (OrganizationResDTO organizationResDTO : organizationResDTOs) {
            OrganizationDTO responseDTO = new OrganizationDTO(organizationResDTO);
            orgIds.add(responseDTO.getOrgId());
            responseDTOs.add(responseDTO);
        }
        ServicePersonNumberResDTO servicePersonNumberResDTO = this.getServicePersonNumber(orgIds);
        if (servicePersonNumberResDTO != null) {
            for (OrganizationDTO responseDTO : responseDTOs) {
                responseDTO.setMediatorNumber((Integer)servicePersonNumberResDTO.getMediatorNumbers().get(responseDTO.getOrgId()));
                responseDTO.setCounselorNumber((Integer)servicePersonNumberResDTO.getCounselorNumbers().get(responseDTO.getOrgId()));
                responseDTO.setJudgeNumber((Integer)servicePersonNumberResDTO.getJudgeNumbers().get(responseDTO.getOrgId()));
            }
        }
        return new PageInfo(responseDTOs, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }

    private ServicePersonNumberResDTO getServicePersonNumber(List<Long> orgIds) {
        DubboResult servicePersonNumberResult = this.organizationServiceApi.getServicePersonNumber(orgIds);
        AssertUtils.assertTrue((boolean)servicePersonNumberResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
        if (servicePersonNumberResult.isSuccess() && servicePersonNumberResult.getData() != null) {
            return (ServicePersonNumberResDTO)servicePersonNumberResult.getData();
        }
        return null;
    }

    @Override
    public PageInfo<ServicePersonListResponseDTO> getServicePersonListPageToGs(ServicePersonListReqDTO servicePersonListReqDTO) {
        servicePersonListReqDTO.setPageIndex(servicePersonListReqDTO.getPageIndex());
        servicePersonListReqDTO.setPageSize(servicePersonListReqDTO.getPageSize());
        PageInfo<ServicePersonListResDTO> pageInfo = this.getServicePersonListPage(servicePersonListReqDTO);
        List servicePersonListResDTOs = pageInfo.getList();
        ArrayList<ServicePersonListResponseDTO> responseDTOs = new ArrayList<ServicePersonListResponseDTO>();
        ArrayList<UserEvaluateGradeCountReqDTO> evaluateGradeReqDTOs = new ArrayList<UserEvaluateGradeCountReqDTO>();
        ArrayList<Long> mediatorIds = new ArrayList<Long>();
        for (ServicePersonListResDTO servicePersonListResDTO : servicePersonListResDTOs) {
            ServicePersonListResponseDTO servicePersonListResponseDTO = new ServicePersonListResponseDTO(servicePersonListResDTO);
            UserEvaluateGradeCountReqDTO userEvaluateGradeCountReqDTO = new UserEvaluateGradeCountReqDTO();
            userEvaluateGradeCountReqDTO.setUserId(servicePersonListResponseDTO.getUserId());
            userEvaluateGradeCountReqDTO.setRoleType(RoleTypeEnum.MEDIATOR.name());
            evaluateGradeReqDTOs.add(userEvaluateGradeCountReqDTO);
            mediatorIds.add(servicePersonListResDTO.getUserId());
            responseDTOs.add(servicePersonListResponseDTO);
        }
        UserEvaluateGradeCountListReqDTO evaluateGradeListReqDTO = new UserEvaluateGradeCountListReqDTO();
        evaluateGradeListReqDTO.setUserEvaluateGradeCountReqDTOs(evaluateGradeReqDTOs);
        DubboResult evaluateResult = this.servicePersonServiceApi.getUserEvaluateGradeCountListToGs(evaluateGradeListReqDTO);
        AssertUtils.assertTrue((boolean)evaluateResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
        AssertUtils.assertTrue((evaluateResult.getData() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)APIResultCodeEnums.RESULT_EMPTY.desc());
        HashMap notEndMap = null;
        HashMap endMap = null;
        if (!CollectionUtils.isEmpty(mediatorIds)) {
            DubboResult mediationNumResult = this.mediationInfoApi.countMediatorLawCaseNum(mediatorIds);
            AssertUtils.assertTrue((boolean)mediationNumResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
            AssertUtils.assertTrue((mediationNumResult.getData() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)APIResultCodeEnums.RESULT_EMPTY.desc());
            notEndMap = new HashMap();
            for (Map.Entry entry : ((MediationCountResDTO)mediationNumResult.getData()).getNotEndMap().entrySet()) {
                notEndMap.put(entry.getKey(), Integer.valueOf(((Long)entry.getValue()).toString()));
            }
            endMap = new HashMap();
            for (Map.Entry entry : ((MediationCountResDTO)mediationNumResult.getData()).getEndMap().entrySet()) {
                endMap.put(entry.getKey(), Integer.valueOf(((Long)entry.getValue()).toString()));
            }
        }
        block3: for (ServicePersonListResponseDTO servicePersonListResponseDTO : responseDTOs) {
            for (UserEvaluateGradeCountResDTO gradeCountResDTO : ((UserEvaluateGradeCountListResDTO)evaluateResult.getData()).getUserEvaluateGrades()) {
                if (!servicePersonListResponseDTO.getUserId().equals(gradeCountResDTO.getUserId())) continue;
                servicePersonListResponseDTO.setStarLevel(gradeCountResDTO.getGradeNumber());
                servicePersonListResponseDTO.setEvaluateNumber(gradeCountResDTO.getEvaluateNumber());
                break;
            }
            if (CollectionUtils.isEmpty(notEndMap) || CollectionUtils.isEmpty(endMap)) continue;
            for (String key : notEndMap.keySet()) {
                if (!servicePersonListResponseDTO.getUserId().toString().equals(key)) continue;
                servicePersonListResponseDTO.setDisputeNumber(Integer.valueOf((Integer)notEndMap.get(key) + (Integer)endMap.get(key)));
                servicePersonListResponseDTO.setEndDisputeNumber((Integer)endMap.get(key));
                servicePersonListResponseDTO.setNotEndDisputeNumber((Integer)notEndMap.get(key));
                continue block3;
            }
        }
        return new PageInfo(responseDTOs, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }

    @Override
    public LoginInfoResDTO obtainCertificate(String params, HttpServletRequest request) {
        String appname;
        log.info("===============params=========================" + params);
        String token = request.getHeader("token");
        log.info("===============token=========================" + token);
        params = params.replace(' ', '+');
        ThirdCertificateRequestDTO thirdCertificateRequestDTO = (ThirdCertificateRequestDTO)JSONObject.parseObject((String)AESUtil.decrypt((String)params, (String)"hngs@*HLWKT#2024"), ThirdCertificateRequestDTO.class);
        this.checkThirdCertificate(thirdCertificateRequestDTO);
        if (!"COMMON".equals(thirdCertificateRequestDTO.getPersonType())) {
            DubboResult organizationDetail = this.organizationServiceApi.getOrganizationDetail(Long.valueOf(thirdCertificateRequestDTO.getOrgId()));
            AssertUtils.assertTrue((boolean)organizationDetail.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)organizationDetail.getMessage());
        }
        if (StringUtils.isBlank((String)(appname = request.getHeader("Appname")))) {
            appname = "hnswodr";
        }
        AppNameContextHolder.setAppName((String)appname);
        DataSourceContextHolder.setDBByAppName((String)appname);
        GetStaffPersonReqDTO getStaffPersonReqDTO = new GetStaffPersonReqDTO();
        getStaffPersonReqDTO.setUsername(thirdCertificateRequestDTO.getUserName());
        getStaffPersonReqDTO.setPersonType(thirdCertificateRequestDTO.getPersonType());
        getStaffPersonReqDTO.setMobilePhone(thirdCertificateRequestDTO.getMobilePhone());
        DubboResult personDubboResult = this.userServiceApi.selectUserByNameAndPhone(getStaffPersonReqDTO);
        AssertUtils.assertTrue((boolean)personDubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)personDubboResult.getMessage());
        ArrayList data = (ArrayList)personDubboResult.getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            PersonTypeEnum personTypeEnum = PersonTypeEnum.COMMON;
            personTypeEnum = "STAFF".equals(thirdCertificateRequestDTO.getPersonType()) ? PersonTypeEnum.STAFF : PersonTypeEnum.COMMON;
            ArrayList initRoleCode = new ArrayList();
            initRoleCode.add("COMMON");
            ArrayList roleCode = CollectionUtils.isEmpty((Collection)thirdCertificateRequestDTO.getRoleCode()) ? initRoleCode : thirdCertificateRequestDTO.getRoleCode();
            DubboResult booleanDubboResult = this.userServiceApi.checkUserByMobile(thirdCertificateRequestDTO.getMobilePhone(), personTypeEnum);
            AssertUtils.assertTrue((boolean)booleanDubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)booleanDubboResult.getMessage());
            Boolean bool = (Boolean)booleanDubboResult.getData();
            AssertUtils.assertFalse((boolean)Objects.equals(bool, Boolean.FALSE), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u4eba\u5728\u6d89\u5916\u6c11\u5546\u4e8b\u6cd5\u5ead\u6848\u4ef6\u591a\u5143\u5316\u89e3\u5e73\u53f0\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u5b9e\u662f\u5426\u662f\u672c\u4eba");
            DubboResult result = this.userServiceApi.thirdRegisterByMobile(thirdCertificateRequestDTO.getPersonType(), thirdCertificateRequestDTO.getMobilePhone(), thirdCertificateRequestDTO.getUserName(), "HAINAN_THIRD_DOCK", thirdCertificateRequestDTO.getOrgId(), thirdCertificateRequestDTO.getOrgName(), roleCode);
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u4eba\u5458\u5bf9\u63a5\u65b0\u589e\u5931\u8d25");
        }
        UserLoginTypeEnum loginTypeEnum = "STAFF".equals(thirdCertificateRequestDTO.getPersonType()) ? UserLoginTypeEnum.WORK_USER_LOGIN_TYPE : UserLoginTypeEnum.COMMON_USER_LOGIN_TYPE;
        DubboResult result = this.userServiceApi.userLogin(thirdCertificateRequestDTO.getMobilePhone(), null, null, loginTypeEnum);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        LoginInfoResDTO data1 = (LoginInfoResDTO)result.getData();
        UserInfoDTO userInfo = data1.getUserInfo();
        if (userInfo != null && UserLoginTypeEnum.WORK_USER_LOGIN_TYPE.equals((Object)loginTypeEnum)) {
            String redisKey = Joiner.on((String)"_").join((Object)"hnswodr", (Object)"user", new Object[]{"SERVICE_PERSON_STATUS"});
            Object obj = this.redisTemplate.opsForHash().get((Object)redisKey, (Object)userInfo.getUserId().toString());
            String servicePersonStatus = this.convertInstanceOfObject(obj, String.class);
            userInfo.setServicePersonStatus(StringUtils.isEmpty((String)servicePersonStatus) ? ServicePersonStatusEnum.ONLINE.name() : servicePersonStatus);
        }
        return data1;
    }

    @Override
    public void saveUserActionLog(LoginTokenResponseDTO token, String actionContent, HttpServletRequest request) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        UserActionLogDTO reqDTO = new UserActionLogDTO();
        LoginInfoResDTO loginInfo = token.getLoginInfo();
        reqDTO.setUserId(loginInfo.getUserInfo().getUserId());
        reqDTO.setUsername(loginInfo.getUserInfo().getUserName());
        reqDTO.setLoginname(loginInfo.getUserInfo().getMobilePhone());
        reqDTO.setClientIp(IpUtil.getCliectIp((HttpServletRequest)httpServletRequest));
        reqDTO.setServiceIp(httpServletRequest.getRemoteAddr());
        reqDTO.setActionContent(actionContent);
        reqDTO.setActionCode("LOGIN");
        reqDTO.setActionName("\u767b\u5f55");
        reqDTO.setActionResult("SUCCESS");
        String orgName = null;
        Long orgId = null;
        DubboResult userResult = this.userServiceApi.getUserLoginInfo(JWTContextUtil.getCurrentUserId());
        List userRoles = ((LoginInfoResDTO)userResult.getData()).getUserRoles();
        if (userRoles.size() > 0 && !"COMMON".equals(((UserRoleInfoDTO)userRoles.get(0)).getRoleType())) {
            orgId = ((UserRoleInfoDTO)userRoles.get(0)).getOrganizationId();
            orgName = ((UserRoleInfoDTO)userRoles.get(0)).getOrganizationName();
        }
        reqDTO.setOrgId(orgId);
        reqDTO.setOrgName(orgName);
        DubboResult result = this.userActionLogServiceApi.insert(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    private PageInfo<ServicePersonListResDTO> getServicePersonListPage(ServicePersonListReqDTO servicePersonListReqDTO) {
        DubboResult result = this.userServiceApi.getServicePersonListPage(servicePersonListReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)APIResultCodeEnums.UNEXCEPTED.desc());
        AssertUtils.assertTrue((result.getData() != null ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.RESULT_EMPTY, (String)APIResultCodeEnums.RESULT_EMPTY.desc());
        PageInfo pageInfo = (PageInfo)result.getData();
        return pageInfo;
    }

    private void checkThirdCertificate(ThirdCertificateRequestDTO thirdCertificateRequestDTO) {
        ArrayList<String> errorList = new ArrayList<String>();
        String userName = thirdCertificateRequestDTO.getUserName();
        String mobilePhone = thirdCertificateRequestDTO.getMobilePhone();
        String sex = thirdCertificateRequestDTO.getSex();
        String orgId = thirdCertificateRequestDTO.getOrgId();
        String orgName = thirdCertificateRequestDTO.getOrgName();
        String personType = thirdCertificateRequestDTO.getPersonType();
        ArrayList roleCode = thirdCertificateRequestDTO.getRoleCode();
        if (StringUtils.isBlank((String)userName)) {
            errorList.add("\u5f53\u4e8b\u4eba\u6216\u8005\u6cd5\u5b98\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)mobilePhone)) {
            errorList.add("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)personType)) {
            errorList.add("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        } else if ("STAFF".equals(personType)) {
            if (StringUtils.isBlank((String)orgId)) {
                errorList.add("\u5de5\u4f5c\u4eba\u5458\u7684\u6cd5\u9662\u56db\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)orgName)) {
                errorList.add("\u5de5\u4f5c\u4eba\u5458\u7684\u6cd5\u9662\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)roleCode)) {
                errorList.add("\u5de5\u4f5c\u4eba\u5458\u7684\u7528\u6237\u89d2\u8272\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        AssertUtils.assertTrue((errorList.size() == 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)Joiner.on((String)",").join(errorList));
    }

    private <T> T convertInstanceOfObject(Object o, Class<T> clazz) {
        if (o == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            throw new RuntimeException(String.format("[Redis Error] except type %s but %s", clazz.getName(), o.getClass()));
        }
        return clazz.cast(o);
    }
}

