/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.thirty.tdh.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.PlatformEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.LawTemporaryAgentRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationYtCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationYtCaseRequestV2DTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.PartyAgentFilesRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseResponseDTO;
import com.beiming.odr.mastiff.service.backend.referee.CaseDubboService;
import com.beiming.odr.mastiff.service.backend.referee.convert.MediationCaseConvert;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.thirty.tdh.PullTdhService;
import com.beiming.odr.mastiff.service.thirty.tdh.impl.ThirdPartyCaseReqConverter;
import com.beiming.odr.mastiff.service.utils.RedisSequenceFactory;
import com.beiming.odr.referee.api.MediationCaseApi;
import com.beiming.odr.referee.dto.MediationCaseBaseDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseAgentReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationTdhCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationTdhCaseUserReqDTO;
import com.beiming.odr.referee.enums.AgentTypeEnum;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PullTdhServiceImpl
implements PullTdhService {
    @Resource
    private ThirdPartyCaseReqConverter thirdPartyCaseReqConverter;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private RedisSequenceFactory redisSequenceFactory;
    @Resource
    private CaseDubboService caseDubboService;
    @Resource
    private MediationCaseApi mediationCaseApi;
    @Resource
    private MastiffMessages mastiffMessages;

    @Override
    public Object ytCase(MediationYtCaseRequestDTO ytdto) {
        return null;
    }

    private void getTbsqAgent(SaveCaseUserRequestDTO saveApplyCaseUserRequestDTO, List<LawTemporaryAgentRequestDTO> listAgent) {
        for (int t = 0; t < listAgent.size(); ++t) {
            if (listAgent.get(t).getWtqx() == null || !listAgent.get(t).getWtqx().equals((Object)AgentTypeEnum.PRIVILEGE_AGENT)) continue;
            saveApplyCaseUserRequestDTO.setAgentFileName(listAgent.get(t).getWtsqsmc());
            saveApplyCaseUserRequestDTO.setAgentIdCard(listAgent.get(t).getZjhm());
            saveApplyCaseUserRequestDTO.setAgentName(listAgent.get(t).getDlrxm());
            saveApplyCaseUserRequestDTO.setCiteAgentId(String.valueOf(listAgent.get(t).getDlrxh()));
            saveApplyCaseUserRequestDTO.setAgentPhone(listAgent.get(t).getSjhm());
            saveApplyCaseUserRequestDTO.setAgentSex(listAgent.get(t).getAgentSex());
            saveApplyCaseUserRequestDTO.setAgentUserType(AgentTypeEnum.PRIVILEGE_AGENT);
            PartyAgentFilesRequestDTO partyAgentFiles = new PartyAgentFilesRequestDTO();
            partyAgentFiles.setEvidenceName(listAgent.get(t).getWtsqsmc());
            partyAgentFiles.setEvidenceStream(listAgent.get(t).getWtsqsst());
            saveApplyCaseUserRequestDTO.setPartyAgentFiles(partyAgentFiles);
        }
    }

    private void checkApplicantRequired(List<SaveCaseUserRequestDTO> list) {
        for (int j = 0; j < list.size(); ++j) {
            SaveCaseUserRequestDTO dto = list.get(j);
            int i = j + 1;
            dto.setCaseUserType(CaseUserTypeEnum.APPLICANT);
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getUserName()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + i + "\u540d\u79f0\u4e3a\u7a7a"));
            AssertUtils.assertFalse((StringUtils.isBlank((String)dto.getPhone()) && StringUtils.isBlank((String)dto.getTelephone()) ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u624b\u673a\u53f7\u4e3a\u7a7a"));
            if (!StringUtils.isNotBlank((CharSequence)dto.getPhone())) continue;
            AssertUtils.assertTrue((boolean)dto.getPhone().matches("^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$"), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u7533\u8bf7\u4eba" + dto.getUserName() + "\u4fe1\u606f\u4e2d\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e"));
        }
    }

    private void checkRespondentRequired(List<SaveCaseUserRequestDTO> list) {
        for (int j = 0; j < list.size(); ++j) {
            SaveCaseUserRequestDTO dto = list.get(j);
            int i = j + 1;
            dto.setCaseUserType(CaseUserTypeEnum.RESPONDENT);
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getUserName()), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)("\u88ab\u7533\u8bf7\u4eba" + i + "\u540d\u79f0\u4e3a\u7a7a"));
        }
    }

    private boolean checkAddress(SaveCaseUserRequestDTO req) {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)req.getProvCode()) && StringUtils.isNotBlank((CharSequence)req.getCityCode()) && StringUtils.isNotBlank((CharSequence)req.getAreaCode()) && StringUtils.isNotBlank((CharSequence)req.getStreetCode()) && StringUtils.isNotBlank((CharSequence)req.getProvName()) && StringUtils.isNotBlank((CharSequence)req.getCityName()) && StringUtils.isNotBlank((CharSequence)req.getAreaName()) && StringUtils.isNotBlank((CharSequence)req.getStreetName())) {
            flag = true;
        }
        return flag;
    }

    @Override
    public MediationCaseResponseDTO saveCase(MediationYtCaseRequestV2DTO request) {
        MediationCaseResponseDTO response = new MediationCaseResponseDTO();
        MediationTdhCaseReqDTO convert = this.thirdPartyCaseReqConverter.convert(request);
        DubboResult mediationCaseDubboResult = this.mediationCaseApi.getMediationByCiteCaseId(request.getCiteCaseId());
        if (!mediationCaseDubboResult.isSuccess()) {
            // empty if block
        }
        MediationCaseBaseDTO data = (MediationCaseBaseDTO)mediationCaseDubboResult.getData();
        this.insertUserNotExist(convert.getPersonnelList());
        if (null != data) {
            convert.setLawCaseId(data.getId());
            this.caseDubboService.updateApprovalCase(convert);
            return new MediationCaseResponseDTO(data.getId(), "", data.getOrgId(), data.getOrgName(), "");
        }
        convert.setOrigin(PlatformEnums.MASTIFF_API.name());
        convert.setLawCaseStatus(CaseStatusEnum.APPLY_SUBMIT.name());
        convert.setCaseProgress(CaseProgressEnum.APPLY.name());
        String caseNo = this.getCaseNo();
        convert.setCaseNo(caseNo);
        convert.setSmsOff(Boolean.valueOf(false));
        Long caseId = this.caseDubboService.insertYtMediationCase(convert);
        AssertUtils.assertNotNull((Object)caseId, (ResultCode)ErrorCode.SUBMIT_CASE_FAIL, (String)this.mastiffMessages.getSubmitCaseFail());
        response.setCaseId(caseId);
        return response;
    }

    private void insertUserNotExist(List<MediationTdhCaseUserReqDTO> parties) {
        parties.stream().filter(party -> StringUtils.isNotBlank((CharSequence)party.getPhone())).forEach(party -> this.caseUserRegister((MediationTdhCaseUserReqDTO)party));
    }

    private void caseUserRegister(MediationTdhCaseUserReqDTO dto) {
        String prefixMsg = "";
        String userName = "";
        switch (dto.getUserType()) {
            case "NATURAL_PERSON": {
                prefixMsg = CaseUserTypeEnum.valueOf((String)dto.getCaseUserType()).getName();
                userName = dto.getName();
                break;
            }
            case "JURIDICAL_PERSON": {
                prefixMsg = CaseUserTypeEnum.valueOf((String)dto.getCaseUserType()).getName() + "\u6cd5\u5b9a\u4ee3\u8868\u4eba";
                userName = dto.getCorporation();
                break;
            }
            case "UNINCORPORATED_ORGANIZATION": {
                prefixMsg = CaseUserTypeEnum.valueOf((String)dto.getCaseUserType()).getName() + "\u673a\u6784\u4ee3\u8868\u4eba";
                userName = dto.getCorporation();
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getPhone())) {
            CaseUserRegisterReqDTO user = MediationCaseConvert.getCaseUserRegisterReqDTO(dto);
            DubboResult<CaseUserRegisterResDTO> dubboResult = this.userDubboService.caseUserRegister(user);
            if (!dubboResult.isSuccess() && (dto.getCaseUserType().equals(CaseUserTypeEnum.APPLICANT) || dto.getCaseUserType().equals(CaseUserTypeEnum.RESPONDENT))) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)(prefixMsg + user.getUserName() + dubboResult.getMessage()));
            }
            CaseUserRegisterResDTO data = (CaseUserRegisterResDTO)dubboResult.getData();
            dto.setId(data.getUserId());
            List agents = dto.getAgents();
            if (CollectionUtils.isNotEmpty((Collection)agents)) {
                for (LawCaseAgentReqDTO agent : agents) {
                    CaseUserRegisterReqDTO agentReq = new CaseUserRegisterReqDTO();
                    agentReq.setUserName(agent.getAgentName());
                    agentReq.setMobilePhone(agent.getPhone());
                    agentReq.setIdCard(agent.getAgentIdCard());
                    agentReq.setPassword("Aa@123456");
                    agentReq.setDetailedAddress(agent.getAddress());
                    DubboResult<CaseUserRegisterResDTO> dubboResultAgent = this.userDubboService.caseUserRegister(agentReq);
                    AssertUtils.assertTrue((boolean)dubboResultAgent.isSuccess(), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)(prefixMsg + "\u4ee3\u7406\u4eba" + agent.getAgentName() + dubboResultAgent.getMessage()));
                    CaseUserRegisterResDTO agentResDTO = (CaseUserRegisterResDTO)dubboResultAgent.getData();
                    agent.setAgentId(agentResDTO.getUserId());
                }
            }
        }
    }

    public String getCaseNo() {
        long sequence = 0L;
        try {
            sequence = this.redisSequenceFactory.generate("caseno_Sequence");
        }
        catch (Exception e) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            String date = Long.toHexString(calendar.getTimeInMillis()).toUpperCase();
            String freeRandom = String.valueOf((int)(Math.random() * 90.0) + 10);
            return date + freeRandom;
        }
        return String.format("\uff08%d\uff09\u591a\u5143\u5316\u89e3%d\u53f7", Calendar.getInstance().getWeekYear(), sequence);
    }
}

