/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.thirty.tdh.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.PushTdhRequestDTO;
import com.beiming.odr.mastiff.service.thirty.tdh.PushTdhService;
import com.beiming.odr.referee.api.ThirdPartyPushApi;
import com.beiming.odr.referee.dto.requestdto.sendtdh.JudgeOrMediationOrWithdrawOrSycnDubboReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.SycnCaseDubboReqDTO;
import com.beiming.odr.referee.enums.ThirdPartyInterfaceEnums;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PushTdhServiceImpl
implements PushTdhService {
    @Resource
    private ThirdPartyPushApi thirdPartyPushApi;

    @Override
    public void pushData(PushTdhRequestDTO requestDTO) {
        String type = requestDTO.getType();
        JudgeOrMediationOrWithdrawOrSycnDubboReqDTO reqDTO = new JudgeOrMediationOrWithdrawOrSycnDubboReqDTO();
        reqDTO.setCaseId(requestDTO.getCaseId());
        reqDTO.setUserId(requestDTO.getUserId());
        reqDTO.setUserName(requestDTO.getUserName());
        DubboResult result = null;
        if (ThirdPartyInterfaceEnums.PUSH_WITHDRAW_CASE_APPLY.getCode().equals(type)) {
            result = this.thirdPartyPushApi.withdrawMediation(reqDTO);
        } else if (ThirdPartyInterfaceEnums.PUSH_JUDICIAL_CONFIRMATION_APPLY.getCode().equals(type)) {
            result = this.thirdPartyPushApi.applyJudgeConfirmation(reqDTO);
        } else if (ThirdPartyInterfaceEnums.PUSH_MEDIATION_BOOK_APPLY.getCode().equals(type)) {
            result = this.thirdPartyPushApi.applyMediationBook(reqDTO);
        } else if (ThirdPartyInterfaceEnums.PUSH_CASE_SUCCESS_SYNC.getCode().equals(type)) {
            SycnCaseDubboReqDTO sycnCaseDubboReqDTO = new SycnCaseDubboReqDTO();
            sycnCaseDubboReqDTO.setCaseId(requestDTO.getCaseId());
            sycnCaseDubboReqDTO.setUserId(requestDTO.getUserId());
            sycnCaseDubboReqDTO.setUserName(requestDTO.getUserName());
            sycnCaseDubboReqDTO.setCaseStatusEnum(requestDTO.getCaseStatusEnum());
            sycnCaseDubboReqDTO.setCiteCaseId(requestDTO.getCiteCaseId());
            sycnCaseDubboReqDTO.setCloseType(requestDTO.getCloseType());
            result = this.thirdPartyPushApi.syncMediationSuccessOrFailStatus(sycnCaseDubboReqDTO);
        }
        AssertUtils.assertTrue((null != result && result.isSuccess() ? 1 : 0) != 0, (ResultCode)DubboResultCodeEnums.INTERNAL_ERROR, (String)result.getMessage());
    }
}

