/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.service.thirty.tdh.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.consultancy.enums.DisputeTypeEnum;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationYtCaseRequestV2DTO;
import com.beiming.odr.mastiff.service.thirty.tdh.TDHCodeCacheService;
import com.beiming.odr.referee.dto.requestdto.LawCaseAgentReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationTdhCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationTdhCaseUserReqDTO;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class ThirdPartyCaseReqConverter {
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    TDHCodeCacheService tdhCodeCacheService;

    public MediationTdhCaseReqDTO convert(MediationYtCaseRequestV2DTO request) {
        MediationTdhCaseReqDTO result = new MediationTdhCaseReqDTO();
        BeanUtils.copyProperties((Object)request, (Object)result);
        result.setOrgId(Long.valueOf(request.getOrgId()));
        DubboResult dictionaryInfoDTODubboResult = this.dictionaryServiceApi.searchDictionary(Long.valueOf(request.getCause()));
        if (dictionaryInfoDTODubboResult.isSuccess()) {
            DictionaryInfoDTO data = (DictionaryInfoDTO)dictionaryInfoDTODubboResult.getData();
            result.setDisputeTypeCode(data.getParentCode());
            result.setDisputeType(data.getName());
            result.setDisputesId(Long.valueOf(request.getCause()));
        } else {
            result.setDisputesId(Long.valueOf(request.getCause()));
            result.setDisputeTypeCode(DisputeTypeEnum.OTHER_DISPUTES.name());
            result.setDisputeType(DisputeTypeEnum.OTHER_DISPUTES.getName());
        }
        result.setCreatorType(UserRoleEnum.COMMON);
        result.setMediationType(MediationTypeEnum.PEOPLE_MEDIATION.name());
        List parties = request.getParties();
        List convertParties = parties.stream().map(party -> {
            party.setCaseUserType((String)this.tdhCodeCacheService.getCacheValueByTHDCode(party.getCaseUserType()));
            party.setCardType((String)this.tdhCodeCacheService.getCacheValueByTHDCode(party.getCardType()));
            party.setSex((String)this.tdhCodeCacheService.getCacheValueByTHDCode(party.getSex()));
            party.setNation((String)this.tdhCodeCacheService.getCacheValueByTHDCode(party.getNation()));
            party.setUserType((String)this.tdhCodeCacheService.getCacheValueByTHDCode(party.getUserType()));
            if (UserTypeEnum.JURIDICAL_PERSON.name().equals(party.getUserType())) {
                party.setCreditCode(party.getIdCard());
                party.setIdCard("");
            }
            List agents = party.getAgents();
            List agentReqDTOS = agents.stream().map(agent -> {
                LawCaseAgentReqDTO agentReqDTO = new LawCaseAgentReqDTO();
                agentReqDTO.setPartyId(party.getCitePartyId());
                agentReqDTO.setAgentName(agent.getAgentName());
                agentReqDTO.setCiteAgentId(agent.getCiteAgentId());
                agentReqDTO.setPhone(agent.getPhone());
                agentReqDTO.setAddress(agent.getAddress());
                agentReqDTO.setAgentIdCard(agent.getAgentIdCard());
                return agentReqDTO;
            }).collect(Collectors.toList());
            MediationTdhCaseUserReqDTO user = new MediationTdhCaseUserReqDTO();
            BeanUtils.copyProperties((Object)party, (Object)user);
            user.setAgents(agentReqDTOS);
            return user;
        }).collect(Collectors.toList());
        result.setPersonnelList(convertParties);
        return result;
    }
}

