/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.aspect;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.log.RequestMethodInfo;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
public class HttpRequestLoggerAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"HTTP_LOG");
    private static final String CRLF = "\r\n";

    @Around(value="@annotation(requestMapping)")
    public Object disPlayRequestInfo(ProceedingJoinPoint point, RequestMapping requestMapping) throws Throwable {
        return this.doLog(point, LOGGER);
    }

    protected Object doLog(ProceedingJoinPoint point, Logger logger) throws Throwable {
        String className = null;
        String methodName = null;
        Method method = null;
        String paramLog = null;
        try {
            Signature signature = point.getSignature();
            Object[] args = point.getArgs();
            MethodSignature methodSignature = null;
            boolean hasResult = false;
            if (!(signature instanceof MethodSignature)) {
                return point.proceed();
            }
            methodSignature = (MethodSignature)signature;
            method = methodSignature.getMethod();
            methodName = method.getName();
            className = method.getDeclaringClass().getName();
            hasResult = methodSignature.getReturnType() != Void.TYPE && methodSignature.getReturnType() != Void.class;
            long startTime = System.currentTimeMillis();
            RequestMethodInfo requestInfo = this.getRequestInfo(methodSignature, args, logger);
            paramLog = this.getLogMessage(requestInfo);
            if (requestInfo.isDoInfoLog()) {
                logger.info(paramLog);
            }
            Object resultObject = null;
            if (hasResult) {
                resultObject = point.proceed();
            } else {
                point.proceed();
            }
            long endTime = System.currentTimeMillis();
            long spendTime = endTime - startTime;
            String timeMessage = className + "." + methodName + " spend time " + spendTime + " ms";
            if (spendTime < 10L) {
                logger.debug(timeMessage);
            } else if (spendTime < 50L) {
                logger.info(timeMessage);
            } else {
                logger.error(timeMessage);
            }
            return resultObject;
        }
        catch (Throwable e) {
            if (paramLog != null) {
                logger.error("\u6267\u884c\u5982\u4e0b\u64cd\u4f5c\u5931\u8d25\uff0c\u65b9\u6cd5\u4ee5\u53ca\u53c2\u6570\u4e3a\uff1a===============================");
                logger.error(paramLog);
                logger.error("\u5177\u4f53\u9519\u8bef\u5982\u4e0b\uff1a\uff1a===============================");
                logger.error("========", e);
            } else if (className != null && methodName != null) {
                logger.error("Invoke method:" + className + "." + methodName + " error");
            } else {
                logger.error("Invoke method error");
            }
            throw e;
        }
    }

    private String getLogMessage(RequestMethodInfo requestInfo) {
        StringBuilder sb = new StringBuilder();
        if (requestInfo != null) {
            Map map;
            Map requestParams;
            Map otherParams;
            sb.append("method:" + requestInfo.getClassName() + "." + requestInfo.getMethodString() + CRLF);
            if (requestInfo.getRequestMapping() != null) {
                sb.append("  requestMapping:" + requestInfo.getRequestMapping() + CRLF);
            }
            if ((otherParams = requestInfo.getOtherParams()) != null) {
                sb.append("  params =============================================\r\n");
                for (Map.Entry entry : otherParams.entrySet()) {
                    sb.append("  key: [" + (String)entry.getKey() + "], value :[" + (String)entry.getValue() + "]" + CRLF);
                }
            }
            if ((requestParams = requestInfo.getRequestParams()) != null) {
                sb.append(" httpRequestParams ====================================\r\n");
                for (Map.Entry entry : requestParams.entrySet()) {
                    sb.append("  key: [" + (String)entry.getKey() + "], value :[" + (String)entry.getValue() + "]" + CRLF);
                }
            }
            if ((map = requestInfo.getRequestHeaderParams()) != null) {
                sb.append(" requestHeaderParams ====================================\r\n");
                for (Map.Entry paramEntry : map.entrySet()) {
                    sb.append("  key: [" + (String)paramEntry.getKey() + "], value :[" + (String)paramEntry.getValue() + "]" + CRLF);
                }
            }
        }
        return sb.toString();
    }

    private RequestMethodInfo getRequestInfo(MethodSignature methodSignature, Object[] args, Logger logger) {
        RequestMapping requestMapping;
        RequestMethodInfo requestInfo = new RequestMethodInfo();
        Class[] parameterTypes = methodSignature.getParameterTypes();
        Method method = methodSignature.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        Class<?> clazz = method.getDeclaringClass();
        RequestMapping clazzRequestMapping = clazz.getAnnotation(RequestMapping.class);
        StringBuilder requestMappingStr = new StringBuilder();
        if (clazzRequestMapping != null) {
            requestMappingStr.append(Joiner.on((String)"|").join((Object[])clazzRequestMapping.value()));
        }
        if ((requestMapping = method.getAnnotation(RequestMapping.class)) != null && requestMapping.value() != null) {
            String[] mappingStrArray;
            for (String mapping : mappingStrArray = requestMapping.value()) {
                if (mapping == null) continue;
                mapping = mapping.startsWith("/") ? mapping : "/" + mapping;
                requestMappingStr.append(mapping);
            }
            requestInfo.setRequestMapping(requestMappingStr.toString());
        }
        requestInfo.setClassName(className);
        requestInfo.setMethodName(methodName);
        LocalVariableTableParameterNameDiscoverer paramNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
        String[] paramNames = paramNameDiscoverer.getParameterNames(methodSignature.getMethod());
        try {
            StringBuilder methodSb = new StringBuilder();
            methodSb.append(methodName + "(");
            if (parameterTypes != null && parameterTypes.length > 0) {
                HashMap paramMap = Maps.newHashMap();
                int paramLength = parameterTypes.length;
                for (int i = 0; i < paramLength; ++i) {
                    Class type = parameterTypes[i];
                    Object arg = args[i];
                    if (arg == null) continue;
                    String paramName = null;
                    if (paramNames != null) {
                        paramName = paramNames[i];
                    }
                    if (paramName == null) {
                        paramName = "arg" + i;
                    }
                    methodSb.append(type.getSimpleName() + " " + paramName);
                    if (i < paramLength - 1) {
                        methodSb.append(", ");
                    }
                    Package argPackage = arg.getClass().getPackage();
                    String value = null;
                    if (arg instanceof HttpServletRequest) {
                        HashMap requestParamMap = Maps.newHashMap();
                        HttpServletRequest request = (HttpServletRequest)arg;
                        Enumeration requestParamNames = request.getParameterNames();
                        requestInfo.setRequestParams((Map)requestParamMap);
                        while (requestParamNames.hasMoreElements()) {
                            String requestParamName = (String)requestParamNames.nextElement();
                            String requestParamValue = request.getParameter(requestParamName);
                            requestParamMap.put(requestParamName, requestParamValue);
                        }
                        HashMap requestHeaderNamesMap = Maps.newHashMap();
                        Enumeration requestHeaderNames = request.getHeaderNames();
                        requestInfo.setRequestHeaderParams((Map)requestHeaderNamesMap);
                        while (requestHeaderNames.hasMoreElements()) {
                            String requestHeadName = (String)requestHeaderNames.nextElement();
                            String requestHeadValue = request.getHeader(requestHeadName);
                            requestHeaderNamesMap.put(requestHeadName, requestHeadValue);
                        }
                    } else {
                        if (arg instanceof HttpServletResponse) continue;
                        if (arg instanceof String) {
                            value = (String)arg;
                        } else {
                            if (arg instanceof MultipartFile || argPackage != null && argPackage.getName().contains("org.springframework")) continue;
                            value = JSONObject.toJSONString((Object)arg);
                        }
                    }
                    paramMap.put(paramName, value);
                    requestInfo.setOtherParams((Map)paramMap);
                }
            }
            methodSb.append(")");
            requestInfo.setMethodString(methodSb.toString());
            return requestInfo;
        }
        catch (Throwable t) {
            throw new RuntimeException("logger " + className + "." + methodName + ";args:" + Arrays.toString(args) + "error", t);
        }
    }
}

