/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageQuery;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseMeetingIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseMeetingInviteRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseMeetingSaveRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetCodeQrRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.GetTokenRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.InviteCodeRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.LawAttachmentUpFileRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MeetingEmotionRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MeetingNewSaveRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.UptateEndReqDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.InviteWatchResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MeetingEmotionResponseDTO;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.CaseMeetingService;
import com.beiming.odr.mastiff.service.client.EmotionService;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingPersonnelResDTO;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="\u9884\u7ea6\u4f1a\u8baecontroller", tags={"\u9884\u7ea6\u4f1a\u8baecontroller"})
@RequestMapping(value={"/mastiff/caseMeeting"})
public class CaseMeetingController {
    private static final Logger log = LoggerFactory.getLogger(CaseMeetingController.class);
    @Resource
    private CaseMeetingService caseMeetingService;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private EmotionService emotionService;

    @ApiOperation(value="\u4fdd\u5b58\u4f1a\u8bae\u8bb0\u5f55\u6001", notes="\u4fdd\u5b58\u4f1a\u8bae\u8bb0\u5f55")
    @RequestMapping(value={"/saveCaseMeeting"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult saveCaseMeeting(@RequestBody @Valid CaseMeetingSaveRequestDTO caseMeetingSaveReqDTO) {
        if (caseMeetingSaveReqDTO != null) {
            caseMeetingSaveReqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
            caseMeetingSaveReqDTO.setUserName(this.userDubboService.getUserNameByJWT());
        }
        String result = this.caseMeetingService.caseMeetingSave(caseMeetingSaveReqDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.UNEXCEPTED, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u89c6\u9891\u8bb0\u5f55", notes="\u89c6\u9891\u8bb0\u5f55")
    @RequestMapping(value={"/getVideoList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult getVideoList(@RequestBody @Valid CaseMeetingIdRequestDTO caseMeetingIdRequestDTO, @RequestHeader(value="cType") String cType) {
        return APIResult.success((Object)this.caseMeetingService.getVideo(caseMeetingIdRequestDTO, cType));
    }

    @ApiOperation(value="\u9080\u8bf7\u89c2\u6469\u4eba", notes="\u9080\u8bf7\u89c2\u6469\u4eba")
    @RequestMapping(value={"/inviteSendSms"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult inviteSendSms(@RequestBody @Valid CaseMeetingInviteRequestDTO caseMeetingInviteRequestDTO) {
        caseMeetingInviteRequestDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        String result = this.caseMeetingService.inviteSendSMS(caseMeetingInviteRequestDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.UNEXCEPTED, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u8c03\u89e3 \u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\uff0c\u7535\u5b50\u5377\u5b97", notes="\u8c03\u89e3 \u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\uff0c\u7535\u5b50\u5377\u5b97")
    @RequestMapping(value={"/saveUpFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult saveUpFiles(@RequestBody @Valid LawAttachmentUpFileRequestDTO lawAttachmentUpFileReqDTO) {
        if (lawAttachmentUpFileReqDTO != null) {
            lawAttachmentUpFileReqDTO.setUesrId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
            lawAttachmentUpFileReqDTO.setUserName(this.userDubboService.getUserNameByJWT());
        }
        String result = this.caseMeetingService.saveUpFile(lawAttachmentUpFileReqDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.UNEXCEPTED, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u540c\u8fc7\u6848\u4ef6id\u67e5\u8be2\u8c03\u89e3\u4f1a\u8bae\u8bb0\u5f55", notes="\u540c\u8fc7\u6848\u4ef6id\u67e5\u8be2\u8c03\u89e3\u4f1a\u8bae\u8bb0\u5f55")
    @RequestMapping(value={"/queryMeetingList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult queryMeetingList(@RequestBody @Valid CaseIdRequestDTO caseIdRequestDTO) {
        List list = this.caseMeetingService.queryCaseMeetingList(caseIdRequestDTO);
        if (!list.isEmpty()) {
            return APIResult.success((Object)this.emotionService.getJoinUser(list));
        }
        return APIResult.success((Object)list);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f1a\u8baeid\u66f4\u65b0\u5f00\u59cb\u65f6\u95f4", notes="\u901a\u8fc7\u4f1a\u8baeid\u66f4\u65b0\u5f00\u59cb\u65f6\u95f4")
    @RequestMapping(value={"/updateStart"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult updateStart(@RequestBody @Valid CaseMeetingIdRequestDTO caseMeetingIdRequestDTO) {
        String result = this.caseMeetingService.updateStart(caseMeetingIdRequestDTO);
        if (result != null) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.FAIL_DATABASE, (String)result);
        }
        return APIResult.success();
    }

    @ApiOperation(value="\u901a\u8fc7\u4f1a\u8baeid\u66f4\u65b0\u7ed3\u675f\u65f6\u95f4", notes="\u901a\u8fc7\u4f1a\u8baeid\u66f4\u65b0\u7ed3\u675f\u65f6\u95f4")
    @RequestMapping(value={"/updateEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult updateEnd(@RequestBody @Valid UptateEndReqDTO uptateEndReqDTO) {
        String result = this.caseMeetingService.updateEnd(uptateEndReqDTO, JWTContextUtil.getCurrentUserId(), this.userDubboService.getUserNameByJWT());
        if (result != null) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.FAIL_DATABASE, (String)result);
        }
        return APIResult.success();
    }

    @ApiOperation(value="\u8f93\u5165\u9080\u8bf7\u7801\u8fdb\u5165\u89c6\u9891", notes="\u8f93\u5165\u9080\u8bf7\u7801\u8fdb\u5165\u89c6\u9891")
    @RequestMapping(value={"/inviteWatch"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult inviteWatch(@RequestBody @Valid InviteCodeRequestDTO inviteCodeRequestDTO) {
        InviteWatchResponseDTO inviteWatchResponseDTO = this.caseMeetingService.inviteWatch(inviteCodeRequestDTO);
        return APIResult.success((Object)inviteWatchResponseDTO);
    }

    @ApiOperation(value="\u9996\u9875\u4f1a\u8bae\u63d0\u793a", notes="\u9996\u9875\u4f1a\u8bae\u63d0\u793a", response=CaseMeetingPersonnelResDTO.class)
    @RequestMapping(value={"/indexMeetingMessage"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult indexMeetingMessage() {
        CaseMeetingPersonnelResDTO meetingPersonnelResDTO = this.caseMeetingService.queryMeetingMessage(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        return APIResult.success((Object)meetingPersonnelResDTO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e8c\u7ef4\u7801", notes="\u83b7\u53d6\u4e8c\u7ef4\u7801")
    @RequestMapping(value={"/getCodeQr"}, method={RequestMethod.POST})
    @ResponseBody
    public void getCodeQr(HttpServletResponse response, @RequestBody @Valid GetCodeQrRequestDTO getCodeQrRequestDTO) {
        String meetingUrl = this.caseMeetingService.queryMeetingUrl(getCodeQrRequestDTO, JWTContextUtil.getCurrentUserId(), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNotNull((Object)meetingUrl, (ResultCode)ErrorCode.RESULT_IS_NULL, (String)meetingUrl);
        try {
            ServletOutputStream out = response.getOutputStream();
            response.setHeader("Content-Type", "image/png");
            HashMap<EncodeHintType, Object> config = new HashMap<EncodeHintType, Object>();
            config.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            config.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            config.put(EncodeHintType.MARGIN, 0);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(meetingUrl, BarcodeFormat.QR_CODE, 300, 300, config);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)out);
            log.info("\u4e8c\u7ef4\u7801\u751f\u6210\u5b8c\u6bd5\uff0c\u5df2\u7ecf\u8f93\u51fa\u5230\u9875\u9762\u4e2d\u3002");
        }
        catch (WriterException e) {
            log.error("showQRCode WriterException, {}", (Throwable)e);
        }
        catch (IOException e) {
            log.error("showQRCode IOException, {}", (Throwable)e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6token", notes="\u83b7\u53d6token", response=GetTokenRequestDTO.class)
    @RequestMapping(value={"/getToken"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult getToken(@RequestBody @Valid GetTokenRequestDTO getTokenRequestDTO) {
        return APIResult.success((Object)this.caseMeetingService.queryToken(getTokenRequestDTO));
    }

    @ApiOperation(value="\u4fdd\u5b58\u65b0\u4f1a\u8bae\u8bb0\u5f55", notes="\u4fdd\u5b58\u4f1a\u65b0\u8bae\u8bb0\u5f55")
    @RequestMapping(value={"/saveNewCaseMeeting"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult saveNewCaseMeeting(@RequestBody @Valid MeetingNewSaveRequestDTO meetingNewSaveRequestDTO) {
        if (meetingNewSaveRequestDTO != null) {
            meetingNewSaveRequestDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
            meetingNewSaveRequestDTO.setUserName(this.userDubboService.getUserNameByJWT());
        }
        String result = this.caseMeetingService.saveNewCaseMeeting(meetingNewSaveRequestDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.UNEXCEPTED, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u89c6\u9891\u60c5\u7eeamock", notes="\u89c6\u9891\u60c5\u7eea", responseContainer="list", response=MeetingEmotionResponseDTO.class)
    @RequestMapping(value={"/meetingEmotion"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult meetingEmotion(@RequestBody @Valid MeetingEmotionRequestDTO requestDTO) {
        return APIResult.success((Object)this.emotionService.meetingEmotion(requestDTO));
    }

    @ApiOperation(value="\u5df2\u9884\u7ea6\u89c6\u9891", notes="\u5df2\u9884\u7ea6\u89c6\u9891")
    @RequestMapping(value={"/bookedCaseMeetingList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult bookedCaseMeetingList(@RequestBody PageQuery pageQuery) {
        String userId = JWTContextUtil.getCurrentUserId();
        return APIResult.success((Object)this.caseMeetingService.bookedCaseMeetingList(userId, pageQuery));
    }
}

