/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.basic.storage.api.FileStorageApi;
import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.AppException;
import com.beiming.odr.mastiff.common.enums.DossierAttachmentTypeEnum;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuditLawDossierReqDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DelFileRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierAttachListRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierDownloadRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierFileRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierGenerateRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DossierListRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.LawDossierBackRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.LawProgressRequestDTO;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.LawCaseDossierService;
import com.beiming.odr.referee.api.LawCasePersonnelApi;
import com.beiming.odr.referee.dto.responsedto.DisplayDossierResDTO;
import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(value="\u5377\u5b97controller", tags={"\u5377\u5b97controller"})
@RequestMapping(value={"/mastiff/lawCaseDossier"})
public class LawCaseDossierController {
    private static final Logger log = LoggerFactory.getLogger(LawCaseDossierController.class);
    @Resource
    private LawCaseDossierService lawCaseDossierService;
    @Resource
    private FileStorageApi fileStorageApi;
    @Resource
    private LawCasePersonnelApi lawCasePersonnelApi;
    @Resource
    private UserDubboService userDubboService;

    @ApiOperation(value="\u901a\u8fc7\u6848\u4ef6id\u67e5\u8be2\u6848\u4ef6\u5bf9\u5e94\u6587\u4ef6", notes="\u901a\u8fc7\u6848\u4ef6id\u67e5\u8be2\u6848\u4ef6\u5bf9\u5e94\u6587\u4ef6")
    @RequestMapping(value={"/getLawAttachmentList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult getLawAttachmentList(@RequestBody @Valid DossierAttachListRequestDTO dossierAttachListRequestDTO) {
        return APIResult.success((Object)this.lawCaseDossierService.getLawAttachmentList(dossierAttachListRequestDTO));
    }

    @ApiOperation(value="\u901a\u8fc7\u6848\u4ef6id\u67e5\u8be2\u751f\u6210\u5377\u5b97", notes="\u901a\u8fc7\u6848\u4ef6id\u67e5\u8be2\u751f\u6210\u5377\u5b97")
    @RequestMapping(value={"/getGenerateFile"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult getGenerateFile(@RequestBody @Valid DossierGenerateRequestDTO dossierGenerateRequestDTO) {
        String dubboResult = this.lawCaseDossierService.getGenerateFile(dossierGenerateRequestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        if (StringUtils.isBlank((String)dubboResult)) {
            return APIResult.success();
        }
        return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)dubboResult);
    }

    @ApiOperation(value="\u5377\u5b97\u5217\u8868", notes="\u5377\u5b97\u5217\u8868")
    @RequestMapping(value={"/queryDossierList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult queryDossierList(@RequestBody @Valid DossierListRequestDTO dossierListRequestDTO) {
        return APIResult.success((Object)this.lawCaseDossierService.queryDossierList(dossierListRequestDTO));
    }

    @ApiOperation(value="\u5377\u5b97\u8fdb\u5ea6\u8be6\u60c5", notes="\u5377\u5b97\u8fdb\u5ea6\u8be6\u60c5")
    @RequestMapping(value={"/queryLawProgressList"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult queryLawProgressList(@RequestBody @Valid LawProgressRequestDTO lawProgressRequestDTO) {
        return APIResult.success((Object)this.lawCaseDossierService.queryLawProgressList(lawProgressRequestDTO));
    }

    @ApiOperation(value="\u5377\u5b97\u5ba1\u6838\u9000\u56de", notes="\u5377\u5b97\u5ba1\u6838\u9000\u56de")
    @RequestMapping(value={"/lawDossierBack"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult lawDossierBack(@RequestBody @Valid LawDossierBackRequestDTO lawDossierBackRequestDTO) {
        String result = this.lawCaseDossierService.lawDossierBack(lawDossierBackRequestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u63d0\u4ea4\u5377\u5b97\u5ba1\u6838", notes="\u63d0\u4ea4\u5377\u5b97\u5ba1\u6838")
    @RequestMapping(value={"/submitLawDossier"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult submitLawDossier(@RequestBody @Valid AuditLawDossierReqDTO caseIdRequestDTO) {
        String result = this.lawCaseDossierService.submitLawDossier(caseIdRequestDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.UNEXCEPTED, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u5377\u5b97\u5ba1\u6838\u901a\u8fc7", notes="\u5377\u5b97\u5ba1\u6838\u901a\u8fc7")
    @RequestMapping(value={"/auditLawDossier"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult auditLawDossier(@RequestBody @Valid CaseIdRequestDTO caseIdRequestDTO) {
        String result = this.lawCaseDossierService.auditLawDossier(caseIdRequestDTO, this.userDubboService.getUserNameByJWT(), Long.valueOf(JWTContextUtil.getCurrentUserId()));
        AssertUtils.assertNull((Object)result, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u64a4\u9500\u5377\u5b97\u4fe1\u606f", notes="\u64a4\u9500\u5377\u5b97\u4fe1\u606f")
    @RequestMapping(value={"/rejectDossier"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult rejectDossier(@RequestBody @Valid CaseIdRequestDTO caseIdRequestDTO) {
        String result = this.lawCaseDossierService.lawBackOutDossier(caseIdRequestDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u5377\u5b97\u6587\u4ef6\u4e0b\u8f7d", notes="\u5377\u5b97\u6587\u4ef6\u4e0b\u8f7d")
    @RequestMapping(value={"/dossierDownload"}, method={RequestMethod.POST, RequestMethod.GET})
    public APIResult dossierDownload(@Valid DossierDownloadRequestDTO dossierDownloadRequestDTO, HttpServletResponse response) throws IOException {
        dossierDownloadRequestDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        dossierDownloadRequestDTO.setRoles(JWTContextUtil.getRoles());
        response.setContentType("application/force-download");
        if (dossierDownloadRequestDTO.getCategoryMiddle() != null && dossierDownloadRequestDTO.getCategoryMiddle().equals(DossierAttachmentTypeEnum.LAW_CASE_DOSSIER_CATALOG.toString())) {
            XWPFDocument document = this.lawCaseDossierService.directoryContent(dossierDownloadRequestDTO);
            String filenameIso = new String("\u5377\u5185\u76ee\u5f55.doc".getBytes("UTF-8"), "ISO-8859-1");
            response.addHeader("Content-Disposition", "attachment;fileName=" + filenameIso);
            document.write((OutputStream)response.getOutputStream());
        } else if (dossierDownloadRequestDTO.getCategoryMiddle() != null && dossierDownloadRequestDTO.getCategoryMiddle().equals(DossierAttachmentTypeEnum.LAW_CASE_DOSSIER_BACKCOVER.toString())) {
            XWPFDocument document = this.lawCaseDossierService.finalTable(dossierDownloadRequestDTO);
            response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5377\u5b97\u5c01\u5e95.doc", "UTF-8"));
            Object fos = null;
            byte[] buffer = new byte[1024];
            Object fis = null;
            Object bis = null;
            document.write((OutputStream)response.getOutputStream());
        } else {
            List list;
            Long id = dossierDownloadRequestDTO.getId();
            if (id != null && !id.equals(0L)) {
                dossierDownloadRequestDTO.setFileId(null);
            }
            AssertUtils.assertTrue(((list = this.lawCaseDossierService.downloadFile(dossierDownloadRequestDTO)).size() > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.CASE_NOT_EXIST, (String)"");
            byte[] buffer = new byte[1024];
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            FileOutputStream fileOut = null;
            try {
                String filename = null;
                String filenameIso = null;
                if (list.size() == 1) {
                    filename = ((DossAttachmentResDTO)list.get(0)).getFileName();
                    filenameIso = new String(filename.getBytes("UTF-8"), "iso-8859-1");
                    response.addHeader("Content-Disposition", "attachment;fileName=" + filenameIso);
                    DubboResult fileInfo = this.fileStorageApi.getFileInfo(((DossAttachmentResDTO)list.get(0)).getFileId());
                    FileInfoResponseDTO data = (FileInfoResponseDTO)fileInfo.getData();
                    ServletOutputStream outputStream = response.getOutputStream();
                    outputStream.write(data.getFileByte());
                } else if (list.size() > 1) {
                    response.setContentType("APPLICATION/OCTET-STREAM");
                    response.setHeader("Content-Disposition", "attachment; filename=" + filename);
                    ZipOutputStream out = new ZipOutputStream(fileOut);
                    for (DossAttachmentResDTO dossierAttachmentResDTO : list) {
                        int len;
                        filename = dossierAttachmentResDTO.getFileName();
                        File file = new File(this.lawCaseDossierService.getStorageRootDir() + filename);
                        File zipFile = new File(this.lawCaseDossierService.getStorageRootDir());
                        String fileId = dossierAttachmentResDTO.getFileId();
                        DubboResult fileInfo = this.fileStorageApi.getFileInfo(fileId);
                        FileInfoResponseDTO data = (FileInfoResponseDTO)fileInfo.getData();
                        fileOut = new FileOutputStream(file);
                        bis = new BufferedInputStream(fis);
                        buffer = data.getFileByte();
                        out = new ZipOutputStream(new FileOutputStream(zipFile));
                        while ((len = fis.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                        response.flushBuffer();
                        out.closeEntry();
                    }
                }
            }
            catch (Exception e) {
                log.error("dossierDownload error {}", (Throwable)e);
                throw new AppException(ErrorCode.CASE_NOT_EXIST, e.getMessage());
            }
            finally {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(fis);
            }
        }
        return null;
    }

    @RequestMapping(value={"/dossierUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult dossierUpload(@RequestBody @Valid DossierFileRequestDTO dossierFileRequestDTO) {
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        if (dossierFileRequestDTO != null) {
            dossierFileRequestDTO.setUserId(userId);
            dossierFileRequestDTO.setUserName(this.userDubboService.getUserNameByJWT());
            dossierFileRequestDTO.setRoles(JWTContextUtil.getRoles());
        }
        this.lawCasePersonnelApi.checkUpload(userId, dossierFileRequestDTO.getCaseId());
        String result = this.lawCaseDossierService.uploadFile(dossierFileRequestDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u89c6\u9891\u671f\u95f4\u5220\u9664\u6587\u4ef6", notes="\u89c6\u9891\u671f\u95f4\u5220\u9664\u6587\u4ef6")
    @RequestMapping(value={"/delFile"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult delFile(@RequestBody @Valid DelFileRequestDTO delFileRequestDTO) {
        if (null != delFileRequestDTO) {
            delFileRequestDTO.setRoles(JWTContextUtil.getRoles());
            delFileRequestDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        }
        String result = this.lawCaseDossierService.delFile(delFileRequestDTO);
        AssertUtils.assertNull((Object)result, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u5377\u5b97\u6570\u636e\u56de\u663e", notes="\u5377\u5b97\u6570\u636e\u56de\u663e")
    @RequestMapping(value={"/displayFileDossier"}, method={RequestMethod.POST})
    @ResponseBody
    public APIResult displayFileDossier(@RequestBody @Valid CaseIdRequestDTO caseIdRequestDTO) {
        DisplayDossierResDTO display = this.lawCaseDossierService.displayFileDossiers(caseIdRequestDTO.getCaseId());
        return APIResult.success((Object)display);
    }
}

