/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.controller;

import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.mastiff.common.constants.MastiffMessages;
import com.beiming.odr.mastiff.common.enums.ErrorCode;
import com.beiming.odr.mastiff.common.utils.MastiffMsgUtils;
import com.beiming.odr.mastiff.domain.dto.requestdto.AssignOrgRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.AuditCaseIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CaseDeclinedRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.DeleteCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.EditCaseDisputeRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationReallocateRequsetDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationSuccessFailRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.MediationSuspendRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.PetitionAgentRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.ReapportionMediatorApplicationRequsetDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveCaseUserListRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.SaveCaseUserRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.TransferMediationRequestDTO;
import com.beiming.odr.mastiff.domain.dto.requestdto.UpdateCaseRequestDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.MediationCaseResponseDTO;
import com.beiming.odr.mastiff.domain.dto.responsedto.SaveCaseUserResponseDTO;
import com.beiming.odr.mastiff.interceptor.Access;
import com.beiming.odr.mastiff.service.backend.user.UserDubboService;
import com.beiming.odr.mastiff.service.client.CaseService;
import com.beiming.odr.mastiff.service.client.DisputeRegistrarService;
import com.beiming.odr.mastiff.service.client.MediationMeetingService;
import com.beiming.odr.mastiff.service.utils.CaseCheckHelper;
import com.beiming.odr.referee.api.DictServiceApi;
import com.beiming.odr.referee.api.ThirdPartApi;
import com.beiming.odr.referee.dto.DictDTO;
import com.beiming.odr.referee.dto.requestdto.DictReqDTO;
import com.beiming.odr.referee.dto.requestdto.FailCancelCaseReqDTO;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserRoleEnum;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/mastiff/case"})
@RestController
public class CaseController {
    @Resource
    private CaseService caseService;
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private MastiffMessages mastiffMessages;
    @Resource
    private DictServiceApi dictServiceApi;
    @Resource
    private DisputeRegistrarService disputeRegistrarService;
    @Resource
    private ThirdPartApi thirdPartApi;

    @ApiOperation(value="\u4fdd\u5b58\u8c03\u89e3\u6848\u4ef6", notes="\u4fdd\u5b58\u8c03\u89e3\u6848\u4ef6", response=MediationCaseResponseDTO.class)
    @RequestMapping(value={"/saveCase"}, method={RequestMethod.POST}, produces={"application/json"})
    @Access(authorities={UserRoleEnum.COMMON, UserRoleEnum.DISPUTE_REGISTRAR})
    public APIResult saveCase(@RequestBody @Valid MediationCaseRequestDTO dto) {
        if (dto.getPetitionAgentDTO() != null) {
            CaseCheckHelper.checkPetitionAgentInfo((PetitionAgentRequestDTO)dto.getPetitionAgentDTO(), (List)dto.getApplyUserList(), (List)dto.getRespondentUserList());
        }
        CaseCheckHelper.checkApplicantRequired((List)dto.getApplyUserList());
        CaseCheckHelper.checkRespondentRequired((List)dto.getRespondentUserList());
        MediationCaseResponseDTO responseDTO = this.caseService.saveCase(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u672a\u63d0\u4ea4\u8c03\u89e3\u6848\u4ef6", notes="\u4fdd\u5b58\u672a\u63d0\u4ea4\u8c03\u89e3\u6848\u4ef6", response=MediationCaseResponseDTO.class)
    @RequestMapping(value={"/saveCaseUnsubmit"}, method={RequestMethod.POST}, produces={"application/json"})
    @Access(authorities={UserRoleEnum.COMMON, UserRoleEnum.DISPUTE_REGISTRAR})
    public APIResult saveCaseUnsubmit(@RequestBody MediationCaseRequestDTO dto) {
        MediationCaseResponseDTO responseDTO = this.disputeRegistrarService.saveCaseUnsubmit(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u7f16\u8f91\u672a\u63d0\u4ea4\u8c03\u89e3\u6848\u4ef6", notes="\u7f16\u8f91\u672a\u63d0\u4ea4\u8c03\u89e3\u6848\u4ef6", response=UpdateCaseRequestDTO.class)
    @RequestMapping(value={"/updateCaseUnsubmit"}, method={RequestMethod.POST}, produces={"application/json"})
    @Access(authorities={UserRoleEnum.COMMON, UserRoleEnum.DISPUTE_REGISTRAR})
    public APIResult updateCaseUnsubmit(@RequestBody UpdateCaseRequestDTO dto) {
        this.disputeRegistrarService.updateCaseUnsubmit(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u63d0\u4ea4\u672a\u63d0\u4ea4\u8c03\u89e3\u6848\u4ef6", notes="\u63d0\u4ea4\u672a\u63d0\u4ea4\u8c03\u89e3\u6848\u4ef6", response=MediationCaseResponseDTO.class)
    @RequestMapping(value={"/submitThenSaveCase"}, method={RequestMethod.POST}, produces={"application/json"})
    @Access(authorities={UserRoleEnum.COMMON, UserRoleEnum.DISPUTE_REGISTRAR})
    public APIResult submitThenSaveCase(@RequestBody @Valid MediationCaseRequestDTO dto) {
        if (dto.getPetitionAgentDTO() != null) {
            CaseCheckHelper.checkPetitionAgentInfo((PetitionAgentRequestDTO)dto.getPetitionAgentDTO(), (List)dto.getApplyUserList(), (List)dto.getRespondentUserList());
        }
        CaseCheckHelper.checkApplicantRequired((List)dto.getApplyUserList());
        CaseCheckHelper.checkRespondentRequired((List)dto.getRespondentUserList());
        MediationCaseResponseDTO responseDTO = this.disputeRegistrarService.submitThenSaveCase(dto);
        return APIResult.success((Object)responseDTO);
    }

    @ApiOperation(value="\u5220\u9664\u8c03\u89e3\u6848\u4ef6", notes="\u5220\u9664\u8c03\u89e3\u6848\u4ef6", response=MediationCaseResponseDTO.class)
    @RequestMapping(value={"/deleteCase"}, method={RequestMethod.POST}, produces={"application/json"})
    @Access(authorities={UserRoleEnum.COMMON, UserRoleEnum.DISPUTE_REGISTRAR})
    public APIResult deleteCase(@RequestBody MediationCaseRequestDTO mediationCaseRequestDTO) {
        List list = JWTContextUtil.getRoles();
        if (!list.contains(UserRoleEnum.DISPUTE_REGISTRAR.name())) {
            return APIResult.failed((APIResultCode)ErrorCode.DELETE_CASE_FAIL, (String)"\u5220\u9664\u6848\u4ef6\u5931\u8d25\uff0c\u5f53\u524d\u4eba\u7269\u6743\u9650\u8865\u4e0d\u8db3");
        }
        this.disputeRegistrarService.deleteCase(mediationCaseRequestDTO);
        return APIResult.success();
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6848\u4ef6\u4eba", notes="\u65b0\u589e\u6216\u4fee\u6539\u6848\u4ef6\u4eba")
    @RequestMapping(value={"/saveCaseUser"}, method={RequestMethod.POST})
    public APIResult saveCaseUser(@RequestBody SaveCaseUserRequestDTO dto) {
        ArrayList list = Lists.newArrayList();
        list.add(dto);
        if (CaseUserTypeEnum.APPLICANT.equals((Object)dto.getCaseUserType())) {
            CaseCheckHelper.checkApplicantRequired((List)list);
        }
        if (CaseUserTypeEnum.RESPONDENT.equals((Object)dto.getCaseUserType())) {
            CaseCheckHelper.checkRespondentRequired((List)list);
        }
        SaveCaseUserResponseDTO result = this.caseService.saveOrEditCaseUser(dto);
        return APIResult.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6c11\u65cf09_00005\u3001\u56fd\u7c4d15_GB0006\u3001\u8bc1\u4ef6\u7c7b\u578b09_00015", notes="\u4f2009_00005\u83b7\u53d6\u6c11\u65cf\u3001\u4f2015_GB0006\u83b7\u53d6\u56fd\u7c4d\u3001\u4f2009_00015\u8bc1\u4ef6\u7c7b\u578b\u3002\u8fd4\u56de\u53c2\u6570\u53d6name\u5b57\u6bb5")
    @RequestMapping(value={"/getDictByPre"}, method={RequestMethod.GET})
    public APIResult getDictByPre(String pre) {
        DictReqDTO dictReqDTO = new DictReqDTO();
        dictReqDTO.setPre(pre);
        List byPre = this.dictServiceApi.getByPre(dictReqDTO);
        for (DictDTO item : byPre) {
            String key = "referee.gh_dict.code." + item.getCode();
            String value = MastiffMsgUtils.get((String)key);
            if (value.equals(key)) continue;
            item.setName(value);
        }
        return APIResult.success((Object)byPre);
    }

    @ApiOperation(value="\u83b7\u53d6\u6c11\u65cf09_00005\u3001\u56fd\u7c4d15_GB0006\u3001\u8bc1\u4ef6\u7c7b\u578b09_00015 \u652f\u6301\u4e0d\u540c\u8bed\u8a00\u4e0b\u7684\u6a21\u7cca\u641c\u7d22")
    @PostMapping(value={"/getDictList"})
    public APIResult getDictList(@RequestBody DictReqDTO dictReqDTO) {
        List byPre = this.dictServiceApi.getByPre(dictReqDTO);
        for (DictDTO item : byPre) {
            String key = "referee.gh_dict.code." + item.getCode();
            String value = MastiffMsgUtils.get((String)key);
            if (value.equals(key)) continue;
            item.setName(value);
        }
        return APIResult.success((Object)byPre);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u591a\u4e2a\u6848\u4ef6\u4eba", notes="\u65b0\u589e\u6216\u4fee\u6539\u591a\u4e2a\u6848\u4ef6\u4eba")
    @RequestMapping(value={"/saveCaseUserList"}, method={RequestMethod.POST})
    public APIResult saveCaseUserList(@Valid @RequestBody SaveCaseUserListRequestDTO dto) {
        List list = dto.getList();
        SaveCaseUserRequestDTO req = (SaveCaseUserRequestDTO)list.get(0);
        if (CaseUserTypeEnum.APPLICANT.equals((Object)req.getCaseUserType())) {
            CaseCheckHelper.checkApplicantRequired((List)list);
        }
        if (CaseUserTypeEnum.RESPONDENT.equals((Object)req.getCaseUserType())) {
            CaseCheckHelper.checkRespondentRequired((List)list);
        }
        this.caseService.saveCaseUserList(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u6848\u4ef6\u4eba", notes="\u5220\u9664\u6848\u4ef6\u4eba")
    @RequestMapping(value={"/deleteCaseUser"}, method={RequestMethod.POST})
    public APIResult deleteCasePersonnel(@Valid @RequestBody DeleteCaseUserRequestDTO dto) {
        this.caseService.deleteCasePersonnel(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u7f16\u8f91\u6848\u4ef6\u7ea0\u7eb7\u4fe1\u606f", notes="\u7f16\u8f91\u6848\u4ef6\u7ea0\u7eb7\u4fe1\u606f")
    @RequestMapping(value={"/editCaseDisputeInfo"}, method={RequestMethod.POST})
    public APIResult editCaseDisputeInfo(@Valid @RequestBody EditCaseDisputeRequestDTO dto) {
        this.caseService.editCaseDisputeInfo(dto);
        return APIResult.success();
    }

    @ApiOperation(value="\u53d1\u8d77\u64a4\u56de\u8c03\u89e3\u6848\u4ef6\u5ba1\u6838", notes="\u53d1\u8d77\u64a4\u56de\u8c03\u89e3\u6848\u4ef6\u5ba1\u6838", response=Integer.class)
    @RequestMapping(value={"/startRetractCase"}, method={RequestMethod.POST})
    public APIResult startRetractCase(@Valid @RequestBody AuditCaseIdRequestDTO dto) {
        Integer result = this.caseService.startRetractCase(dto);
        return APIResult.success((Object)result);
    }

    @ApiOperation(value="\u53d1\u8d77\u7533\u8bf7\u6216\u8005\u5ba1\u6838\u8be6\u60c5\u9875\u9762\u5c55\u793a", notes="\u53d1\u8d77\u7533\u8bf7\u6216\u8005\u5ba1\u6838\u8be6\u60c5\u9875\u9762\u5c55\u793a", response=Integer.class)
    @RequestMapping(value={"/applyOrAuditDetail"}, method={RequestMethod.POST})
    public APIResult applyOrAuditDetail(@Valid @RequestBody AuditCaseIdRequestDTO dto) {
        ArrayList result = this.caseService.applyOrAuditDetail(dto);
        return APIResult.success((Object)result);
    }

    @ApiOperation(value="\u64a4\u56de\u8c03\u89e3\u6848\u4ef6\u5ba1\u6838", notes="\u64a4\u56de\u8c03\u89e3\u6848\u4ef6\u5ba1\u6838", response=Integer.class)
    @RequestMapping(value={"/auditRetractCase"}, method={RequestMethod.POST})
    public APIResult auditRetractCase(@Valid @RequestBody AuditCaseIdRequestDTO dto) {
        Integer result = this.caseService.auditRetractCase(dto);
        return APIResult.success((Object)result);
    }

    @ApiOperation(value="\u64a4\u56de\u8c03\u89e3\u6848\u4ef6", notes="\u64a4\u56de\u8c03\u89e3\u6848\u4ef6", response=Integer.class)
    @RequestMapping(value={"/retractCase"}, method={RequestMethod.POST})
    @Access(authorities={UserRoleEnum.COMMON})
    public APIResult retractCase(@Valid @RequestBody FailCancelCaseReqDTO dto) {
        Integer result = this.caseService.cancelCase(dto);
        return APIResult.success((Object)result);
    }

    @ApiOperation(value="syncToHngs", notes="syncToHngs")
    @RequestMapping(value={"/syncToHngs"}, method={RequestMethod.POST})
    public APIResult syncToHngs(@RequestBody @Valid MediationSuccessFailRequestDTO requestDTO) {
        this.thirdPartApi.syncToHngs(requestDTO.getCaseId(), CaseStatusEnum.FAIL_MEDIATION, requestDTO.getReasonType(), requestDTO.getDetailRason());
        return APIResult.success();
    }

    @ApiOperation(value="\u8c03\u89e3\u6210\u529f", notes="\u8c03\u89e3\u6210\u529f")
    @RequestMapping(value={"/mediateSuccess"}, method={RequestMethod.POST})
    public APIResult mediateSuccess(@RequestBody @Valid MediationSuccessFailRequestDTO requestDTO) {
        String result = this.mediationMeetingService.mediationSuccess(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.UNEXCEPTED, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u8c03\u89e3\u7ec8\u6b62(\u76f8\u5f53\u4e8e\u8fd4\u56de\u673a\u6784\u91cd\u65b0\u5206\u914d)", notes="\u8c03\u89e3\u7ec8\u6b62(\u76f8\u5f53\u4e8e\u8fd4\u56de\u673a\u6784\u91cd\u65b0\u5206\u914d)")
    @RequestMapping(value={"/mediateSuspend"}, method={RequestMethod.POST})
    public APIResult mediateSuspend(@RequestBody @Valid MediationSuspendRequestDTO requestDTO) {
        String result = this.mediationMeetingService.mediationSuspend(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.UNEXCEPTED, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u8c03\u89e3\u5931\u8d25", notes="\u8c03\u89e3\u5931\u8d25")
    @RequestMapping(value={"/mediateFail"}, method={RequestMethod.POST})
    public APIResult mediateFail(@RequestBody @Valid MediationSuccessFailRequestDTO requestDTO) {
        String result = this.mediationMeetingService.mediationFail(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.TRANSFER_BUSINESS, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u7533\u8bf7\u91cd\u65b0\u5206\u914d\u8c03\u89e3\u5458", notes="\u7533\u8bf7\u91cd\u65b0\u5206\u914d\u8c03\u89e3\u5458")
    @RequestMapping(value={"/assignMediatorAgain"}, method={RequestMethod.POST})
    public APIResult assignMediatorAgain(@RequestBody @Valid MediationReallocateRequsetDTO requestDTO) {
        String result = this.mediationMeetingService.reallocate(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.TRANSFER_BUSINESS, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u5206\u914d\u8c03\u89e3\u5458", notes="\u5206\u914d\u8c03\u89e3\u5458")
    @RequestMapping(value={"/assignMediator"}, method={RequestMethod.POST})
    public APIResult assignMediator(@RequestBody @Valid ReapportionMediatorApplicationRequsetDTO requestDTO) {
        String result = this.mediationMeetingService.reMediatorApplication(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.TRANSFER_BUSINESS, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u53d7\u7406\u8c03\u89e3", notes="\u53d7\u7406\u8c03\u89e3")
    @RequestMapping(value={"/acceptCase"}, method={RequestMethod.POST})
    public APIResult acceptCase(@RequestBody @Valid CommonIdRequestDTO requestDTO) {
        String result = this.mediationMeetingService.accept(requestDTO.getId(), Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.TRANSFER_BUSINESS, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u4e0d\u53d7\u7406\u8c03\u89e3", notes="\u4e0d\u53d7\u7406\u8c03\u89e3")
    @RequestMapping(value={"/rejectCase"}, method={RequestMethod.POST})
    public APIResult rejectCase(@RequestBody @Valid CaseDeclinedRequestDTO requestDTO) {
        String result = this.mediationMeetingService.caseDeclined(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.TRANSFER_BUSINESS, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u8f6c\u79fb\u8c03\u89e3\u673a\u6784", notes="\u8f6c\u79fb\u8c03\u89e3\u673a\u6784")
    @RequestMapping(value={"/changeOrg"}, method={RequestMethod.POST})
    public APIResult changeOrg(@RequestBody @Valid TransferMediationRequestDTO requestDTO) {
        String result = this.mediationMeetingService.transferMediation(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.TRANSFER_BUSINESS, (String)result);
        return APIResult.success();
    }

    @ApiOperation(value="\u5206\u914d\u8c03\u89e3\u673a\u6784", notes="\u5206\u914d\u8c03\u89e3\u673a\u6784")
    @RequestMapping(value={"/assignOrg"}, method={RequestMethod.POST})
    public APIResult assignOrg(@RequestBody @Valid AssignOrgRequestDTO requestDTO) {
        String result = this.mediationMeetingService.assignOrg(requestDTO, Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        AssertUtils.assertNull((Object)result, (ResultCode)ErrorCode.ASSIGN_ORG_BUSINESS, (String)result);
        return APIResult.success();
    }

    @RequestMapping(value={"il8nTest"}, method={RequestMethod.POST})
    @ApiOperation(value="\u56fd\u9645\u5316\u6d4b\u8bd5", notes="\u56fd\u9645\u5316\u6d4b\u8bd5")
    public void il8nTest(@RequestBody @Valid AssignOrgRequestDTO requestDTO) {
        Locale locale = LocaleContextHolder.getLocale();
        System.out.println("\u56fd\u9645\u5316\u6d4b\u8bd5,\u5f53\u524d\u8bed\u8a00\u73af\u5883->" + locale.getLanguage());
        System.out.println("\u5e38\u91cf->" + this.mastiffMessages.getParameterNotBlank());
    }
}

