/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.interceptor;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.mastiff.common.enums.MastiffRedisKeyEnums;
import com.beiming.odr.mastiff.common.utils.ExtAccessAnnotation;
import com.beiming.odr.mastiff.common.utils.SHAUtil;
import com.beiming.odr.mastiff.common.utils.SpringContextUtil;
import com.beiming.odr.mastiff.service.thirty.tdh.ExtraInterfaceService;
import com.beiming.odr.referee.dto.responsedto.ThirdPartyConfigResDTO;
import com.beiming.odr.referee.enums.SendTDHErrorEnum;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ExtAccessInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(ExtAccessInterceptor.class);
    @Resource
    private ExtraInterfaceService extraInterfaceService;
    @Resource
    private RedisService redisService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("\u7b2c\u4e09\u65b9\u8bf7\u6c42\u8fdb\u5165\u9a8c\u8bc1.................");
        if (null == this.extraInterfaceService) {
            this.extraInterfaceService = (ExtraInterfaceService)SpringContextUtil.getBean(ExtraInterfaceService.class);
        }
        if (null == this.redisService) {
            this.redisService = (RedisService)SpringContextUtil.getBean(RedisService.class);
        }
        HashMap headers = Maps.newHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            headers.put(key, request.getHeader(key));
        }
        log.info("request header = {}", (Object)headers);
        response.setStatus(200);
        response.setContentType("application/json;charset=UTF-8");
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            ExtAccessAnnotation access = Optional.ofNullable(method.getAnnotation(ExtAccessAnnotation.class)).orElseGet(() -> handlerMethod.getClass().getAnnotation(ExtAccessAnnotation.class));
            if (access == null) {
                return true;
            }
            String appId = (String)headers.get("appid");
            ThirdPartyConfigResDTO config = this.extraInterfaceService.getAppSecretByAppId(appId);
            if (access.verifySign()) {
                this.verifySign((Map)headers, config);
            }
            if (access.verifyToken()) {
                this.verifyToken((Map)headers);
            }
        }
        return true;
    }

    private void verifyToken(Map<String, String> request) {
        String appId = request.get("appid");
        String accessToken = request.get("accesstoken");
        String token = (String)this.redisService.get((RedisKey)MastiffRedisKeyEnums.THIRD_PARTY_TOKEN, appId);
        AssertUtils.assertTrue((StringUtils.isNotBlank((CharSequence)accessToken) && StringUtils.isEquals((String)accessToken, (String)token) ? 1 : 0) != 0, (ResultCode)SendTDHErrorEnum.NO_ACCESS_TOKEN, (String)SendTDHErrorEnum.NO_ACCESS_TOKEN.getName());
    }

    private void verifySign(Map<String, String> request, ThirdPartyConfigResDTO config) {
        String appId = request.get("appid");
        String timestamp = request.get("timestamp");
        String signature = request.get("signature");
        StringBuffer sb = new StringBuffer();
        sb.append(timestamp).append(appId).append(config.getAppSecret());
        String newSign = SHAUtil.getSHA256Str((String)sb.toString());
        AssertUtils.assertTrue((boolean)StringUtils.isEquals((String)signature, (String)newSign), (ResultCode)SendTDHErrorEnum.SIGN_ERROR, (String)SendTDHErrorEnum.SIGN_ERROR.getName());
    }

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        System.out.println("\u5f53\u524d\u65f6\u95f4\u6233:" + l);
        String appId = "100046";
        String timestamp = String.valueOf(l);
        StringBuffer sb = new StringBuffer();
        sb.append(timestamp).append(appId).append("805bd4d396f72a9b");
        String newSign = SHAUtil.getSHA256Str((String)sb.toString());
        System.out.println("out signature " + newSign);
    }
}

