/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.mastiff.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.enums.CTypeEnums;
import com.beiming.framework.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class HeaderParameterInterceptor
extends HandlerInterceptorAdapter {
    private List<String> excludeUrls = Lists.newArrayList();

    public List<String> getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(List<String> excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Access-Control-Allow-Headers", "Origin,Content-Type,Accept,token,X-Requested-With,JWTToken,cType,deviceId,deviceModel,osVersion,appVersion,timer,appName,lang");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Max-Age", "86400");
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            return false;
        }
        String jwtToken = "";
        String requestUrl = request.getRequestURI();
        boolean deviceId = this.checkPass(this.excludeUrls, jwtToken, requestUrl);
        if (deviceId) {
            return deviceId;
        }
        if (request.getRequestURI().indexOf("swagger") <= -1 && request.getRequestURI().indexOf("v2/api-docs") <= -1) {
            return this.setSwagger(request, response, jwtToken);
        }
        return true;
    }

    public boolean checkPass(List<String> excludeUrls, String jwtToken2, String requestUrl) {
        boolean returnFlag = false;
        if (excludeUrls != null && excludeUrls.size() > 0) {
            for (String jwtToken2 : excludeUrls) {
                boolean deviceId = StringUtils.simpleWildcardMatch((String)jwtToken2, (String)requestUrl);
                if (!deviceId) continue;
                return deviceId;
            }
        }
        return returnFlag;
    }

    public boolean setSwagger(HttpServletRequest request, HttpServletResponse response, String jwtToken) throws IOException {
        if (RequestMethod.GET.name().equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        Boolean checkPassFlag1 = true;
        jwtToken = request.getHeader("JWTToken");
        String lang = request.getHeader("lang");
        String deviceId1 = request.getHeader("deviceId");
        String deviceModel = request.getHeader("deviceModel");
        String cType = request.getHeader("cType");
        String appVersion = request.getHeader("appVersion");
        String osVersion = request.getHeader("osVersion");
        String appName = request.getHeader("appName");
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            AppNameContextHolder.setAppName((String)appName.toLowerCase());
        }
        if (StringUtils.isBlank((String)cType) || StringUtils.isBlank((String)appName)) {
            checkPassFlag1 = false;
        }
        if (checkPassFlag1.booleanValue() && CTypeEnums.WECHAT.name().equalsIgnoreCase(cType) && (StringUtils.isBlank((String)deviceModel) || StringUtils.isBlank((String)osVersion))) {
            checkPassFlag1 = false;
        }
        if (checkPassFlag1.booleanValue() && (CTypeEnums.ANDROID.name().equalsIgnoreCase(cType) || CTypeEnums.IOS.name().equalsIgnoreCase(cType)) && (StringUtils.isBlank((String)deviceId1) || StringUtils.isBlank((String)deviceModel) || StringUtils.isBlank((String)osVersion) || StringUtils.isBlank((String)appVersion) || StringUtils.isBlank((String)appName))) {
            checkPassFlag1 = false;
        }
        if (!checkPassFlag1.booleanValue()) {
            response.setStatus(200);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().print(JSONObject.toJSONString((Object)APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.HEADER_PARAMETER_VALIDATE_FAIL, (String)APIResultCodeEnums.HEADER_PARAMETER_VALIDATE_FAIL.desc())));
            return false;
        }
        return true;
    }
}

